/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.StateMaskNode;
import org.simantics.scenegraph.utils.NodeUtil;

public class LinkNode
extends StateMaskNode {
    private static final long serialVersionUID = -7465071303188585400L;
    protected String delegateId;
    protected boolean ignoreDelegate = false;
    protected boolean lookupIdOwner = false;

    @INode.SyncField(value={"delegateId"})
    public void setDelegateId(String delegateId) {
        this.delegateId = delegateId;
    }

    @INode.SyncField(value={"delegateId", "lookupIdOwner"})
    public void setDelegateId(String delegateId, boolean owner) {
        this.delegateId = delegateId;
        this.lookupIdOwner = owner;
    }

    @INode.SyncField(value={"ignoreDelegate"})
    public void setIgnoreDelegate(boolean ignore) {
        this.ignoreDelegate = ignore;
    }

    @INode.SyncField(value={"lookupIdOwner"})
    public void setLookupIdOwner(boolean idOwner) {
        this.lookupIdOwner = idOwner;
    }

    @Override
    public void cleanup() {
        if (this.lookupIdOwner) {
            this.removeDelegateMapping();
        }
        super.cleanup();
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.hasFlags((byte)1)) {
            return;
        }
        IG2DNode n = this.getDelegate2D();
        if (n == null) {
            return;
        }
        if (this.ignoreDelegate && !(n instanceof G2DParentNode)) {
            return;
        }
        this.setFlags((byte)1);
        AffineTransform oldTransform = null;
        if (this.transform != null && !this.transform.isIdentity()) {
            g2d.transform(this.transform);
            oldTransform = g2d.getTransform();
        }
        try {
            if (!this.ignoreDelegate) {
                n.render(g2d);
            } else {
                G2DParentNode parent = (G2DParentNode)n;
                IG2DNode[] iG2DNodeArray = parent.getSortedNodes();
                int n2 = iG2DNodeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IG2DNode child = iG2DNodeArray[n3];
                    child.render(g2d);
                    ++n3;
                }
            }
        }
        catch (Throwable throwable) {
            if (oldTransform != null) {
                g2d.setTransform(oldTransform);
            }
            this.clearFlags((byte)1);
            throw throwable;
        }
        if (oldTransform != null) {
            g2d.setTransform(oldTransform);
        }
        this.clearFlags((byte)1);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.getBoundsInLocal(false);
    }

    @Override
    public Rectangle2D getBoundsInLocal(boolean ignoreNulls) {
        if (this.hasFlags((byte)2)) {
            return new Rectangle2D.Double();
        }
        IG2DNode n = this.getDelegate2D();
        if (n == null) {
            return new Rectangle2D.Double();
        }
        this.setFlags((byte)2);
        try {
            Rectangle2D bounds = n.getBoundsInLocal(ignoreNulls);
            if (this.transform != null && !this.transform.isIdentity()) {
                bounds = this.transform.createTransformedShape(bounds).getBounds2D();
            }
            Rectangle2D rectangle2D = bounds;
            return rectangle2D;
        }
        finally {
            this.clearFlags((byte)2);
        }
    }

    protected IG2DNode getDelegate2D() {
        INode node = NodeUtil.lookup(this, this.delegateId);
        if (node instanceof IG2DNode) {
            return (IG2DNode)node;
        }
        return null;
    }

    public INode getDelegate() {
        INode node = NodeUtil.lookup(this, this.delegateId);
        if (node instanceof IG2DNode) {
            return (IG2DNode)node;
        }
        return null;
    }

    protected void removeDelegateMapping() {
        ILookupService lookup = NodeUtil.getLookupService(this);
        lookup.unmap(this.delegateId);
    }

    @Override
    public String toString() {
        return super.toString() + "[delegateId=" + this.delegateId + "]";
    }
}

