/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;

public class EventHandlerReflection {
    public static EventHandlerDefinition[] getEventHandlers(final Object obj) {
        ArrayList<EventHandlerDefinition> result = new ArrayList<EventHandlerDefinition>();
        Class<?> clazz = obj.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                final Method m = methodArray[n2];
                EventHandler anno = m.getAnnotation(EventHandler.class);
                if (anno != null) {
                    Class<?> returnType = m.getReturnType();
                    if (!returnType.equals(Boolean.TYPE)) {
                        throw new RuntimeException(clazz.getName() + "." + m.getName() + " return type is invalid");
                    }
                    Class<?>[] argTypes = m.getParameterTypes();
                    if (argTypes.length != 1 || !Event.class.isAssignableFrom(argTypes[0])) {
                        throw new RuntimeException(clazz.getName() + "." + m.getName() + " invalid arguments");
                    }
                    Class<Event> argClass = argTypes[0];
                    Class<?>[] exceptionTypes = m.getExceptionTypes();
                    if (exceptionTypes.length != 0) {
                        throw new RuntimeException(clazz.getName() + "." + m.getName() + " invalid exceptions");
                    }
                    int priority = anno.priority();
                    try {
                        m.setAccessible(true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        break block7;
                    }
                    final int eventMask = EventTypes.toTypeMask(argClass);
                    IEventHandler eventHandler = new IEventHandler(){

                        @Override
                        public int getEventMask() {
                            return eventMask;
                        }

                        @Override
                        public boolean handleEvent(Event e1) {
                            try {
                                return (Boolean)m.invoke(obj, e1);
                            }
                            catch (IllegalArgumentException e) {
                                throw new Error(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e.getCause());
                            }
                        }
                    };
                    EventHandlerDefinition handler = new EventHandlerDefinition(obj, eventHandler, priority, argClass);
                    result.add(handler);
                }
            }
            ++n2;
        }
        return result.toArray(new EventHandlerDefinition[0]);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface EventHandler {
        public int priority();
    }

    public static final class EventHandlerDefinition {
        public final Object obj;
        public final IEventHandler origEventHandler;
        public final IEventHandler eventHandler;
        public final int priority;
        public final Class<Event> eventSuperClass;

        public EventHandlerDefinition(Object obj, IEventHandler eventHandler, int priority, Class<Event> eventSuperClass) {
            this.obj = obj;
            this.priority = priority;
            this.eventSuperClass = eventSuperClass;
            this.origEventHandler = eventHandler;
            final int eventMask = EventTypes.toTypeMask(eventSuperClass);
            this.eventHandler = eventSuperClass.equals(Event.class) ? eventHandler : new IEventHandler(){

                @Override
                public int getEventMask() {
                    return eventMask;
                }

                @Override
                public boolean handleEvent(Event e) {
                    if (eventSuperClass.isAssignableFrom(e.getClass())) {
                        return origEventHandler.handleEvent(e);
                    }
                    return false;
                }

                public String toString() {
                    return this.toString();
                }
            };
        }

        public String toString() {
            return String.format("[%11d] %s (%s)", this.priority, this.obj.getClass().getSimpleName(), this.eventSuperClass.getSimpleName());
        }
    }
}

