/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi;

import com.infomatiq.jsi.Point;

public class Rectangle {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;

    public Rectangle() {
        this.minX = Double.MAX_VALUE;
        this.minY = Double.MAX_VALUE;
        this.maxX = -1.7976931348623157E308;
        this.maxY = -1.7976931348623157E308;
    }

    public Rectangle(double x1, double y1, double x2, double y2) {
        this.set(x1, y1, x2, y2);
    }

    public void set(double x1, double y1, double x2, double y2) {
        this.minX = Math.min(x1, x2);
        this.maxX = Math.max(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxY = Math.max(y1, y2);
    }

    public void set(Rectangle r) {
        this.minX = r.minX;
        this.minY = r.minY;
        this.maxX = r.maxX;
        this.maxY = r.maxY;
    }

    public Rectangle copy() {
        return new Rectangle(this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean edgeOverlaps(Rectangle r) {
        return this.minX == r.minX || this.maxX == r.maxX || this.minY == r.minY || this.maxY == r.maxY;
    }

    public boolean intersects(Rectangle r) {
        return this.maxX >= r.minX && this.minX <= r.maxX && this.maxY >= r.minY && this.minY <= r.maxY;
    }

    public static boolean intersects(double r1MinX, double r1MinY, double r1MaxX, double r1MaxY, double r2MinX, double r2MinY, double r2MaxX, double r2MaxY) {
        return r1MaxX >= r2MinX && r1MinX <= r2MaxX && r1MaxY >= r2MinY && r1MinY <= r2MaxY;
    }

    public boolean contains(Rectangle r) {
        return this.maxX >= r.maxX && this.minX <= r.minX && this.maxY >= r.maxY && this.minY <= r.minY;
    }

    public static boolean contains(double r1MinX, double r1MinY, double r1MaxX, double r1MaxY, double r2MinX, double r2MinY, double r2MaxX, double r2MaxY) {
        return r1MaxX >= r2MaxX && r1MinX <= r2MinX && r1MaxY >= r2MaxY && r1MinY <= r2MinY;
    }

    public boolean containedBy(Rectangle r) {
        return r.maxX >= this.maxX && r.minX <= this.minX && r.maxY >= this.maxY && r.minY <= this.minY;
    }

    public double distance(Point p) {
        double distanceSquared = 0.0;
        double temp = this.minX - p.x;
        if (temp < 0.0) {
            temp = p.x - this.maxX;
        }
        if (temp > 0.0) {
            distanceSquared += temp * temp;
        }
        if ((temp = this.minY - p.y) < 0.0) {
            temp = p.y - this.maxY;
        }
        if (temp > 0.0) {
            distanceSquared += temp * temp;
        }
        return (float)Math.sqrt(distanceSquared);
    }

    public static double distance(double minX, double minY, double maxX, double maxY, double pX, double pY) {
        return (float)Math.sqrt(Rectangle.distanceSq(minX, minY, maxX, maxY, pX, pY));
    }

    public static double distanceSq(double minX, double minY, double maxX, double maxY, double pX, double pY) {
        double distanceSqX = 0.0;
        double distanceSqY = 0.0;
        if (minX > pX) {
            distanceSqX = minX - pX;
            distanceSqX *= distanceSqX;
        } else if (pX > maxX) {
            distanceSqX = pX - maxX;
            distanceSqX *= distanceSqX;
        }
        if (minY > pY) {
            distanceSqY = minY - pY;
            distanceSqY *= distanceSqY;
        } else if (pY > maxY) {
            distanceSqY = pY - maxY;
            distanceSqY *= distanceSqY;
        }
        return distanceSqX + distanceSqY;
    }

    public double distance(Rectangle r) {
        double leastMax;
        double distanceSquared = 0.0;
        double greatestMin = Math.max(this.minX, r.minX);
        if (greatestMin > (leastMax = Math.min(this.maxX, r.maxX))) {
            distanceSquared += (greatestMin - leastMax) * (greatestMin - leastMax);
        }
        if ((greatestMin = Math.max(this.minY, r.minY)) > (leastMax = Math.min(this.maxY, r.maxY))) {
            distanceSquared += (greatestMin - leastMax) * (greatestMin - leastMax);
        }
        return (float)Math.sqrt(distanceSquared);
    }

    public double enlargement(Rectangle r) {
        double enlargedArea = (Math.max(this.maxX, r.maxX) - Math.min(this.minX, r.minX)) * (Math.max(this.maxY, r.maxY) - Math.min(this.minY, r.minY));
        return enlargedArea - this.area();
    }

    public static double enlargement(double r1MinX, double r1MinY, double r1MaxX, double r1MaxY, double r2MinX, double r2MinY, double r2MaxX, double r2MaxY) {
        double r1r2UnionArea;
        double r1Area = (r1MaxX - r1MinX) * (r1MaxY - r1MinY);
        if (r1Area == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (r2MinX < r1MinX) {
            r1MinX = r2MinX;
        }
        if (r2MinY < r1MinY) {
            r1MinY = r2MinY;
        }
        if (r2MaxX > r1MaxX) {
            r1MaxX = r2MaxX;
        }
        if (r2MaxY > r1MaxY) {
            r1MaxY = r2MaxY;
        }
        if ((r1r2UnionArea = (r1MaxX - r1MinX) * (r1MaxY - r1MinY)) == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return r1r2UnionArea - r1Area;
    }

    public double area() {
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }

    public static double area(double minX, double minY, double maxX, double maxY) {
        return (maxX - minX) * (maxY - minY);
    }

    public void add(Rectangle r) {
        if (r.minX < this.minX) {
            this.minX = r.minX;
        }
        if (r.maxX > this.maxX) {
            this.maxX = r.maxX;
        }
        if (r.minY < this.minY) {
            this.minY = r.minY;
        }
        if (r.maxY > this.maxY) {
            this.maxY = r.maxY;
        }
    }

    public void add(Point p) {
        if (p.x < this.minX) {
            this.minX = p.x;
        }
        if (p.x > this.maxX) {
            this.maxX = p.x;
        }
        if (p.y < this.minY) {
            this.minY = p.y;
        }
        if (p.y > this.maxY) {
            this.maxY = p.y;
        }
    }

    public Rectangle union(Rectangle r) {
        Rectangle union = this.copy();
        union.add(r);
        return union;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof Rectangle) {
            Rectangle r = (Rectangle)o;
            if (this.minX == r.minX && this.minY == r.minY && this.maxX == r.maxX && this.maxY == r.maxY) {
                equals = true;
            }
        }
        return equals;
    }

    public boolean sameObject(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return "(" + this.minX + ", " + this.minY + "), (" + this.maxX + ", " + this.maxY + ")";
    }

    public double width() {
        return this.maxX - this.minX;
    }

    public double height() {
        return this.maxY - this.minY;
    }

    public double aspectRatio() {
        return this.width() / this.height();
    }

    public Point centre() {
        return new Point((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }
}

