/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.schema;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.annotations.GetType;
import org.simantics.objmap.graph.annotations.SetType;
import org.simantics.objmap.graph.schema.SimpleLinkType;

public class DynamicSimpleLinkType<Range>
extends SimpleLinkType<Range> {
    protected Method typeGetter;
    protected Method typeSetter;

    public DynamicSimpleLinkType(Resource domainType, Class<?> rangeType, ArrayList<IBidirectionalMappingRule<Resource, Range>> rules) {
        super(domainType, rangeType, rules);
        this.findTypeGetter(rangeType);
    }

    public DynamicSimpleLinkType(Resource domainType, Class<?> rangeType) {
        super(domainType, rangeType);
        this.findTypeGetter(rangeType);
    }

    private void findTypeGetter(Class<?> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            SetType t2;
            Method m = methodArray[n2];
            m.setAccessible(true);
            GetType t = m.getAnnotation(GetType.class);
            if (t != null) {
                this.typeGetter = m;
            }
            if ((t2 = m.getAnnotation(SetType.class)) != null) {
                this.typeSetter = m;
            }
            ++n2;
        }
        if (this.typeGetter == null || this.typeSetter == null) {
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz != Object.class) {
                this.findTypeGetter(superClazz);
            }
            if (this.typeGetter == null || this.typeSetter == null) {
                throw new RuntimeException("Cannot find dynamic type methods for class " + clazz.getSimpleName());
            }
        }
    }

    @Override
    public Resource createDomainElement(WriteGraph g, Range rangeElement) throws MappingException {
        try {
            String typeUri = (String)this.typeGetter.invoke(rangeElement, null);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("SimpleLinkType.createDomainElement " + rangeElement.toString());
            }
            Resource actualDomainType = g.getResource(typeUri);
            Resource result = g.newResource();
            g.claim(result, Layer0.getInstance((ReadGraph)g).InstanceOf, null, actualDomainType);
            return result;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
    }

    @Override
    public Range createRangeElement(ReadGraph g, Resource domainElement) throws MappingException {
        try {
            if (LOGGER.isTraceEnabled()) {
                try {
                    LOGGER.trace("SimpleLinkType.createRangeElement " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement));
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            Object r = this.rangeType.newInstance();
            Resource type = g.getSingleType(domainElement, this.domainType);
            String uri = g.getURI(type);
            this.typeSetter.invoke(r, uri);
            return (Range)r;
        }
        catch (InstantiationException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
    }
}

