/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.domain;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.graph.rules.domain.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedObjectsAccessor
implements IDomainAccessor<Resource, Collection<Resource>> {
    static Logger LOGGER = LoggerFactory.getLogger(RelatedObjectsAccessor.class);
    Resource relation;
    boolean deleteExtraObjects;

    public RelatedObjectsAccessor(Resource relation, boolean deleteExtraObjects) {
        this.relation = relation;
        this.deleteExtraObjects = deleteExtraObjects;
    }

    @Override
    public Collection<Resource> get(ReadGraph g, Resource element) throws MappingException {
        try {
            LOGGER.trace("        RelatedObjectsAccessor.get");
            return g.getObjects(element, this.relation);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Collection<Resource> value) throws MappingException {
        try {
            LOGGER.trace("        RelatedObjectsAccessor.set");
            return MappingUtils.synchronizeStatements(g, element, this.relation, value.toArray(new Resource[value.size()]), this.deleteExtraObjects);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }
}

