/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.wizard;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.wizard.ImportPlan;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class DrawingTemplateImportPage
extends WizardPage {
    String failure;
    ImportPlan importModel;
    Text importTarget;
    CCombo importLocation;
    List<NamedResource> models = Collections.emptyList();
    Button overwrite;

    protected DrawingTemplateImportPage(ImportPlan model) {
        super("Import Diagram Template", "Define Import Location", null);
        this.importModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("Import target:");
        this.importTarget = new Text(container, 2048);
        this.importTarget.setEditable(false);
        this.importTarget.setText("");
        this.importTarget.setToolTipText("Shows the target of the import.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.importTarget);
        new Label(container, 0).setText("&Diagram template file:");
        this.importLocation = new CCombo(container, 2048);
        this.importLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.importLocation);
        this.importLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DrawingTemplateImportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Br&owse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(DrawingTemplateImportPage.this.getShell(), 4096);
                dialog.setText("Choose Diagram Template to Import");
                String loc = DrawingTemplateImportPage.this.importLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.diagramTemplate;*.drawingTemplate"});
                dialog.setFilterNames(new String[]{"Diagram Template (*.diagramTemplate, *.drawingTemplate)"});
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                DrawingTemplateImportPage.this.importLocation.setText(file);
                DrawingTemplateImportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        NamedResource target = (NamedResource)this.importModel.sessionContext.getSession().syncRequest((Read)new Read<NamedResource>(){

            public NamedResource perform(ReadGraph graph) throws DatabaseException {
                Resource lib;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                for (Resource r : ISelectionUtils.getPossibleKeys((Object)DrawingTemplateImportPage.this.importModel.selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class)) {
                    lib = this.findTemplateLibrary(graph, r);
                    if (lib == null) continue;
                    return this.toNamedResource(graph, lib);
                }
                for (Resource r : (Collection)graph.sync((ReadInterface)new ObjectsWithType(Simantics.getProjectResource(), L0.ConsistsOf, MOD.StructuralModel))) {
                    lib = this.findTemplateLibrary(graph, r);
                    if (lib == null) continue;
                    return this.toNamedResource(graph, lib);
                }
                return null;
            }

            private Resource findTemplateLibrary(ReadGraph graph, Resource r) throws DatabaseException {
                Iterator iterator;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Template2dResource TMPL = Template2dResource.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(r, TMPL.DrawingTemplateLibrary)) {
                    return r;
                }
                Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(r));
                if (model != null && (iterator = ((Collection)graph.sync((ReadInterface)new ObjectsWithType(model, L0.ConsistsOf, TMPL.DrawingTemplateLibrary))).iterator()).hasNext()) {
                    Resource child = (Resource)iterator.next();
                    return child;
                }
                return null;
            }

            private NamedResource toNamedResource(ReadGraph graph, Resource lib) throws DatabaseException {
                Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(lib));
                if (model == null) {
                    return new NamedResource(NameUtils.getSafeName((ReadGraph)graph, (Resource)lib), lib);
                }
                return new NamedResource(NameUtils.getSafeName((ReadGraph)graph, (Resource)model) + ": " + NameUtils.getSafeName((ReadGraph)graph, (Resource)lib), lib);
            }
        });
        if (target == null) {
            this.failure = "No models with diagram template libraries found in the database.";
            return;
        }
        this.importTarget.setText(target.getName());
        this.importModel.selection = target.getResource();
        for (String path : this.importModel.recentLocations) {
            this.importLocation.add(path);
        }
        if (this.importLocation.getItemCount() > 0) {
            this.importLocation.select(0);
        }
    }

    void validatePage() {
        if (this.failure != null) {
            this.setErrorMessage(this.failure);
            this.setPageComplete(false);
            return;
        }
        String importLoc = this.importLocation.getText();
        if (importLoc.isEmpty()) {
            this.setMessage("Select file to import.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(importLoc);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage("Selected file is invalid.");
            this.setPageComplete(false);
            return;
        }
        this.importModel.importLocation = file;
        this.setErrorMessage(null);
        this.setMessage("Import " + file.getName());
        this.setPageComplete(true);
    }
}

