/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.test;

import java.util.Arrays;
import java.util.TreeSet;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.history.util.Median;
import org.simantics.history.util.MedianBinding;

public class TestMedian {

	public static void main(String[] args) throws Exception {
		
		TreeSet<Integer> numbers = new TreeSet<Integer>();
	    Median<Integer> fastMedian = new Median<Integer>( Bindings.INTEGER );

	    for (int i = 1; i < 10; i += 2) {
	        numbers.add(i);
	        fastMedian.add(i);
	        System.out.println(numbers + " median: " + fastMedian.getMedian());
	    }

	    for (int i = 10; i >= 2; i -= 2) {
	        numbers.add(i);
	        fastMedian.add(i);
	        System.out.println(numbers + " median: " + fastMedian.getMedian());
	    }
	    	    
	    BindingProvider medianBindingFactory = new BindingProvider() {
			public Binding provideBinding(org.simantics.databoard.binding.reflection.ClassBindingFactory master, BindingRequest request) throws BindingConstructionException {
				if (Median.class.isAssignableFrom( request.getClazz() )) { 
					return new MedianBinding(new ArrayType(null), null);
				}
				return null;
			}
	    };	    
	    
	    Bindings.classBindingFactory.addFactory( medianBindingFactory );

	    ArrayBinding b = (ArrayBinding) Bindings.getBindingUnchecked(Median.class, Integer.class);
	    Median<Integer> qu = (Median<Integer>) b.createDefault();
	    qu.add( 5 );
	    System.out.println( b.get(qu, 0) ) ;
	    
	    System.out.println( b.toString( fastMedian ) );
	    fastMedian.setSize( 3 );
	    System.out.println( b.toString( fastMedian ) );
	    
	    
	    Serializer s = Bindings.getSerializerUnchecked( b );
	    byte[] data = s.serialize( fastMedian );
	    System.out.println(Arrays.toString(data));
	    Median<Integer> q2 = (Median<Integer>) s.deserialize( data );
	    System.out.println( b.toString(q2) );
	    
	    System.out.println();
	}
}
