/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.pdf;

import com.lowagie.text.pdf.PdfAction;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.TableRow;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.URLItem;
import org.simantics.document.linking.report.pdf.PDFDocument;
import org.simantics.document.linking.report.pdf.PDFElement;
import org.simantics.document.linking.report.pdf.PDFPage;
import org.simantics.document.linking.report.pdf.PDFPageStream;
import org.simantics.document.linking.report.pdf.PDFTableRow;

public class PDFTable
implements Table,
PDFElement {
    PDFDocument writer;
    PDFPageStream stream;
    PDFPage startPage;
    int currentLine = 0;
    List<TableColumn> columns = new ArrayList<TableColumn>();
    List<String> columnNames = new ArrayList<String>();
    List<Integer> columnSizes = new ArrayList<Integer>();
    List<Integer> columnPositions = new ArrayList<Integer>();
    TextItem title = null;
    boolean headerVisible = true;
    private boolean linesVisible = true;
    private boolean linesPrevVisible = true;
    boolean clipText = false;
    int textOffsetX = 2;
    int textOffsetY = 2;
    private Document.TextSize currentTextSize = Document.TextSize.SMALL;

    public PDFTable(PDFDocument writer, PDFPageStream stream) {
        this.writer = writer;
        this.stream = stream;
        this.startPage = stream.getCurrentPage();
    }

    public PDFTable(PDFTable table) {
        this.writer = table.writer;
        this.stream = table.stream;
        this.startPage = this.stream.getCurrentPage();
        this.columns.addAll(table.columns);
        this.columnNames.addAll(table.columnNames);
        this.updateColumnPositions();
    }

    @Override
    public PDFPage getPage() {
        return this.startPage;
    }

    @Override
    public TableColumn addColumn(String name, double width) {
        TableColumn tc = new TableColumn(name, width);
        this.columns.add(tc);
        this.columnNames.add(name);
        this.updateColumnPositions();
        return tc;
    }

    private void updateColumnPositions() {
        int pos = 0;
        this.columnSizes.clear();
        this.columnPositions.clear();
        for (TableColumn c : this.columns) {
            int size = (int)(c.getWidth() * (double)this.stream.getContentWidth());
            this.columnSizes.add(size);
            this.columnPositions.add(pos);
            pos += size;
        }
    }

    @Override
    public List<TableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public boolean isLinesVisible() {
        return this.linesVisible;
    }

    @Override
    public void setLinesVisible(boolean b) {
        if (this.linesVisible == b) {
            return;
        }
        this.linesPrevVisible = this.linesVisible;
        this.linesVisible = b;
    }

    @Override
    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    @Override
    public void setHeaderVisible(boolean b) {
        this.headerVisible = b;
    }

    private boolean isFirstLine() {
        return this.currentLine == 0 || this.stream.getCurrentPage().currentLine == 1;
    }

    @Override
    public void setTitle(String title) {
        try {
            this.title = this.writer.newItem(TextItem.class, new String[0]);
            this.title.setText(title);
        }
        catch (Exception exception) {}
    }

    @Override
    public void setTitle(TextItem title) {
        this.title = title;
    }

    @Override
    public TableRow writeRow(String ... line) throws Exception {
        ArrayList<String> list = new ArrayList<String>(line.length);
        String[] stringArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        return this.writeRow(list);
    }

    @Override
    public TableRow writeRow(List<String> line) throws Exception {
        if (this.isFirstLine()) {
            this.writeHeader();
        }
        return this._writeRow(line);
    }

    @Override
    public TableRow writeRowItem(TextItem ... line) throws Exception {
        ArrayList<TextItem> list = new ArrayList<TextItem>(line.length);
        TextItem[] textItemArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            TextItem s = textItemArray[n2];
            list.add(s);
            ++n2;
        }
        return this.writeRowItem(list);
    }

    @Override
    public TableRow writeRowItem(List<TextItem> line) throws Exception {
        if (this.isFirstLine()) {
            this.writeHeader();
        }
        return this._writeRow2(line);
    }

    private TableRow _writeRow(List<String> line) throws Exception {
        int h = this.getTextHeight();
        int ht = this.getTopHeight();
        int hb = this.getBottomHeight();
        PDFPage page = this.getCurrentPage();
        Graphics2D g2d = page.g2d;
        Shape clip = g2d.getClip();
        if (this.clipText) {
            int i = 0;
            while (i < line.size()) {
                if (line.get(i) != null) {
                    g2d.setClip(this.columnPositions.get(i), ht - 1, this.columnSizes.get(i), hb - ht + 2);
                    g2d.drawString(line.get(i), this.columnPositions.get(i) + this.textOffsetX, h);
                }
                ++i;
            }
            g2d.setClip(clip);
            if (this.linesVisible) {
                i = 0;
                while (i < line.size()) {
                    g2d.drawLine(this.columnPositions.get(i), ht, this.columnPositions.get(i), hb);
                    ++i;
                }
                if (this.isFirstLine() || !this.linesPrevVisible) {
                    g2d.drawLine(0, ht, this.stream.contentWidth, ht);
                    this.linesPrevVisible = true;
                }
                g2d.drawLine(this.stream.contentWidth, ht, this.stream.contentWidth, hb);
                g2d.drawLine(0, hb, this.stream.contentWidth, hb);
            }
            ++this.currentLine;
            ++page.currentLine;
            --page.availableLines;
            page.currentPixel += this.getLineHeight();
        } else {
            PositionedRow row = this._getRow(line);
            if (this.stream.contentHeight - page.currentPixel < row.reservedSpace) {
                this.stream.nextPage();
                page = this.getCurrentPage();
                g2d = page.g2d;
                this.writeHeader();
                row = this._getRow(line);
            }
            row.render(g2d);
            this.currentLine += row.realLines;
            page.currentLine += row.realLines;
            page.currentPixel += row.reservedSpace;
            page.estimateAvailableLines();
        }
        this.stream.checkNextPage();
        return new PDFTableRow();
    }

    private TableRow _writeRow2(List<TextItem> line) throws Exception {
        int h = this.getTextHeight();
        int ht = this.getTopHeight();
        int hb = this.getBottomHeight();
        PDFPage page = this.getCurrentPage();
        Graphics2D g2d = page.g2d;
        Shape clip = g2d.getClip();
        if (this.clipText) {
            int i = 0;
            while (i < line.size()) {
                TextItem text = line.get(i);
                if (text != null) {
                    URL url;
                    g2d.setClip(this.columnPositions.get(i), ht, this.columnSizes.get(i), hb - ht);
                    g2d.drawString(text.getText(), this.columnPositions.get(i) + this.textOffsetX, h);
                    if (text instanceof URLItem && (url = ((URLItem)text).getURL()) != null) {
                        this.addLink(url, this.columnPositions.get(i), ht, this.columnSizes.get(i), hb - ht);
                    }
                }
                ++i;
            }
            g2d.setClip(clip);
            if (this.linesVisible) {
                i = 0;
                while (i < line.size()) {
                    g2d.drawLine(this.columnPositions.get(i), ht, this.columnPositions.get(i), hb);
                    ++i;
                }
                if (this.isFirstLine() || !this.linesPrevVisible) {
                    g2d.drawLine(0, ht, this.stream.contentWidth, ht);
                    this.linesPrevVisible = true;
                }
                g2d.drawLine(this.stream.contentWidth, ht, this.stream.contentWidth, hb);
                g2d.drawLine(0, hb, this.stream.contentWidth, hb);
            }
            ++this.currentLine;
            ++page.currentLine;
            --page.availableLines;
            page.currentPixel += this.getLineHeight();
        } else {
            PositionedRow row = this._getRow2(line);
            if (this.stream.contentHeight - page.currentPixel < row.reservedSpace) {
                this.stream.nextPage();
                page = this.getCurrentPage();
                g2d = page.g2d;
                this.writeHeader();
                row = this._getRow2(line);
            }
            row.render(g2d);
            this.currentLine += row.realLines;
            page.currentLine += row.realLines;
            page.currentPixel += row.reservedSpace;
            page.estimateAvailableLines();
        }
        this.stream.checkNextPage();
        return new PDFTableRow();
    }

    void writeLine(String line) throws Exception {
        this.writeLine(line, 0);
    }

    void writeLine(TextItem line) throws Exception {
        this.writeLine(line, 0);
    }

    private void writeHeader() throws Exception {
        if (this.headerVisible) {
            Document.TextSize s = this.currentTextSize;
            this.setTextSize(Document.TextSize.MEDIUM);
            if (this.title != null) {
                boolean b = this.linesVisible;
                this.setLinesVisible(false);
                this.writeLine(this.title);
                this.setLinesVisible(b);
            }
            this._writeRow(this.columnNames);
            this.setTextSize(s);
        }
    }

    void writeLine(String line, int x) throws Exception {
        int h = this.getTextHeight();
        int ht = this.getTopHeight();
        int hb = this.getBottomHeight();
        PDFPage page = this.getCurrentPage();
        Graphics2D g2d = page.g2d;
        g2d.drawString(line, x + this.textOffsetX, h);
        if (this.linesVisible) {
            if (this.isFirstLine() || !this.linesPrevVisible) {
                g2d.drawLine(0, ht, this.stream.contentWidth, ht);
                this.linesPrevVisible = true;
            }
            g2d.drawLine(0, ht, 0, hb);
            g2d.drawLine(this.stream.contentWidth, ht, this.stream.contentWidth, hb);
            g2d.drawLine(0, hb, this.stream.contentWidth, hb);
        }
        ++this.currentLine;
        ++page.currentLine;
        --page.availableLines;
        page.currentPixel += this.getLineHeight();
        this.stream.checkNextPage();
    }

    void writeLine(TextItem line, int x) throws Exception {
        URL url;
        int h = this.getTextHeight();
        int ht = this.getTopHeight();
        int hb = this.getBottomHeight();
        PDFPage page = this.getCurrentPage();
        Graphics2D g2d = page.g2d;
        g2d.drawString(line.getText(), x + this.textOffsetX, h);
        if (this.linesVisible) {
            if (this.isFirstLine() || !this.linesPrevVisible) {
                g2d.drawLine(0, ht, this.stream.contentWidth, ht);
                this.linesPrevVisible = true;
            }
            g2d.drawLine(0, ht, 0, hb);
            g2d.drawLine(this.stream.contentWidth, ht, this.stream.contentWidth, hb);
            g2d.drawLine(0, hb, this.stream.contentWidth, hb);
        }
        if (line instanceof URLItem && (url = ((URLItem)line).getURL()) != null) {
            this.addLink(url, 0, ht, this.stream.contentWidth, hb - ht);
        }
        ++this.currentLine;
        ++page.currentLine;
        --page.availableLines;
        page.currentPixel += this.getLineHeight();
        this.stream.checkNextPage();
    }

    int getTopHeight() {
        return this.getTopHeight(this.currentLine);
    }

    int getTopHeight(int line) {
        return (line - this.currentLine) * this.getLineHeight() + this.getCurrentPage().currentPixel;
    }

    int getTextHeight() {
        PDFPage page = this.getCurrentPage();
        return page.currentPixel + this.getLineHeight() - page.fm.getDescent() - this.textOffsetY;
    }

    PDFPage getCurrentPage() {
        return this.stream.getCurrentPage();
    }

    int getBottomHeight() {
        return this.getBottomHeight(this.currentLine);
    }

    protected int getLineHeight() {
        return this.getCurrentPage().fm.getHeight() + this.textOffsetY;
    }

    private int getBottomHeight(int line) {
        return (line - this.currentLine + 1) * this.getLineHeight() + this.getCurrentPage().currentPixel;
    }

    public int getAvailableLines() {
        PDFPage page = this.getCurrentPage();
        int contentHeight = this.stream.contentHeight;
        int pixelY = page.currentPixel;
        return (int)Math.floor((contentHeight - pixelY) / this.getLineHeight());
    }

    @Override
    public void setTextSize(Document.TextSize size) {
        this.stream.getCurrentPage().setFont(this.writer.fonts.get((Object)size));
        this.currentTextSize = size;
    }

    @Override
    public Document.TextSize getTextSize() {
        return this.currentTextSize;
    }

    private PositionedRow _getRow(List<String> line) {
        PositionedRow row = new PositionedRow();
        int h = this.getTextHeight();
        int realLines = 1;
        int reservedSpace = 0;
        ArrayList<List<PositionedText>> cells = new ArrayList<List<PositionedText>>(line.size());
        if (line.size() > 1) {
            int i = 0;
            while (i < line.size()) {
                String text = line.get(i);
                int availableSize = this.columnSizes.get(i) - this.textOffsetX;
                if (text != null && text.length() > 0) {
                    List<PositionedText> pt = this.getText(text, this.columnPositions.get(i) + this.textOffsetX, h, availableSize, this.columns.get(i).getAlignment());
                    cells.add(pt);
                    reservedSpace = Math.max(reservedSpace, this.getResevedSpace(pt) + this.getLineHeight());
                    realLines = Math.max(realLines, this.getLineSpace(pt));
                } else {
                    cells.add(Collections.emptyList());
                    reservedSpace = Math.max(reservedSpace, this.getLineHeight());
                }
                ++i;
            }
        } else {
            String text = line.get(0);
            int availableSize = this.stream.contentWidth;
            if (text != null && text.length() > 0) {
                List<PositionedText> pt = this.getText(text, this.textOffsetX, h, availableSize, this.columns.get(0).getAlignment());
                cells.add(pt);
                reservedSpace = Math.max(reservedSpace, this.getResevedSpace(pt) + this.getLineHeight());
                realLines = Math.max(realLines, this.getLineSpace(pt));
            } else {
                cells.add(Collections.emptyList());
                reservedSpace = Math.max(reservedSpace, this.getLineHeight());
            }
        }
        row.reservedSpace = reservedSpace;
        row.startLine = this.currentLine;
        row.realLines = realLines;
        row.cells = cells;
        return row;
    }

    private PositionedRow _getRow2(List<TextItem> line) {
        PositionedRow row = new PositionedRow();
        int h = this.getTextHeight();
        int realLines = 1;
        int reservedSpace = 0;
        row.cells = new ArrayList<List<PositionedText>>(line.size());
        row.urls = new ArrayList<URL>();
        if (line.size() > 1) {
            int i = 0;
            while (i < line.size()) {
                TextItem item = line.get(i);
                int availableSize = this.columnSizes.get(i) - this.textOffsetX;
                if (item != null && item.getText().length() > 0) {
                    String text = item.getText();
                    List<PositionedText> pt = this.getText(text, this.columnPositions.get(i) + this.textOffsetX, h, availableSize, this.columns.get(i).getAlignment());
                    row.cells.add(pt);
                    reservedSpace = Math.max(reservedSpace, this.getResevedSpace(pt) + this.getLineHeight());
                    realLines = Math.max(realLines, this.getLineSpace(pt));
                } else {
                    row.cells.add(Collections.emptyList());
                    reservedSpace = Math.max(reservedSpace, this.getLineHeight());
                }
                if (item instanceof URLItem) {
                    row.urls.add(((URLItem)item).getURL());
                } else {
                    row.urls.add(null);
                }
                ++i;
            }
        } else {
            String text = line.get(0).getText();
            int availableSize = this.stream.contentWidth;
            if (text != null && text.length() > 0) {
                List<PositionedText> pt = this.getText(text, this.textOffsetX, h, availableSize, this.columns.get(0).getAlignment());
                row.cells.add(pt);
                reservedSpace = Math.max(reservedSpace, this.getResevedSpace(pt) + this.getLineHeight());
                realLines = Math.max(realLines, this.getLineSpace(pt));
            } else {
                row.cells.add(Collections.emptyList());
                reservedSpace = Math.max(reservedSpace, this.getLineHeight());
            }
        }
        row.reservedSpace = reservedSpace;
        row.startLine = this.currentLine;
        row.realLines = realLines;
        return row;
    }

    private int getResevedSpace(List<PositionedText> pt) {
        float sy = pt.get((int)0).drawPosY;
        float ey = pt.get((int)(pt.size() - 1)).drawPosY;
        return (int)Math.ceil(ey - sy);
    }

    private int getLineSpace(List<PositionedText> pt) {
        if (pt.size() < 2) {
            return 1;
        }
        return this.getResevedSpace(pt) / this.getLineHeight() + 1;
    }

    private void addLink(URL url, int x, int y, int w, int h) {
        PDFPage page = this.getCurrentPage();
        float fx = page.stream.marginLeft + x;
        float fy = (float)(-page.stream.marginTop) + page.template.getHeight() - (float)y;
        page.template.setAction(new PdfAction(url), fx, fy - (float)h, fx + (float)w, fy);
    }

    private List<PositionedText> getText(String text, int x, int y, int cellWidth, TableColumn.Alignment alignment) {
        ArrayList<PositionedText> result = new ArrayList<PositionedText>();
        Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
        PDFPage page = this.getCurrentPage();
        Font font = page.getFont();
        for (TextAttribute a : font.getAttributes().keySet()) {
            Object v = font.getAttributes().get(a);
            if (v == null) continue;
            map.put(a, v);
        }
        map.put(TextAttribute.FOREGROUND, Color.black);
        AttributedString attributedText = new AttributedString(text, map);
        AttributedCharacterIterator paragraph = attributedText.getIterator();
        int paragraphStart = paragraph.getBeginIndex();
        int paragraphEnd = paragraph.getEndIndex();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, page.frc);
        lineMeasurer.setPosition(paragraphStart);
        int position = 0;
        int drawPosY = y;
        while ((position = lineMeasurer.getPosition()) < paragraphEnd) {
            int next;
            int limit = next = lineMeasurer.nextOffset(cellWidth);
            int charat = text.indexOf(System.getProperty("line.separator"), position + 1);
            if (charat < next && charat != -1) {
                limit = charat;
            }
            TextLayout layout = lineMeasurer.nextLayout(cellWidth, limit, false);
            float drawPosX = 0.0f;
            switch (alignment) {
                case LEFT: {
                    drawPosX = layout.isLeftToRight() ? 0.0f : (float)cellWidth - layout.getAdvance();
                    break;
                }
                case CENTER: {
                    drawPosX = ((float)cellWidth - layout.getAdvance()) / 2.0f;
                    break;
                }
                case RIGHT: {
                    drawPosX = layout.isLeftToRight() ? (float)cellWidth - layout.getAdvance() : 0.0f;
                }
            }
            result.add(new PositionedText(drawPosX += (float)x, drawPosY, layout));
            drawPosY = (int)((float)drawPosY + (layout.getDescent() + layout.getLeading() + layout.getAscent()));
        }
        return result;
    }

    private class PositionedRow {
        int startLine;
        int realLines;
        int reservedSpace;
        List<List<PositionedText>> cells;
        List<URL> urls;

        private PositionedRow() {
        }

        void render(Graphics2D g) {
            int i;
            int ht = PDFTable.this.getTopHeight(this.startLine);
            int hb = ht + this.reservedSpace;
            if (this.cells.size() > 0) {
                i = 0;
                while (i < this.cells.size()) {
                    URL url;
                    List<PositionedText> ptl = this.cells.get(i);
                    for (PositionedText pt : ptl) {
                        pt.render(g);
                    }
                    if (this.urls != null && (url = this.urls.get(i)) != null) {
                        PDFTable.this.addLink(url, PDFTable.this.columnPositions.get(i), ht, PDFTable.this.columnSizes.get(i), hb - ht);
                    }
                    ++i;
                }
            }
            if (PDFTable.this.linesVisible) {
                if (this.cells.size() > 0) {
                    i = 0;
                    while (i < this.cells.size()) {
                        g.drawLine(PDFTable.this.columnPositions.get(i), ht, PDFTable.this.columnPositions.get(i), hb);
                        ++i;
                    }
                } else {
                    g.drawLine(PDFTable.this.columnPositions.get(0), ht, PDFTable.this.columnPositions.get(0), hb);
                }
                if (PDFTable.this.isFirstLine() || !PDFTable.this.linesPrevVisible) {
                    g.drawLine(0, ht, PDFTable.this.stream.contentWidth, ht);
                    PDFTable.this.linesPrevVisible = true;
                }
                g.drawLine(PDFTable.this.stream.contentWidth, ht, PDFTable.this.stream.contentWidth, hb);
                g.drawLine(0, hb, PDFTable.this.stream.contentWidth, hb);
            }
        }
    }

    class PositionedText {
        float drawPosX;
        float drawPosY;
        TextLayout layout;

        public PositionedText(float drawPosX, float drawPosY, TextLayout layout) {
            this.drawPosX = drawPosX;
            this.drawPosY = drawPosY;
            this.layout = layout;
        }

        public void render(Graphics2D g) {
            this.layout.draw(g, this.drawPosX, this.drawPosY);
        }
    }
}

