/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.layer0.Layer0;

public class PropertyChildRule
implements ChildRule {
    private boolean includeAllProps = true;
    private boolean showOnlyCheckable = false;

    public PropertyChildRule() {
    }

    public PropertyChildRule(boolean includeAllProps) {
        this.includeAllProps = includeAllProps;
    }

    public void setShowOnlyCheckable(boolean showOnlyCheckable) {
        this.showOnlyCheckable = showOnlyCheckable;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    public void setIncludeAllProps(boolean includeAllProps) {
        this.includeAllProps = includeAllProps;
    }

    public Collection<?> getChildren(ReadGraph graph, Object obj) throws DatabaseException {
        ArrayList<Object> children = new ArrayList<Object>();
        boolean isResource = true;
        Resource resource = null;
        Variable variable = null;
        if (obj instanceof Resource) {
            resource = (Resource)obj;
            isResource = true;
            try {
                variable = (Variable)graph.adapt(resource, Variable.class);
            }
            catch (Throwable throwable) {
                return children;
            }
        } else {
            variable = (Variable)obj;
            resource = variable.getPossibleRepresents(graph);
            isResource = false;
        }
        if (resource == null) {
            return children;
        }
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, sl.Source)) {
            return children;
        }
        if (!graph.hasValue(resource)) {
            if (this.includeAllProps) {
                Map<Resource, Statement> selectedProps = this.getProps(graph, resource);
                for (Statement s : selectedProps.values()) {
                    children.add(new StandardGraphPropertyVariable(graph, variable, s.getPredicate()));
                }
            } else {
                HashSet<Resource> linked = new HashSet<Resource>();
                Collection sources = graph.getObjects(resource, sl.hasSource);
                for (Resource source : sources) {
                    if (this.showOnlyCheckable && SourceLinkUtil.isValidSource(graph, source) && SourceLinkUtil.isUpToDateSource(graph, source)) continue;
                    Resource rel = graph.getPossibleObject(source, sl.consernsRelation);
                    linked.add(rel);
                }
                Map<Resource, Statement> selectedProps = this.getProps(graph, resource);
                for (Statement s : selectedProps.values()) {
                    if (!linked.contains(s.getPredicate())) continue;
                    children.add(new StandardGraphPropertyVariable(graph, variable, s.getPredicate()));
                }
            }
        }
        if (!isResource) {
            Resource rel;
            Collection sources;
            Variable parentVariable = variable.getParent(graph);
            Resource parentRes = null;
            Resource relation = null;
            if (parentVariable != null) {
                parentRes = parentVariable.getPossibleRepresents(graph);
                relation = variable.getPossiblePredicateResource(graph);
            }
            if (parentRes != null && relation != null) {
                sources = graph.getObjects(parentRes, sl.hasSource);
                for (Resource source : sources) {
                    rel = graph.getPossibleObject(source, sl.consernsRelation);
                    if (rel == null || !rel.equals(relation) || this.showOnlyCheckable && SourceLinkUtil.isValidSource(graph, source) && SourceLinkUtil.isUpToDateSource(graph, source)) continue;
                    children.add(new StandardGraphChildVariable(variable, null, source));
                }
            }
            sources = graph.getObjects(resource, sl.hasSource);
            for (Resource source : sources) {
                rel = graph.getPossibleObject(source, sl.consernsRelation);
                if (rel != null || this.showOnlyCheckable && SourceLinkUtil.isValidSource(graph, source) && SourceLinkUtil.isUpToDateSource(graph, source)) continue;
                children.add(new StandardGraphChildVariable(variable, null, source));
            }
            while (children.remove(variable)) {
            }
        }
        return children;
    }

    private Map<Resource, Statement> getProps(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        HashMap<Resource, Statement> selectedProps = new HashMap<Resource, Statement>();
        Collection propertyStatements = graph.getStatements(resource, l0.HasProperty);
        for (Statement s : propertyStatements) {
            if (!graph.isInstanceOf(s.getObject(), l0.Literal) && !graph.isInstanceOf(s.getObject(), l0.SCLValue)) continue;
            if (selectedProps.containsKey(s.getPredicate())) {
                if (s.isAsserted(resource)) continue;
                selectedProps.put(s.getPredicate(), s);
                continue;
            }
            selectedProps.put(s.getPredicate(), s);
        }
        return selectedProps;
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return new ArrayList();
    }
}

