/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.literal;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

public class DecimalFormatFormatter
extends Bean
implements Formatter {
    public static final Binding BINDING = Bindings.getBindingUnchecked(DecimalFormatFormatter.class);
    public String formatString;
    private volatile DecimalFormat format;

    public DecimalFormatFormatter() {
        this("0.###############");
    }

    public DecimalFormatFormatter(String formatString) {
        if (formatString == null) {
            throw new NullPointerException("null formatString");
        }
        this.formatString = formatString;
    }

    public DecimalFormat getFormat() {
        if (this.format == null) {
            this.format = new DecimalFormat(this.formatString, DecimalFormatSymbols.getInstance(Locale.US));
        }
        return this.format;
    }

    public String format(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        if (object instanceof Number) {
            String result;
            int resultIntegers;
            DecimalFormat format = this.getFormat();
            int integers = format.getMaximumIntegerDigits();
            if (integers == Integer.MAX_VALUE) {
                integers = this.countIntegerDigits(this.formatString);
            }
            if ((resultIntegers = this.countResultDigits(result = format.format(object))) > integers) {
                int decimals = Math.min(format.getMaximumFractionDigits(), 15);
                return this.getLimitString(integers, decimals);
            }
            return result;
        }
        return object != null ? object.toString() : "";
    }

    private int countIntegerDigits(String formatString) {
        int digits = 0;
        int len = formatString.length();
        boolean escape = false;
        int i = 0;
        while (i < len) {
            char ch = formatString.charAt(i);
            if (ch == '.') break;
            if (ch == '\'') {
                escape = true;
            } else if (!(escape || ch != '#' && ch != '0')) {
                ++digits;
            }
            ++i;
        }
        return digits;
    }

    private int countResultDigits(String formattedString) {
        int digits = 0;
        int len = formattedString.length();
        int i = 0;
        while (i < len) {
            char ch = formattedString.charAt(i);
            if (ch == '.') break;
            if (Character.isDigit(ch)) {
                ++digits;
            }
            ++i;
        }
        return digits;
    }

    private String getLimitString(int integers, int decimals) {
        StringBuilder b = new StringBuilder(integers + decimals + 1);
        int i = 0;
        while (i < integers) {
            b.append('*');
            ++i;
        }
        b.append('.');
        i = 0;
        while (i < decimals) {
            b.append('*');
            ++i;
        }
        return b.toString();
    }
}

