/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.binary.Endian;

public class FloatArraySerializer
extends Serializer.NonRecursiveSerializer {
    Range length;
    Integer fixedLength;
    Integer fixedSize;

    public FloatArraySerializer(ArrayBinding binding) {
        ArrayType arrayType = binding.type();
        this.length = arrayType.getLength();
        if (this.length != null && this.length.getLower().equals(this.length.getUpper()) && this.length.getLower().getValue() != null) {
            this.fixedLength = this.length.getLower().getValue().intValue();
            this.fixedSize = this.fixedLength * 4;
        }
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength : Endian.readInt(data);
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        if (data.length < length * 4 + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        float[] array = new float[length];
        int i = 0;
        int offset = 4;
        while (i < array.length) {
            array[i] = Float.intBitsToFloat(Endian.readInt(data, offset));
            ++i;
            offset += 4;
        }
        return array;
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        float[] array;
        int length = this.fixedLength != null ? this.fixedLength : Endian.readInt(data);
        if (length != (array = (float[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        if (data.length < length * 4 + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        int i = 0;
        int offset = 4;
        while (i < array.length) {
            array[i] = Float.intBitsToFloat(Endian.readInt(data, offset));
            ++i;
            offset += 4;
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        int length;
        int n = length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        this.assertRemainingBytes(in, (long)length * 4L);
        float[] array = new float[length];
        int i = 0;
        while (i < array.length) {
            array[i] = in.readFloat();
            ++i;
        }
        return array;
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object obj) throws IOException {
        float[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (float[])obj).length) {
            array = new float[length];
        }
        this.assertRemainingBytes(in, (long)length * 4L);
        int i = 0;
        while (i < array.length) {
            array[i] = in.readFloat();
            ++i;
        }
        return array;
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        float[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (float[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        this.assertRemainingBytes(in, (long)length * 4L);
        int i = 0;
        while (i < array.length) {
            array[i] = in.readFloat();
            ++i;
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        int length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        in.skipBytes(length * 4);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        float[] array = (float[])obj;
        if (this.fixedSize == null) {
            out.writeInt(array.length);
        }
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            out.writeFloat(f);
            ++n2;
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj) {
        if (this.fixedSize != null) {
            return this.fixedSize;
        }
        float[] array = (float[])obj;
        return 4 + 4 * array.length;
    }

    public static int getSizeOfPutLength(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16512) {
            return 2;
        }
        if (length < 0x204000) {
            return 3;
        }
        if (length < 0x10200000) {
            return 4;
        }
        return 5;
    }

    @Override
    public int getMinSize() {
        return this.fixedSize != null ? this.fixedSize : 4;
    }
}

