/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.ClassBinding;
import org.simantics.databoard.binding.reflection.ClassInfo;
import org.simantics.databoard.type.RecordType;

class RecordClassBinding
extends ClassBinding {
    private static final Object[] NO_ARGS = new Object[0];

    public RecordClassBinding(ClassInfo ci, RecordType type) {
        super(ci);
        if (ci == null) {
            throw new IllegalArgumentException("null ClassInfo");
        }
        this.type = type;
        this.componentBindings = new Binding[ci.fields.length];
    }

    @Override
    public Object createPartial() throws BindingException {
        try {
            if (this.ci.noArgsConstructor != null) {
                return this.ci.noArgsConstructor.newInstance(new Object[0]);
            }
            if (this.ci.argsConstructor != null) {
                Object[] values = new Object[this.ci.fields.length];
                int i = 0;
                while (i < values.length) {
                    Binding fb = this.componentBindings[i];
                    values[i] = fb.createDefault();
                    ++i;
                }
                return this.ci.argsConstructor.newInstance(values);
            }
            throw new BindingException("Class " + this.ci.clazz.getName() + " doesn't support construction. No no-args or args(fields) constructor.");
        }
        catch (InstantiationException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e.getCause());
        }
    }

    @Override
    public Object create(Object ... values) throws BindingException {
        if (this.ci.argsConstructor != null) {
            try {
                return this.ci.argsConstructor.newInstance(values);
            }
            catch (IllegalArgumentException e) {
                throw new BindingException(e);
            }
            catch (InstantiationException e) {
                throw new BindingException(e);
            }
            catch (IllegalAccessException e) {
                throw new BindingException(e);
            }
            catch (InvocationTargetException e) {
                throw new BindingException(e.getCause());
            }
        }
        try {
            Object result = null;
            result = this.ci.noArgsConstructor != null ? this.ci.noArgsConstructor.newInstance(new Object[0]) : this.ci.clazz.newInstance();
            int i = 0;
            while (i < this.ci.fields.length) {
                Object value = values[i];
                Field f = this.ci.fields[i];
                Class<?> type = f.getType();
                Method setter = this.ci.setters[i];
                if (setter != null) {
                    if (type == Integer.TYPE) {
                        setter.invoke(result, (Integer)value);
                    } else if (type == Long.TYPE) {
                        setter.invoke(result, (Long)value);
                    } else if (type == Float.TYPE) {
                        setter.invoke(result, (Float)value);
                    } else if (type == Double.TYPE) {
                        setter.invoke(result, (Double)value);
                    } else if (type == Boolean.TYPE) {
                        setter.invoke(result, (Boolean)value);
                    } else {
                        setter.invoke(result, value);
                    }
                } else if (type == Integer.TYPE) {
                    f.setInt(result, (Integer)value);
                } else if (type == Long.TYPE) {
                    f.setLong(result, (Long)value);
                } else if (type == Float.TYPE) {
                    f.setFloat(result, ((Float)value).floatValue());
                } else if (type == Double.TYPE) {
                    f.setDouble(result, (Double)value);
                } else if (type == Boolean.TYPE) {
                    f.setBoolean(result, (Boolean)value);
                } else {
                    f.set(result, value);
                }
                ++i;
            }
            return result;
        }
        catch (InstantiationException instantiationException) {
            boolean isPublic;
            boolean bl = isPublic = (this.ci.clazz.getModifiers() & 1) != 0;
            if (!isPublic) {
                throw new BindingException("Failed to instantiate " + this.ci.clazz.getName() + ", maybe it should be public class.");
            }
            throw new BindingException("Failed to instantiate " + this.ci.clazz.getName());
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e.getCause());
        }
    }

    @Override
    public Object getComponent(Object obj, int index) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> type = f.getType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return f.getInt(obj);
                }
                if (type == Byte.TYPE) {
                    return f.getByte(obj);
                }
                if (type == Boolean.TYPE) {
                    return f.getBoolean(obj);
                }
                if (type == Float.TYPE) {
                    return Float.valueOf(f.getFloat(obj));
                }
                if (type == Double.TYPE) {
                    return f.getDouble(obj);
                }
                if (type == Long.TYPE) {
                    return f.getLong(obj);
                }
                return f.get(obj);
            }
            return f.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            Field getter = this.ci.fields[index];
            if (getter != null) {
                try {
                    return getter.get(obj);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            throw new BindingException(e);
        }
    }

    @Override
    public boolean isInstance(Object obj) {
        return this.ci.clazz.isInstance(obj);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public Class<?> getComponentClass(int index) {
        return this.ci.fields[index].getDeclaringClass();
    }

    @Override
    public void setComponent(Object obj, int index, Object value) throws BindingException {
        try {
            Method setter = this.ci.setters[index];
            if (setter != null) {
                setter.invoke(obj, value);
            } else {
                Field f = this.ci.fields[index];
                Class<?> type = f.getType();
                if (type.isPrimitive()) {
                    if (type == Integer.TYPE) {
                        f.setInt(obj, (Integer)value);
                    } else if (type == Byte.TYPE) {
                        f.setByte(obj, (Byte)value);
                    } else if (type == Boolean.TYPE) {
                        f.setBoolean(obj, (Boolean)value);
                    } else if (type == Float.TYPE) {
                        f.setFloat(obj, ((Float)value).floatValue());
                    } else if (type == Double.TYPE) {
                        f.setDouble(obj, (Double)value);
                    } else if (type == Long.TYPE) {
                        f.setLong(obj, (Long)value);
                    } else {
                        f.set(obj, value);
                    }
                } else {
                    f.set(obj, value);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            throw new BindingException(e.getCause());
        }
    }

    @Override
    public void setComponents(Object obj, Object ... value) throws BindingException {
        try {
            int i = 0;
            while (i < this.ci.fields.length) {
                Method setter = this.ci.setters[i];
                if (setter != null) {
                    setter.invoke(obj, value[i]);
                } else {
                    Field f = this.ci.fields[i];
                    Class<?> type = f.getType();
                    if (type.isPrimitive()) {
                        if (type == Integer.TYPE) {
                            f.setInt(obj, (Integer)value[i]);
                        } else if (type == Byte.TYPE) {
                            f.setByte(obj, (Byte)value[i]);
                        } else if (type == Boolean.TYPE) {
                            f.setBoolean(obj, (Boolean)value[i]);
                        } else if (type == Float.TYPE) {
                            f.setFloat(obj, ((Float)value[i]).floatValue());
                        } else if (type == Double.TYPE) {
                            f.setDouble(obj, (Double)value[i]);
                        } else if (type == Long.TYPE) {
                            f.setLong(obj, (Long)value[i]);
                        } else {
                            f.set(obj, value[i]);
                        }
                    } else {
                        f.set(obj, value[i]);
                    }
                }
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e.getCause());
        }
    }

    @Override
    public void setBoolean(Object r, int index, boolean z) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> cl = f.getType();
            if (cl == Boolean.TYPE || cl == Boolean.class) {
                f.setBoolean(r, z);
            } else {
                BooleanBinding b = (BooleanBinding)this.getComponentBinding(index);
                this.setComponent(r, index, b.create(z));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public boolean getBoolean(Object r, int index) throws BindingException {
        try {
            Class<?> cl;
            Field f = this.ci.fields[index];
            Class<?> clazz = cl = f == null ? null : f.getType();
            if (cl == Boolean.TYPE || cl == Boolean.class) {
                return f.getBoolean(r);
            }
            Object o = this.getComponent(r, index);
            BooleanBinding b = (BooleanBinding)this.getComponentBinding(index);
            return b.getValue_(o);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setByte(Object r, int index, byte x) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> cl = f.getType();
            if (cl == Byte.TYPE || cl == Byte.class) {
                f.setByte(r, x);
            } else {
                ByteBinding b = (ByteBinding)this.getComponentBinding(index);
                this.setComponent(r, index, b.create(x));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public byte getByte(Object r, int index) throws BindingException {
        try {
            Class<?> cl;
            Field f = this.ci.fields[index];
            Class<?> clazz = cl = f == null ? null : f.getType();
            if (cl == Byte.TYPE || cl == Byte.class) {
                return f.getByte(r);
            }
            Object o = this.getComponent(r, index);
            ByteBinding b = (ByteBinding)this.getComponentBinding(index);
            return b.getValue_(o);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setInt(Object r, int index, int x) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> cl = f.getType();
            if (cl == Integer.TYPE || cl == Integer.class) {
                f.setInt(r, x);
            } else {
                IntegerBinding b = (IntegerBinding)this.getComponentBinding(index);
                this.setComponent(r, index, b.create(x));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public int getInt(Object r, int index) throws BindingException {
        try {
            Class<?> cl;
            Field f = this.ci.fields[index];
            Class<?> clazz = cl = f == null ? null : f.getType();
            if (cl == Integer.TYPE || cl == Integer.class) {
                return f.getInt(r);
            }
            Object o = this.getComponent(r, index);
            IntegerBinding b = (IntegerBinding)this.getComponentBinding(index);
            return b.getValue_(o);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setLong(Object r, int index, long x) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> cl = f.getType();
            if (cl == Long.TYPE || cl == Long.class) {
                f.setLong(r, x);
            } else {
                LongBinding b = (LongBinding)this.getComponentBinding(index);
                this.setComponent(r, index, b.create(x));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public long getLong(Object r, int index) throws BindingException {
        try {
            Class<?> cl;
            Field f = this.ci.fields[index];
            Class<?> clazz = cl = f == null ? null : f.getType();
            if (cl == Long.TYPE || cl == Long.class) {
                return f.getLong(r);
            }
            Object o = this.getComponent(r, index);
            LongBinding b = (LongBinding)this.getComponentBinding(index);
            return b.getValue_(o);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setFloat(Object r, int index, float x) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> cl = f.getType();
            if (cl == Float.TYPE || cl == Float.class) {
                f.setFloat(r, x);
            } else {
                FloatBinding b = (FloatBinding)this.getComponentBinding(index);
                this.setComponent(r, index, b.create(x));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public float getFloat(Object r, int index) throws BindingException {
        try {
            Class<?> cl;
            Field f = this.ci.fields[index];
            Class<?> clazz = cl = f == null ? null : f.getType();
            if (cl == Float.TYPE || cl == Float.class) {
                return f.getFloat(r);
            }
            Object o = this.getComponent(r, index);
            FloatBinding b = (FloatBinding)this.getComponentBinding(index);
            return b.getValue_(o);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setDouble(Object r, int index, double x) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> cl = f.getType();
            if (cl == Double.TYPE || cl == Double.class) {
                f.setDouble(r, x);
            } else {
                DoubleBinding b = (DoubleBinding)this.getComponentBinding(index);
                this.setComponent(r, index, b.create(x));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public double getDouble(Object r, int index) throws BindingException {
        try {
            Class<?> cl;
            Field f = this.ci.fields[index];
            Class<?> clazz = cl = f == null ? null : f.getType();
            if (cl == Double.TYPE || cl == Double.class) {
                return f.getDouble(r);
            }
            Object o = this.getComponent(r, index);
            DoubleBinding b = (DoubleBinding)this.getComponentBinding(index);
            return b.getValue_(o);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }
}

