/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.ArgumentImpl;
import org.simantics.databoard.annotations.Arguments;
import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.annotations.MIMEType;
import org.simantics.databoard.annotations.Name;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Pattern;
import org.simantics.databoard.annotations.Referable;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.factory.BindingRepository;
import org.simantics.databoard.binding.factory.DefaultBindingFactory;
import org.simantics.databoard.binding.factory.TypeBindingFactory;
import org.simantics.databoard.binding.impl.ByteBindingDefault;
import org.simantics.databoard.binding.impl.DoubleBindingDefault;
import org.simantics.databoard.binding.impl.FloatBindingDefault;
import org.simantics.databoard.binding.impl.IntegerBindingDefault;
import org.simantics.databoard.binding.impl.LongBindingDefault;
import org.simantics.databoard.binding.impl.OptionalBindingDefault;
import org.simantics.databoard.binding.impl.StringBindingDefault;
import org.simantics.databoard.binding.impl.UnsignedByteBinding;
import org.simantics.databoard.binding.impl.UnsignedIntegerBinding;
import org.simantics.databoard.binding.impl.UnsignedLongBinding;
import org.simantics.databoard.binding.mutable.MutableByteBinding;
import org.simantics.databoard.binding.mutable.MutableDoubleBinding;
import org.simantics.databoard.binding.mutable.MutableFloatBinding;
import org.simantics.databoard.binding.mutable.MutableIntegerBinding;
import org.simantics.databoard.binding.mutable.MutableLongBinding;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassInfo;
import org.simantics.databoard.binding.reflection.EnumClassBinding;
import org.simantics.databoard.binding.reflection.RecordBindingProvider;
import org.simantics.databoard.binding.reflection.ReflectionBindingProvider;
import org.simantics.databoard.binding.reflection.UnionClassBinding;
import org.simantics.databoard.primitives.MutableBoolean;
import org.simantics.databoard.primitives.MutableByte;
import org.simantics.databoard.primitives.MutableDouble;
import org.simantics.databoard.primitives.MutableFloat;
import org.simantics.databoard.primitives.MutableInteger;
import org.simantics.databoard.primitives.MutableLong;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.primitives.UnsignedByte;
import org.simantics.databoard.primitives.UnsignedInteger;
import org.simantics.databoard.primitives.UnsignedLong;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.ArrayUtils;
import org.simantics.databoard.util.IdentityHashSet;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;

public class ClassBindingFactory {
    Map<BindingRequest, BindingConstructionException> failures = new HashMap<BindingRequest, BindingConstructionException>();
    Map<BindingRequest, Binding> inprogress = new HashMap<BindingRequest, Binding>();
    BindingRepository repository;
    List<BindingProvider> subFactories = new CopyOnWriteArrayList<BindingProvider>();
    RecordBindingProvider asmClassBindingFactory;
    RecordBindingProvider refClassBindingFactory;
    TypeBindingFactory defaultBindingFactory;
    static Class<?>[] NO_CLASSES = new Class[0];

    public ClassBindingFactory() {
        this.init();
        this.repository = new BindingRepository();
        this.defaultBindingFactory = new DefaultBindingFactory();
    }

    public ClassBindingFactory(BindingRepository repository, TypeBindingFactory defaultBindingFactory) {
        this.init();
        this.repository = repository;
        this.defaultBindingFactory = defaultBindingFactory;
    }

    void init() {
        this.refClassBindingFactory = new ReflectionBindingProvider();
        try {
            Class.forName("org.objectweb.asm.ClassWriter");
            Class<?> y = Class.forName("org.simantics.databoard.binding.reflection.AsmBindingProvider");
            Constructor<?> c = y.getConstructor(new Class[0]);
            this.asmClassBindingFactory = (RecordBindingProvider)c.newInstance(new Object[0]);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public void addFactory(BindingProvider factory) {
        if (!this.subFactories.contains(factory)) {
            this.subFactories.add(factory);
        }
    }

    public void removeFactory(BindingProvider factory) {
        this.subFactories.remove(factory);
    }

    public BindingRepository getRepository() {
        return this.repository;
    }

    protected Binding doConstruct(BindingRequest request) throws BindingConstructionException, RangeException {
        UnionType type;
        if (request.hasAnnotation(Optional.class)) {
            Optional optional = request.getAnnotation(Optional.class);
            BindingRequest componentRequest = request.withAnnotations(ArrayUtils.dropElements(request.annotations, optional));
            OptionalType type2 = new OptionalType();
            OptionalBindingDefault binding = new OptionalBindingDefault(type2, null);
            this.inprogress.put(request, binding);
            binding.componentBinding = this.construct(componentRequest);
            type2.componentType = binding.componentBinding.type();
            this.inprogress.remove(request);
            this.repository.put(request, binding);
            return binding;
        }
        org.simantics.databoard.annotations.Range range = request.getAnnotation(org.simantics.databoard.annotations.Range.class);
        Unit unit = request.getAnnotation(Unit.class);
        if (request.getClazz() == Integer.class || request.getClazz() == Integer.TYPE || request.getClazz() == MutableInteger.class || UnsignedInteger.class.isAssignableFrom(request.getClazz())) {
            IntegerBinding binding = null;
            if (range == null && unit == null) {
                if (request.getClazz() == Integer.TYPE) {
                    binding = Bindings.INTEGER;
                }
                if (request.getClazz() == Integer.class) {
                    binding = Bindings.INTEGER;
                }
                if (request.getClazz() == MutableInteger.class) {
                    binding = Bindings.MUTABLE_INTEGER;
                }
                if (request.getClazz() == UnsignedInteger.Mutable.class) {
                    binding = Bindings.MUTABLE_UNSIGNED_INTEGER;
                }
                if (request.getClazz() == UnsignedInteger.Immutable.class) {
                    binding = Bindings.UNSIGNED_INTEGER;
                }
            } else {
                IntegerType type3 = new IntegerType();
                type3.setRange(range == null ? null : Range.valueOf(range.value()));
                type3.setUnit(unit == null ? null : unit.value());
                if (request.getClazz() == Integer.TYPE) {
                    binding = new IntegerBindingDefault(type3);
                }
                if (request.getClazz() == Integer.class) {
                    binding = new IntegerBindingDefault(type3);
                }
                if (request.getClazz() == MutableInteger.class) {
                    binding = new MutableIntegerBinding(type3);
                }
                if (request.getClazz() == UnsignedInteger.Mutable.class) {
                    binding = new UnsignedIntegerBinding.Mutable(type3);
                }
                if (request.getClazz() == UnsignedInteger.Immutable.class) {
                    binding = new UnsignedIntegerBinding.Immutable(type3);
                }
            }
            if (binding == null) {
                throw new BindingConstructionException("Cannot bind to " + request.getClazz().getSimpleName());
            }
            this.repository.put(request, binding);
            return binding;
        }
        if (request.getClazz() == Byte.class || request.getClazz() == Byte.TYPE || request.getClazz() == MutableByte.class || UnsignedByte.class.isAssignableFrom(request.getClazz())) {
            ByteBinding binding = null;
            if (range == null && unit == null) {
                if (request.getClazz() == Byte.TYPE) {
                    binding = Bindings.BYTE;
                }
                if (request.getClazz() == Byte.class) {
                    binding = Bindings.BYTE;
                }
                if (request.getClazz() == MutableByte.class) {
                    binding = Bindings.MUTABLE_BYTE;
                }
                if (request.getClazz() == UnsignedByte.Mutable.class) {
                    binding = Bindings.MUTABLE_UNSIGNED_BYTE;
                }
                if (request.getClazz() == UnsignedByte.Immutable.class) {
                    binding = Bindings.UNSIGNED_BYTE;
                }
            } else {
                ByteType type4 = new ByteType();
                type4.setRange(range == null ? null : Range.valueOf(range.value()));
                type4.setUnit(unit == null ? null : unit.value());
                if (request.getClazz() == Byte.TYPE) {
                    binding = new ByteBindingDefault(type4);
                }
                if (request.getClazz() == Byte.class) {
                    binding = new ByteBindingDefault(type4);
                }
                if (request.getClazz() == MutableByte.class) {
                    binding = new MutableByteBinding(type4);
                }
                if (request.getClazz() == UnsignedByte.Mutable.class) {
                    binding = new UnsignedByteBinding.Mutable(type4);
                }
                if (request.getClazz() == UnsignedByte.Immutable.class) {
                    binding = new UnsignedByteBinding.Immutable(type4);
                }
            }
            if (binding == null) {
                throw new BindingConstructionException("Cannot bind to " + request.getClazz().getSimpleName());
            }
            this.repository.put(request, binding);
            return binding;
        }
        if (request.getClazz() == Long.class || request.getClazz() == Long.TYPE || request.getClazz() == MutableLong.class || UnsignedLong.class.isAssignableFrom(request.getClazz())) {
            LongBinding binding = null;
            if (range == null && unit == null) {
                if (request.getClazz() == Long.TYPE) {
                    binding = Bindings.LONG;
                }
                if (request.getClazz() == Long.class) {
                    binding = Bindings.LONG;
                }
                if (request.getClazz() == MutableLong.class) {
                    binding = Bindings.MUTABLE_LONG;
                }
                if (request.getClazz() == UnsignedLong.Mutable.class) {
                    binding = Bindings.MUTABLE_UNSIGNED_LONG;
                }
                if (request.getClazz() == UnsignedLong.Immutable.class) {
                    binding = Bindings.UNSIGNED_LONG;
                }
            } else {
                LongType type5 = new LongType();
                type5.setRange(range == null ? null : Range.valueOf(range.value()));
                type5.setUnit(unit == null ? null : unit.value());
                if (request.getClazz() == Long.TYPE) {
                    binding = new LongBindingDefault(type5);
                }
                if (request.getClazz() == Long.class) {
                    binding = new LongBindingDefault(type5);
                }
                if (request.getClazz() == MutableLong.class) {
                    binding = new MutableLongBinding(type5);
                }
                if (request.getClazz() == UnsignedLong.Mutable.class) {
                    binding = new UnsignedLongBinding.Mutable(type5);
                }
                if (request.getClazz() == UnsignedLong.Immutable.class) {
                    binding = new UnsignedLongBinding.Immutable(type5);
                }
            }
            if (binding == null) {
                throw new BindingConstructionException("Cannot bind to " + request.getClazz().getSimpleName());
            }
            this.repository.put(request, binding);
            return binding;
        }
        if (request.getClazz() == Float.class || request.getClazz() == Float.TYPE || request.getClazz() == MutableFloat.class) {
            FloatBinding binding = null;
            if (range == null && unit == null) {
                if (request.getClazz() == Float.TYPE) {
                    binding = Bindings.FLOAT;
                }
                if (request.getClazz() == Float.class) {
                    binding = Bindings.FLOAT;
                }
                if (request.getClazz() == MutableFloat.class) {
                    binding = Bindings.MUTABLE_FLOAT;
                }
            } else {
                FloatType type6 = new FloatType();
                type6.setRange(range == null ? null : Range.valueOf(range.value()));
                type6.setUnit(unit == null ? null : unit.value());
                if (request.getClazz() == Float.TYPE) {
                    binding = new FloatBindingDefault(type6);
                }
                if (request.getClazz() == Float.class) {
                    binding = new FloatBindingDefault(type6);
                }
                if (request.getClazz() == MutableFloat.class) {
                    binding = new MutableFloatBinding(type6);
                }
            }
            if (binding == null) {
                throw new BindingConstructionException("Cannot bind to " + request.getClazz().getSimpleName());
            }
            this.repository.put(request, binding);
            return binding;
        }
        if (request.getClazz() == Double.class || request.getClazz() == Double.TYPE || request.getClazz() == MutableDouble.class) {
            DoubleBinding binding = null;
            if (range == null && unit == null) {
                if (request.getClazz() == Double.TYPE) {
                    binding = Bindings.DOUBLE;
                }
                if (request.getClazz() == Double.class) {
                    binding = Bindings.DOUBLE;
                }
                if (request.getClazz() == MutableDouble.class) {
                    binding = Bindings.MUTABLE_DOUBLE;
                }
            } else {
                DoubleType type7 = new DoubleType();
                type7.setRange(range == null ? null : Range.valueOf(range.value()));
                type7.setUnit(unit == null ? null : unit.value());
                if (request.getClazz() == Double.TYPE) {
                    binding = new DoubleBindingDefault(type7);
                }
                if (request.getClazz() == Double.class) {
                    binding = new DoubleBindingDefault(type7);
                }
                if (request.getClazz() == MutableDouble.class) {
                    binding = new MutableDoubleBinding(type7);
                }
            }
            this.repository.put(request, binding);
            return binding;
        }
        if (request.getClazz() == Boolean.class || request.getClazz() == Boolean.TYPE || request.getClazz() == MutableBoolean.class) {
            BooleanBinding binding = null;
            if (request.getClazz() == Boolean.class || request.getClazz() == Boolean.TYPE) {
                binding = Bindings.BOOLEAN;
            }
            if (request.getClazz() == MutableBoolean.class) {
                binding = Bindings.MUTABLE_BOOLEAN;
            }
            if (binding == null) {
                throw new BindingConstructionException("Cannot bind to " + request.getClazz().getSimpleName());
            }
            this.repository.put(request, binding);
            return binding;
        }
        if (request.getClazz() == String.class || request.getClazz() == MutableString.class) {
            Length length = request.getAnnotation(Length.class);
            MIMEType mimeType = request.getAnnotation(MIMEType.class);
            Pattern pattern = request.getAnnotation(Pattern.class);
            StringBinding binding = null;
            if (length == null && mimeType == null && pattern == null) {
                if (request.getClazz() == String.class) {
                    binding = Bindings.STRING;
                }
                if (request.getClazz() == MutableString.class) {
                    binding = Bindings.MUTABLE_STRING;
                }
            } else {
                StringType type8 = new StringType();
                type8.setLength(length == null ? null : Range.valueOf(length.value()[0]));
                type8.setMimeType(mimeType == null ? null : mimeType.value());
                type8.setPattern(pattern == null ? null : pattern.value());
                if (request.getClazz() == String.class) {
                    binding = new StringBindingDefault(type8);
                }
                if (request.getClazz() == MutableString.class) {
                    binding = new MutableStringBinding(type8);
                }
            }
            if (binding == null) {
                throw new BindingConstructionException("Cannot bind to " + request.getClazz().getSimpleName());
            }
            this.repository.put(request, binding);
            return binding;
        }
        for (BindingProvider factory : this.subFactories) {
            Binding binding;
            Binding result = factory.provideBinding(this, request);
            if (result == null) continue;
            if (result instanceof ArrayBinding) {
                int i;
                binding = (ArrayBinding)result;
                ArrayType type9 = ((ArrayBinding)binding).type();
                Length lengthAnnotation = request.getAnnotation(Length.class);
                Arguments argumentsAnnotation = request.getAnnotation(Arguments.class);
                Annotation[] componentAnnotations = request.dropAnnotations(1, lengthAnnotation);
                Class<Object> componentClass = argumentsAnnotation != null ? argumentsAnnotation.value()[0] : request.getClazz().getComponentType();
                Range[] lengths = null;
                if (lengthAnnotation != null) {
                    String[] strs = lengthAnnotation.value();
                    lengths = new Range[strs.length];
                    i = 0;
                    while (i < strs.length) {
                        lengths[i] = Range.valueOf(strs[i]);
                        ++i;
                    }
                }
                if (((ArrayBinding)binding).componentBinding == null && request.componentBindings != null) {
                    ((ArrayBinding)binding).componentBinding = request.componentBindings[0];
                }
                if (((ArrayBinding)binding).componentBinding == null) {
                    BindingRequest componentRequest;
                    BindingRequest bindingRequest = componentRequest = request.componentRequests != null ? request.componentRequests[0] : null;
                    if (componentRequest == null) {
                        if (componentClass == null) {
                            componentClass = Object.class;
                        }
                        componentRequest = new BindingRequest(componentClass, componentAnnotations);
                    }
                    this.inprogress.put(request, binding);
                    ((ArrayBinding)binding).componentBinding = this.construct(componentRequest);
                    this.inprogress.remove(request);
                }
                type9.componentType = ((ArrayBinding)binding).componentBinding.type();
                ArrayType t = type9;
                if (lengths != null) {
                    i = 0;
                    while (i < lengths.length) {
                        t.setLength(lengths[i]);
                        if (i < lengths.length - 1) {
                            t = (ArrayType)t.componentType;
                        }
                        ++i;
                    }
                }
            }
            if (result instanceof MapBinding) {
                binding = (MapBinding)result;
                Arguments argumentsAnnotation = request.getAnnotation(Arguments.class);
                Annotation[] componentAnnotations = request.dropAnnotations(2, new Annotation[0]);
                Class<?>[] arguments = argumentsAnnotation != null ? argumentsAnnotation.value() : null;
                BindingRequest keyRequest = null;
                BindingRequest valueRequest = null;
                Binding keyBinding = null;
                Binding valueBinding = null;
                if (((MapBinding)binding).getKeyBinding() != null) {
                    keyBinding = ((MapBinding)binding).getKeyBinding();
                } else if (request.componentBindings != null) {
                    keyBinding = request.componentBindings[0];
                } else if (request.componentRequests != null) {
                    keyRequest = request.componentRequests[0];
                } else {
                    Class<Object> keyClass;
                    Class clazz = keyClass = arguments != null && arguments.length >= 1 ? arguments[0] : null;
                    if (keyClass == null) {
                        keyClass = Object.class;
                    }
                    keyRequest = new BindingRequest(keyClass, componentAnnotations);
                }
                if (((MapBinding)binding).getValueBinding() != null) {
                    valueBinding = ((MapBinding)binding).getValueBinding();
                } else if (request.componentBindings != null) {
                    valueBinding = request.componentBindings[1];
                } else if (request.componentRequests != null) {
                    valueRequest = request.componentRequests[1];
                } else {
                    Class<Object> valueClass;
                    Class clazz = valueClass = arguments != null && arguments.length >= 2 ? arguments[1] : null;
                    if (valueClass == null) {
                        valueClass = Object.class;
                    }
                    valueRequest = new BindingRequest(valueClass, componentAnnotations);
                }
                this.inprogress.put(request, result);
                if (keyRequest != null) {
                    keyBinding = this.construct(keyRequest);
                }
                if (valueRequest != null) {
                    valueBinding = this.construct(valueRequest);
                }
                this.inprogress.remove(request);
                MapType type10 = ((MapBinding)binding).type();
                type10.keyType = keyBinding.type();
                type10.valueType = valueBinding.type();
                ((MapBinding)binding).setKeyBinding(keyBinding);
                ((MapBinding)binding).setValueBinding(valueBinding);
            }
            this.repository.put(request, result);
            return result;
        }
        if (request.getClazz().isEnum()) {
            Enum[] enums = (Enum[])request.getClazz().getEnumConstants();
            type = new UnionType();
            type.components = new Component[enums.length];
            int i = 0;
            while (i < enums.length) {
                String name = enums[i].name();
                type.components[i] = new Component(name, new RecordType(false, new Component[0]));
                ++i;
            }
            EnumClassBinding binding = new EnumClassBinding(type, request.getClazz());
            this.repository.put(request, binding);
            return binding;
        }
        if (request.hasAnnotation(Union.class)) {
            Union union = request.getAnnotation(Union.class);
            type = new UnionType();
            UnionClassBinding binding = new UnionClassBinding(type);
            Class<?>[] cases = union.value();
            int count = cases.length;
            Binding[] componentBindings = new Binding[count];
            type.components = new Component[count];
            binding.componentClasses = new Class[count];
            binding.setComponentBindings(componentBindings);
            this.inprogress.put(request, binding);
            int i = 0;
            while (i < count) {
                binding.componentClasses[i] = cases[i];
                Component component = type.components[i] = new Component(cases[i].getSimpleName(), null);
                BindingRequest componentRequest = new BindingRequest(cases[i]);
                Binding componentBinding = componentBindings[i] = this.construct(componentRequest);
                component.type = componentBinding.type();
                ++i;
            }
            this.inprogress.remove(request);
            this.repository.put(request, binding);
            return binding;
        }
        RecordType type11 = new RecordType();
        ClassInfo ci = ClassInfo.getInfo(request.getClazz());
        boolean publicClass = Modifier.isPublic(request.getClazz().getModifiers());
        boolean useAsmBinding = this.asmClassBindingFactory != null && publicClass;
        RecordBindingProvider f = useAsmBinding ? this.asmClassBindingFactory : this.refClassBindingFactory;
        RecordBinding binding = f.provideRecordBinding(request.getClazz(), type11);
        int count = ci.fields.length;
        Binding[] componentBindings = binding.getComponentBindings();
        Component[] components = new Component[count];
        type11.setReferable(request.getAnnotation(Referable.class) != null);
        type11.setComponents(components);
        this.inprogress.put(request, binding);
        ArrayList<Integer> identifierIndices = new ArrayList<Integer>(1);
        int i = 0;
        while (i < type11.getComponentCount()) {
            Field field = ci.fields[i];
            Annotation[] annotations = ClassBindingFactory.getFieldAnnotations(field);
            Class<?> fieldClass = field.getType();
            BindingRequest componentRequest = new BindingRequest(fieldClass, annotations);
            Name nameAnnotation = componentRequest.getAnnotation(Name.class);
            String fieldName = nameAnnotation != null ? nameAnnotation.value() : field.getName();
            Component c = components[i] = new Component(fieldName, null);
            Identifier idAnnotation = componentRequest.getAnnotation(Identifier.class);
            if (idAnnotation != null) {
                componentRequest = componentRequest.withAnnotations(componentRequest.dropAnnotations(1, idAnnotation));
                identifierIndices.add(i);
            }
            Binding componentBinding = componentBindings[i] = this.construct(componentRequest);
            c.type = componentBinding.type();
            ++i;
        }
        type11.setIdentifiers(identifierIndices);
        this.inprogress.remove(request);
        this.repository.put(request, binding);
        return binding;
    }

    public Binding construct(BindingRequest request) throws BindingConstructionException {
        if (this.failures.containsKey(request)) {
            throw this.failures.get(request);
        }
        if (this.inprogress.containsKey(request)) {
            return this.inprogress.get(request);
        }
        if (this.repository.containsRequest(request)) {
            return this.repository.get(request);
        }
        try {
            Binding defaultBinding;
            Binding binding = this.doConstruct(request);
            if ((this.inprogress.isEmpty() || this.isComplete(binding, new IdentityHashSet<Binding>())) && (defaultBinding = this.defaultBindingFactory.getBinding(binding.type())) != null && defaultBinding.equals(binding)) {
                binding = defaultBinding;
            }
            return binding;
        }
        catch (RangeException e) {
            this.inprogress.remove(request);
            BindingConstructionException bce = new BindingConstructionException(e);
            this.failures.put(request, bce);
            throw bce;
        }
        catch (BindingConstructionException e) {
            this.inprogress.remove(request);
            this.failures.put(request, e);
            throw e;
        }
        catch (Throwable t) {
            BindingConstructionException bce = new BindingConstructionException(t);
            this.inprogress.remove(request);
            this.failures.put(request, bce);
            throw bce;
        }
    }

    boolean isComplete(Binding binding, IdentityHashSet<Binding> checked) {
        for (Binding b : this.inprogress.values()) {
            if (b != binding) continue;
            return false;
        }
        if (checked.contains(binding)) {
            return true;
        }
        if (binding.getComponentCount() > 0) {
            checked.add(binding);
            int i = 0;
            while (i < binding.getComponentCount()) {
                if (!this.isComplete(binding.getComponentBinding(i), checked)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public <T extends Binding> T getBinding(Class<?> clazz) throws BindingConstructionException {
        return (T)this.construct(new BindingRequest(clazz));
    }

    public <T extends Binding> T getBinding(Class<?> clazz, Class<?> ... parameters) throws BindingConstructionException {
        ArgumentImpl args = new ArgumentImpl(parameters);
        BindingRequest request = new BindingRequest(clazz, args);
        return (T)this.construct(request);
    }

    public Binding getBinding(BindingRequest request) throws BindingConstructionException {
        return this.construct(request);
    }

    public Binding getBindingUnchecked(BindingRequest request) throws RuntimeBindingConstructionException {
        try {
            return this.construct(request);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public static Annotation[] getFieldAnnotations(Field field) {
        Annotation[] annotations = (Annotation[])field.getAnnotations().clone();
        ArrayList list = new ArrayList();
        ClassBindingFactory.getTypes(field.getGenericType(), list);
        Class<?> fieldClass = list.remove(0);
        Class<?>[] parameterClasses = list.isEmpty() ? NO_CLASSES : list.toArray(NO_CLASSES);
        return ClassBindingFactory.getTypeAnnotations(annotations, fieldClass, parameterClasses);
    }

    public static Annotation[] getMethodAnnotations(Method method) {
        Annotation[] annotations = (Annotation[])method.getAnnotations().clone();
        ArrayList list = new ArrayList();
        ClassBindingFactory.getTypes(method.getGenericReturnType(), list);
        Class<?> valueClass = list.remove(0);
        Class<?>[] parameterClasses = list.isEmpty() ? NO_CLASSES : list.toArray(NO_CLASSES);
        return ClassBindingFactory.getTypeAnnotations(annotations, valueClass, parameterClasses);
    }

    private static Annotation[] getTypeAnnotations(Annotation[] annotations, Class<?> fieldClass, Class<?>[] parameterClasses) {
        Class<?> keyType;
        Annotation[] a2;
        if (Set.class.isAssignableFrom(fieldClass) && parameterClasses != null && parameterClasses.length == 1) {
            a2 = new Annotation[annotations.length + 1];
            System.arraycopy(annotations, 0, a2, 0, annotations.length);
            keyType = parameterClasses[0];
            a2[annotations.length] = new ArgumentImpl(keyType);
            annotations = a2;
        }
        if (Map.class.isAssignableFrom(fieldClass) && parameterClasses != null && parameterClasses.length == 2) {
            a2 = new Annotation[annotations.length + 1];
            System.arraycopy(annotations, 0, a2, 0, annotations.length);
            keyType = parameterClasses[0];
            Class<?> valueType = parameterClasses[1];
            a2[annotations.length] = new ArgumentImpl(keyType, valueType);
            annotations = a2;
        }
        if (List.class.isAssignableFrom(fieldClass) && parameterClasses != null && parameterClasses.length == 1) {
            a2 = new Annotation[annotations.length + 1];
            System.arraycopy(annotations, 0, a2, 0, annotations.length);
            Class<?> componentType = parameterClasses[0];
            a2[annotations.length] = new ArgumentImpl(componentType);
            annotations = a2;
        }
        if (parameterClasses != null && parameterClasses.length > 0) {
            a2 = new Annotation[annotations.length + 1];
            System.arraycopy(annotations, 0, a2, 0, annotations.length);
            a2[annotations.length] = new ArgumentImpl(parameterClasses);
            annotations = a2;
        }
        return annotations;
    }

    static void getTypes(Type type, Collection<Class<?>> result) {
        if (type instanceof Class) {
            result.add((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            ClassBindingFactory.getTypes(p.getRawType(), result);
            Type[] typeArray = p.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type x = typeArray[n2];
                ClassBindingFactory.getTypes(x, result);
                ++n2;
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)type;
            Type componentType = at.getGenericComponentType();
            ArrayList list = new ArrayList(1);
            ClassBindingFactory.getTypes(componentType, list);
            Object dummy = Array.newInstance(list.get(0), 0);
            result.add(dummy.getClass());
        } else if (type instanceof TypeVariable) {
            result.add(Object.class);
        } else {
            throw new RuntimeException(String.valueOf(type.getClass()) + " is not implemented");
        }
    }

    static Type[] getParameterTypes(Field f) {
        Type t = f.getGenericType();
        if (t == null || !(t instanceof ParameterizedType)) {
            return new Class[0];
        }
        ParameterizedType p = (ParameterizedType)t;
        return p.getActualTypeArguments();
    }
}

