/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.mutable;

import java.util.Set;
import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.ImmutableVariantBinding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;

public class MutableVariantBinding
extends ImmutableVariantBinding {
    public MutableVariantBinding(ClassBindingFactory bindingFactory, AdapterFactory adapterFactory) {
        super(bindingFactory, adapterFactory);
    }

    @Override
    public Object create(Binding binding, Object value) throws BindingException {
        return new MutableVariant(binding, value);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof MutableVariant;
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        if (obj == null) {
            throw new BindingException("null value is not MutableVariant");
        }
        if (!(obj instanceof MutableVariant)) {
            throw new BindingException("wrong class, MutableVariant expected");
        }
        MutableVariant var = (MutableVariant)obj;
        if (var.binding == null) {
            throw new BindingException("Binding is expected");
        }
        var.binding.assertInstaceIsValid(var.value, validInstances);
    }

    @Override
    public void setContent(Object variant, Binding binding, Object value) throws BindingException {
        assert (this.isValid(binding, value));
        MutableVariant var = (MutableVariant)variant;
        var.binding = binding;
        var.value = value;
    }
}

