/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.HashSetBinding;
import org.simantics.databoard.binding.impl.TreeSetBinding;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.RecordType;

public class DefaultSetBinding
extends MapBinding {
    public DefaultSetBinding(MapType mapType, Binding elementBinding) {
        super(mapType, elementBinding, VoidBinding.VOID_BINDING);
    }

    public DefaultSetBinding(Binding elementBinding) {
        super(new MapType(elementBinding.type(), RecordType.VOID_TYPE), elementBinding, VoidBinding.VOID_BINDING);
    }

    @Override
    public void clear(Object set) throws BindingException {
        Set _set = (Set)set;
        _set.clear();
    }

    @Override
    public boolean containsKey(Object set, Object key) throws BindingException {
        Set _set = (Set)set;
        return _set.contains(key);
    }

    @Override
    public boolean containsValue(Object set, Object value) throws BindingException {
        return false;
    }

    @Override
    public Object create() throws BindingException {
        return new TreeSet<Object>(this.keyBinding);
    }

    public Object create(Set<?> initialSet) throws BindingException {
        return initialSet;
    }

    @Override
    public Object create(Map<?, ?> initialMap) throws BindingException {
        TreeSet<Object> result = new TreeSet<Object>(this.keyBinding);
        result.addAll(initialMap.keySet());
        return result;
    }

    @Override
    public Object create(Object[] keys, Object[] values) throws BindingException {
        TreeSet<Object> result = new TreeSet<Object>(this.keyBinding);
        int i = 0;
        while (i < keys.length) {
            result.add(keys[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Object create(List<Object> keys, List<Object> values) {
        TreeSet<Object> result = new TreeSet<Object>(this.keyBinding);
        int i = 0;
        while (i < keys.size()) {
            result.add(keys.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public Object get(Object set, Object key) throws BindingException {
        return null;
    }

    @Override
    public <K, V> void getAll(Object setFrom, Map<K, V> to) throws BindingException {
        Map _to = to;
        Set _setFrom = (Set)setFrom;
        for (Object k : _setFrom) {
            _to.put(k, null);
        }
    }

    @Override
    public void getAll(Object setFrom, Object[] keys, Object[] values) throws BindingException {
        Set _setFrom = (Set)setFrom;
        int i = 0;
        for (Object k : _setFrom) {
            keys[i] = k;
            values[i] = null;
            ++i;
        }
    }

    @Override
    public Object[] getKeys(Object set) throws BindingException {
        Set _set = (Set)set;
        return _set.toArray(new Object[_set.size()]);
    }

    @Override
    public void getKeys(Object set, Set<Object> keys) throws BindingException {
        Set s = (Set)set;
        keys.addAll(s);
    }

    @Override
    public Object[] getValues(Object set) throws BindingException {
        Set _set = (Set)set;
        return new Object[_set.size()];
    }

    @Override
    public int count(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws BindingException {
        if (src instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).count(src, from, fromInclusive, end, endInclusive);
        }
        return new HashSetBinding(this.keyBinding).count(src, from, fromInclusive, end, endInclusive);
    }

    @Override
    public int getEntries(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding dstKeyArrayBinding, Object dstKeyArray, ArrayBinding dstValueArrayBinding, Object dstValueArray, int limit) throws BindingException {
        return 0;
    }

    public void put(Object set, Object key, Object value) throws BindingException {
        Set _set = (Set)set;
        if (value != null) {
            throw new BindingException("Cannot put non-null to a Set");
        }
        _set.add(key);
    }

    public void putAll(Object setTo, Set<?> from) {
        Set _set = (Set)setTo;
        _set.addAll(from);
    }

    @Override
    public <K, V> void putAll(Object setTo, Map<K, V> from) throws BindingException {
        Set _set = (Set)setTo;
        _set.addAll(from.keySet());
    }

    @Override
    public Object remove(Object set, Object key) throws BindingException {
        Set _set = (Set)set;
        _set.remove(key);
        return null;
    }

    @Override
    public int size(Object set) throws BindingException {
        Set _set = (Set)set;
        return _set.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Set;
    }

    @Override
    public Object getCeilingKey(Object set, Object key) {
        if (set instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).getCeilingKey(set, key);
        }
        return new HashSetBinding(this.keyBinding).getCeilingKey(set, key);
    }

    @Override
    public Object getFirstKey(Object set) {
        if (set instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).getFirstKey(set);
        }
        return new HashSetBinding(this.keyBinding).getFirstKey(set);
    }

    @Override
    public Object getFloorKey(Object set, Object key) {
        if (set instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).getFloorKey(set, key);
        }
        return new HashSetBinding(this.keyBinding).getFloorKey(set, key);
    }

    @Override
    public Object getHigherKey(Object set, Object key) {
        if (set instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).getHigherKey(set, key);
        }
        return new HashSetBinding(this.keyBinding).getHigherKey(set, key);
    }

    @Override
    public Object getLastKey(Object set) {
        if (set instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).getLastKey(set);
        }
        return new HashSetBinding(this.keyBinding).getLastKey(set);
    }

    @Override
    public Object getLowerKey(Object set, Object key) {
        if (set instanceof TreeSet) {
            return new TreeSetBinding(this.keyBinding).getLowerKey(set, key);
        }
        return new HashSetBinding(this.keyBinding).getLowerKey(set, key);
    }
}

