/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.interestset;

import java.util.Map;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.annotations.Optional;

public class ArrayInterestSet
extends InterestSet {
    public static final ArrayInterestSet MONITOR_EVERYTHING = new ArrayInterestSet(true, null, true, null, null, null);
    public boolean notification;
    @Optional
    public int[] notifications;
    public boolean value;
    @Optional
    public int[] values;
    @Optional
    public InterestSet componentInterest;
    @Optional
    public Map<Integer, InterestSet> componentInterests;

    public ArrayInterestSet(boolean notification, int[] specificNotifications, boolean values, int[] specificValues, InterestSet componentInterest, Map<Integer, InterestSet> componentInterests) {
        this.notification = notification;
        this.notifications = specificNotifications;
        this.value = values;
        this.values = specificValues;
        this.componentInterest = componentInterest;
        this.componentInterests = componentInterests;
    }

    @Override
    public boolean inNotifications() {
        return this.notification | this.value | this.componentInterest != null;
    }

    public boolean inNotificationsOf(int elementIndex) {
        int i;
        if (this.notification || this.value) {
            return true;
        }
        if (this.notifications != null) {
            i = 0;
            while (i < this.notifications.length) {
                if (this.notifications[i] == elementIndex) {
                    return true;
                }
                ++i;
            }
        }
        if (this.values != null) {
            i = 0;
            while (i < this.values.length) {
                if (this.values[i] == elementIndex) {
                    return true;
                }
                ++i;
            }
        }
        if (this.componentInterests != null) {
            InterestSet compositeInterest = this.componentInterests.get(elementIndex);
            return compositeInterest != null;
        }
        return false;
    }

    @Override
    public boolean inValues() {
        return this.value | this.componentInterest != null;
    }

    public boolean inValuesOf(int elementIndex) {
        if (this.value | this.componentInterest != null) {
            return true;
        }
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] == elementIndex) {
                    return true;
                }
                ++i;
            }
        }
        return this.componentInterests != null && this.componentInterests.containsKey(elementIndex);
    }

    public InterestSet getComponentInterest() {
        return this.componentInterest;
    }

    public InterestSet getComponentInterest(int index) {
        if (this.componentInterests == null) {
            return null;
        }
        return this.componentInterests.get(index);
    }
}

