/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.MapEntryAdded;
import org.simantics.databoard.accessor.event.MapEntryRemoved;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileLibrary;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.DirectoryWatch;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.MapInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;

public class DirectoryMap
implements MapAccessor,
CloseableAccessor {
    static final Binding KEY_BINDING = Bindings.STR_VARIANT;
    FileLibrary files;
    DirectoryWatch dir;
    File path;
    ListenerEntry listeners = null;
    Accessor parent;
    AccessorParams params;
    DirectoryWatch.DirectoryListener dirListener = new DirectoryWatch.DirectoryListener(){

        @Override
        public void onWatchEvent(DirectoryWatch.DirectoryEvent e) {
        }
    };
    static MapType type = new MapType(Datatypes.VARIANT, Datatypes.VARIANT);

    public DirectoryMap(File directory) {
        this(directory, null, AccessorParams.DEFAULT);
    }

    public DirectoryMap(File directory, Accessor parent) {
        this(directory, parent, AccessorParams.DEFAULT);
    }

    public DirectoryMap(File directory, Accessor parent, AccessorParams params) {
        this.parent = parent;
        this.path = directory;
        this.params = params;
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                if (filename.length() == 0) {
                    return false;
                }
                char c = filename.charAt(0);
                if (c != 'S' && c != 'I' && c != 'L' && c != 'B') {
                    return false;
                }
                if (filename.endsWith(".dbb")) {
                    return true;
                }
                return filename.toLowerCase().endsWith(".dbb");
            }
        };
        this.dir = new DirectoryWatch(this.path, filter);
        this.dir.addListener(this.dirListener);
        this.files = new FileLibrary();
    }

    @Override
    public void close() {
        this.dir.removeListener(this.dirListener);
        this.dir.close();
        this.files.close();
    }

    @Override
    public MapType type() {
        return type;
    }

    private String fileToKey(File f) {
        String filename = f.getName();
        String keyStr = filename.substring(0, filename.length() - 4);
        return keyStr;
    }

    private File keyToFile(String keyStr) {
        return new File(this.path, keyStr + ".dbb");
    }

    @Override
    public void clear() throws AccessorException {
        ArrayList<File> failList = new ArrayList<File>();
        boolean hasListeners = this.listeners != null;
        ArrayList<String> keys = hasListeners ? new ArrayList<String>() : null;
        this.files.close();
        for (File f : this.dir.files()) {
            if (!this.files.deleteFile(f)) {
                failList.add(f);
            }
            if (!hasListeners) continue;
            String string = this.fileToKey(f);
            keys.add(string);
        }
        this.dir.refresh();
        ListenerEntry le = this.listeners;
        while (le != null) {
            MapInterestSet is = (MapInterestSet)le.getInterestSet();
            for (Object e : keys) {
                MutableVariant var = new MutableVariant(KEY_BINDING, e);
                if (!is.inNotificationsOf(var)) continue;
                MapEntryRemoved e2 = new MapEntryRemoved(var);
                this.emitEvent(le, e2);
            }
            le = le.next;
        }
        if (!failList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to delete");
            for (File file : failList) {
                sb.append(' ');
                sb.append(file.toString());
            }
            throw new AccessorException(sb.toString());
        }
    }

    public String toString() {
        return this.dir.toString();
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        MapBinding mb = (MapBinding)binding;
        if (!(mb.getKeyBinding() instanceof VariantBinding) || !(mb.getValueBinding() instanceof VariantBinding)) {
            throw new AccessorException("Map(Variant, Variant) Expected");
        }
        try {
            Object result = binding.createDefault();
            for (File f : this.dir.files()) {
                String keyStr = this.fileToKey(f);
                Object key = this.params.adapterScheme.adapt(keyStr, KEY_BINDING, mb.getKeyBinding());
                FileVariantAccessor va = this.getValueAccessor(KEY_BINDING, keyStr);
                Object value = va.getValue(mb.getValueBinding());
                mb.put(result, key, value);
            }
            return result;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void getValue(Binding dstBinding, Object dst) throws AccessorException {
        MapBinding db = (MapBinding)dstBinding;
        Binding dkb = db.getKeyBinding();
        Binding dvb = db.getValueBinding();
        if (!(dkb instanceof VariantBinding) || !(dvb instanceof VariantBinding)) {
            throw new AccessorException("Map(Variant, Variant) Expected");
        }
        try {
            TreeSet<Object> dstKeys = new TreeSet<Object>(dkb);
            db.getKeys(dst, dstKeys);
            for (File f : this.dir.files()) {
                String keyStr = this.fileToKey(f);
                Object key = this.params.adapterScheme.adapt(keyStr, KEY_BINDING, dkb);
                Object v = db.containsKey(dst, key) ? db.get(dst, key) : dvb.createDefault();
                FileVariantAccessor va = this.getValueAccessor(KEY_BINDING, keyStr);
                va.getValue(dvb, v);
                db.put(dst, key, v);
                dstKeys.remove(key);
            }
            for (Object key : dstKeys) {
                db.remove(dst, key);
            }
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public boolean getValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.getValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getValue(ChildReference path, Binding binding) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            return a.getValue(binding);
        }
        catch (ReferenceException referenceException) {
            return null;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public boolean containsKey(Binding keyBinding, Object key) throws AccessorException {
        try {
            String key_ = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            File file = this.keyToFile(key_);
            return this.dir.files().contains(file);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsValue(Binding valueBinding, Object value) throws AccessorException {
        try {
            File f;
            String key;
            FileVariantAccessor va;
            Object v;
            boolean match;
            Iterator<File> iterator = this.dir.files().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(match = valueBinding.equals(v = (va = this.getValueAccessor(KEY_BINDING, key = this.fileToKey(f = iterator.next()))).getValue(valueBinding), value)));
            return true;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object get(Binding keyBinding, Object key, Binding valueBinding) throws AccessorException {
        try {
            FileVariantAccessor va = this.getValueAccessor(keyBinding, key);
            return va.getValue(valueBinding);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    public MutableVariant getAsVariant(Binding keyBinding, Object key) throws AccessorException {
        try {
            FileVariantAccessor va = this.getValueAccessor(keyBinding, key);
            Datatype type = va.getContentType();
            Binding binding = this.params.bindingScheme.getBinding(type);
            Object value = va.getContentValue(binding);
            MutableVariant result = new MutableVariant(binding, value);
            return result;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
        catch (BindingConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void getAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> to) throws AccessorException {
        try {
            for (File f : this.dir.files()) {
                String keyStr = this.fileToKey(f);
                Object key = this.params.adapterScheme.adapt(keyStr, KEY_BINDING, keyBinding);
                FileVariantAccessor va = this.getValueAccessor(KEY_BINDING, keyStr);
                Object value = va.getValue(valueBinding);
                to.put(key, value);
            }
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void getAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
        try {
            TreeSet<String> fileKeys = this.createKeys();
            int i = 0;
            for (String keyStr : fileKeys) {
                Object key2;
                FileVariantAccessor va = this.getValueAccessor(KEY_BINDING, keyStr);
                Object value = va.getValue(valueBinding);
                keys[i] = key2 = this.params.adapterScheme.adapt(keyStr, KEY_BINDING, keyBinding);
                values[i] = value;
                ++i;
            }
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public int count(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws AccessorException {
        throw new AccessorException("Not implemented");
    }

    @Override
    public int getEntries(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding keyArrayBinding, Object dstKeys, ArrayBinding valueArrayBinding, Object dstValues, int limit) throws AccessorException {
        throw new AccessorException("Not implemented");
    }

    TreeSet<String> createKeys() throws RuntimeBindingException {
        List<File> files = this.dir.files();
        TreeSet<Object> keys = new TreeSet<Object>(KEY_BINDING);
        for (File f : files) {
            String filename = f.getName();
            String str = filename.substring(0, filename.length() - 4);
            keys.add(str);
        }
        return keys;
    }

    @Override
    public Object getCeilingKey(Binding keyBinding, Object key) throws AccessorException {
        String res;
        block5: {
            TreeSet<String> keys = this.createKeys();
            String k = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            if (keys.contains(k)) {
                return key;
            }
            res = keys.ceiling(k);
            if (res != null) break block5;
            return null;
        }
        try {
            return this.params.adapterScheme.adapt(res, KEY_BINDING, keyBinding);
        }
        catch (RuntimeBindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getFirstKey(Binding keyBinding) throws AccessorException {
        List<File> files = this.dir.files();
        String firstKey = null;
        for (File f : files) {
            String filename = f.getName();
            String str = filename.substring(0, filename.length() - 4);
            if (firstKey == null) {
                firstKey = str;
                continue;
            }
            if (KEY_BINDING.compare(str, firstKey) >= 0) continue;
            firstKey = str;
        }
        if (firstKey == null) {
            return null;
        }
        try {
            return this.params.adapterScheme.adapt(firstKey, KEY_BINDING, keyBinding);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getFloorKey(Binding keyBinding, Object key) throws AccessorException {
        String res;
        block4: {
            TreeSet<String> keys = this.createKeys();
            String k = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            res = keys.floor(k);
            if (res != null) break block4;
            return null;
        }
        try {
            return this.params.adapterScheme.adapt(res, KEY_BINDING, keyBinding);
        }
        catch (RuntimeBindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getHigherKey(Binding keyBinding, Object key) throws AccessorException {
        String res;
        block4: {
            TreeSet<String> keys = this.createKeys();
            String k = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            res = keys.higher(k);
            if (res != null) break block4;
            return null;
        }
        try {
            return this.params.adapterScheme.adapt(res, KEY_BINDING, keyBinding);
        }
        catch (RuntimeBindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object[] getKeys(Binding keyBinding) throws AccessorException {
        TreeSet<String> keys = this.createKeys();
        Object[] result = new Object[keys.size()];
        if (keys.isEmpty()) {
            return result;
        }
        try {
            Adapter a = this.params.adapterScheme.getAdapter(KEY_BINDING, keyBinding, true, false);
            int index = 0;
            for (String key : keys) {
                result[index++] = a.adapt(key);
            }
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        return result;
    }

    @Override
    public Object getLastKey(Binding keyBinding) throws AccessorException {
        List<File> files = this.dir.files();
        String lastKey = null;
        for (File f : files) {
            String filename = f.getName();
            String str = filename.substring(0, filename.length() - 4);
            if (lastKey == null) {
                lastKey = str;
                continue;
            }
            if (KEY_BINDING.compare(str, lastKey) <= 0) continue;
            lastKey = str;
        }
        if (lastKey == null) {
            return null;
        }
        try {
            return this.params.adapterScheme.adapt(lastKey, KEY_BINDING, keyBinding);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getLowerKey(Binding keyBinding, Object key) throws AccessorException {
        String res;
        block4: {
            TreeSet<String> keys = this.createKeys();
            String k = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            res = keys.lower(k);
            if (res != null) break block4;
            return null;
        }
        try {
            return this.params.adapterScheme.adapt(res, KEY_BINDING, keyBinding);
        }
        catch (RuntimeBindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    public FileVariantAccessor getExistingAccessor(Binding keyBinding, Object key) throws AccessorConstructionException {
        try {
            String key_ = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            File file = new File(this.path, key_ + ".dbb");
            return this.files.getExistingFile(file);
        }
        catch (AdaptException e) {
            throw new AccessorConstructionException(e);
        }
    }

    public FileVariantAccessor getValueAccessor(Binding keyBinding, Object key) throws AccessorConstructionException {
        try {
            String keyStr = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            File file = this.keyToFile(keyStr);
            FileVariantAccessor sa = this.files.getExistingFile(file);
            if (sa != null) {
                return sa;
            }
            sa = this.files.getFile(file);
            ListenerEntry le = this.listeners;
            if (le != null) {
                MutableVariant kv = new MutableVariant(keyBinding, key);
                while (le != null) {
                    InterestSet cis;
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    InterestSet gis = is.getComponentInterest();
                    if (gis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new KeyReference(kv));
                            sa.addListener(le.listener, gis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    if ((cis = is.getComponentInterest(kv)) != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new KeyReference(kv));
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            return sa;
        }
        catch (AdaptException e) {
            throw new AccessorConstructionException(e);
        }
    }

    @Override
    public Object[] getValues(Binding valueBinding) throws AccessorException {
        try {
            TreeSet<String> keys = this.createKeys();
            int count = keys.size();
            Object[] result = new Object[count];
            Iterator iter = keys.iterator();
            int i = 0;
            while (i < count) {
                Object value;
                String keyStr = (String)iter.next();
                FileVariantAccessor va = this.getValueAccessor(KEY_BINDING, keyStr);
                result[i] = value = va.getValue(valueBinding);
                ++i;
            }
            return result;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    private boolean putLocal(Binding keyBinding, Object key, Binding valueBinding, Object value) throws AccessorException {
        try {
            String _key = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            File file = new File(this.path, _key + ".dbb");
            boolean created = !this.dir.files().contains(file);
            FileVariantAccessor va = this.files.createFile(file);
            va.setValue(valueBinding, value);
            va.flush();
            if (created) {
                this.dir.add(file);
            }
            MutableVariant kv = new MutableVariant(KEY_BINDING, _key);
            if (this.listeners != null) {
                ListenerEntry le = this.listeners;
                while (le != null) {
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(kv)) {
                        MutableVariant vv = null;
                        if (is.inValuesOf(kv)) {
                            vv = new MutableVariant(valueBinding, valueBinding.isImmutable() ? value : valueBinding.clone(value));
                        }
                        if (!created) {
                            e = new ValueAssigned(new KeyReference(kv), vv);
                            this.emitEvent(le, e);
                        } else {
                            e = new MapEntryAdded(kv, vv);
                            this.emitEvent(le, e);
                        }
                    }
                    le = le.next;
                }
            }
            return created;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void put(Binding keyBinding, Object key, Binding valueBinding, Object value) throws AccessorException {
        this.putLocal(keyBinding, key, valueBinding, value);
    }

    @Override
    public void putAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> from) throws AccessorException {
        for (Map.Entry<Object, Object> e : from.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            this.putLocal(keyBinding, key, valueBinding, value);
        }
    }

    @Override
    public void putAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
        if (keys.length != values.length) {
            throw new AccessorException("Array lengths mismatch");
        }
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            Object value = values[i];
            this.putLocal(keyBinding, key, valueBinding, value);
            ++i;
        }
    }

    @Override
    public void remove(Binding keyBinding, Object key) throws AccessorException {
        try {
            String key_ = (String)this.params.adapterScheme.adapt(key, keyBinding, KEY_BINDING);
            File file = new File(this.path, key_ + ".dbb");
            if (!this.dir.files().contains(file)) {
                return;
            }
            this.files.expunge();
            boolean deleteOk = this.files.deleteFile(file);
            if (!deleteOk) {
                throw new AccessorException("Failed to delete " + String.valueOf(file));
            }
            this.dir.remove(file);
            if (this.listeners != null) {
                MutableVariant var = new MutableVariant(KEY_BINDING, key_);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(var)) {
                        MapEntryRemoved e = new MapEntryRemoved(var);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public boolean setValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.setValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setValue(Binding mapBinding, Object newMap) throws AccessorException {
        try {
            Object filename;
            MapBinding mb = (MapBinding)mapBinding;
            Binding valueBinding = mb.getValueBinding();
            int size = mb.size(newMap);
            Object[] keys = new Object[size];
            Object[] values = new Object[size];
            mb.getAll(newMap, keys, values);
            Adapter keyAdapter = this.params.adapterScheme.getAdapter(mb.getKeyBinding(), KEY_BINDING, true, false);
            HashSet<File> writeFiles = new HashSet<File>();
            List<File> oldFiles = this.dir.files();
            HashSet addedFiles = new HashSet(writeFiles);
            addedFiles.removeAll(oldFiles);
            int i = 0;
            while (i < keys.length) {
                Object key = keys[i];
                Object value = values[i];
                String _key = (String)keyAdapter.adapt(key);
                filename = _key + ".dbb";
                File file = new File(this.path, (String)filename);
                writeFiles.add(file);
                boolean existed = oldFiles.contains(file);
                FileVariantAccessor va = this.files.createFile(file);
                va.setValue(mb.getValueBinding(), value);
                va.flush();
                MutableVariant kv = new MutableVariant(KEY_BINDING, _key);
                if (this.listeners != null) {
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        MapInterestSet is = (MapInterestSet)le.getInterestSet();
                        if (is.inNotificationsOf(kv)) {
                            MutableVariant vv = null;
                            if (is.inValuesOf(kv)) {
                                vv = new MutableVariant(valueBinding, valueBinding.isImmutable() ? value : valueBinding.clone(value));
                            }
                            if (existed) {
                                e = new ValueAssigned(new KeyReference(kv), vv);
                                this.emitEvent(le, e);
                            } else {
                                e = new MapEntryAdded(kv, vv);
                                this.emitEvent(le, e);
                            }
                        }
                        le = le.next;
                    }
                }
                ++i;
            }
            HashSet<File> removedFiles = new HashSet<File>(oldFiles);
            removedFiles.removeAll(writeFiles);
            this.files.expunge();
            if (!removedFiles.isEmpty()) {
                ArrayList<File> failList = new ArrayList<File>();
                for (File f : removedFiles) {
                    filename = f.getName();
                    String keyStr = ((String)filename).substring(0, ((String)filename).length() - 4);
                    boolean deleted = this.files.deleteFile(f);
                    if (!deleted) {
                        failList.add(f);
                    } else if (this.listeners != null) {
                        MutableVariant var = new MutableVariant(KEY_BINDING, keyStr);
                        ListenerEntry le = this.listeners;
                        while (le != null) {
                            MapInterestSet is = (MapInterestSet)le.getInterestSet();
                            if (is.inNotificationsOf(var)) {
                                MapEntryRemoved e = new MapEntryRemoved(var);
                                this.emitEvent(le, e);
                            }
                            le = le.next;
                        }
                    }
                    if (failList.isEmpty()) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Failed to delete");
                    for (File ff : failList) {
                        sb.append(' ');
                        sb.append(ff.toString());
                    }
                    throw new AccessorException(sb.toString());
                }
            }
            this.dir.refresh();
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public int size() throws AccessorException {
        this.dir.refresh();
        return this.dir.files().size();
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        this.listeners = ListenerEntry.link(this.listeners, listener, interestSet, path, executor);
        MapInterestSet is = (MapInterestSet)interestSet;
        try {
            for (File f : this.dir.files()) {
                ChildReference childPath;
                String filename = f.getName();
                String keyStr = filename.substring(0, filename.length() - 4);
                FileVariantAccessor sa = this.getExistingAccessor(KEY_BINDING, keyStr);
                if (sa == null) continue;
                MutableVariant key = new MutableVariant(KEY_BINDING, keyStr);
                InterestSet cis = is.getComponentInterest();
                if (cis != null) {
                    childPath = ChildReference.concatenate(path, new KeyReference(key));
                    sa.addListener(listener, cis, childPath, executor);
                }
                if ((cis = is.getComponentInterest(key)) == null) continue;
                childPath = ChildReference.concatenate(path, new KeyReference(key));
                sa.addListener(listener, cis, childPath, executor);
            }
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void apply(List<Event> cs, LinkedList<Event> rollback) throws AccessorException {
        try {
            boolean makeRollback = rollback != null;
            ArrayList<Event> single = new ArrayList<Event>();
            for (Event e : cs) {
                if (e.reference == null) {
                    Event rbe = this.applyLocal(e, makeRollback);
                    if (!makeRollback) continue;
                    rbe.reference = e.reference;
                    rollback.addFirst(rbe);
                    continue;
                }
                Object sa = this.getComponent(e.reference);
                single.clear();
                Event noRefEvent = e.clone(null);
                single.add(noRefEvent);
                sa.apply(single, rollback);
            }
        }
        catch (AccessorConstructionException ae) {
            throw new AccessorException(ae);
        }
    }

    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ModificationEvent rollback = null;
        try {
            if (e instanceof ValueAssigned) {
                ValueAssigned va = (ValueAssigned)e;
                if (makeRollback) {
                    Binding binding = this.params.bindingScheme.getBinding(this.type());
                    rollback = new ValueAssigned(binding, this.getValue(binding));
                }
                this.setValue(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            if (e instanceof MapEntryAdded) {
                MapEntryAdded ea = (MapEntryAdded)e;
                if (ea.key == null) {
                    throw new AccessorException("Cannot apply entry added event because key is missing");
                }
                if (ea.value == null) {
                    throw new AccessorException("Cannot apply entry added event because value is missing");
                }
                boolean hadValue = this.containsKey(ea.key.getBinding(), ea.key.getValue());
                if (hadValue) {
                    throw new AccessorException("Could not add entry to key that already existed");
                }
                if (makeRollback) {
                    rollback = new MapEntryRemoved(ea.key);
                }
                this.put(ea.key.getBinding(), ea.key.getValue(), ea.value.getBinding(), ea.value.getValue());
            } else if (e instanceof MapEntryRemoved) {
                MapEntryRemoved er = (MapEntryRemoved)e;
                if (makeRollback) {
                    boolean hadValue = this.containsKey(er.key.getBinding(), er.key.getValue());
                    if (hadValue) {
                        MutableVariant oldKey = er.key;
                        MutableVariant oldValue = this.getAsVariant(er.key.getBinding(), er.key.getValue());
                        rollback = new MapEntryAdded(oldKey, oldValue);
                    } else {
                        rollback = new MapEntryRemoved(er.key.clone());
                    }
                }
                this.remove(er.key.getBinding(), er.key.getValue());
            } else {
                throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Map Type");
            }
            return rollback;
        }
        catch (BindingConstructionException e2) {
            throw new AccessorException(e2);
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            try {
                LabelReference lr = (LabelReference)reference;
                MutableVariant variant = (MutableVariant)this.params.adapterScheme.adapt(lr.label, Bindings.STRING, Bindings.MUTABLE_VARIANT);
                Object value = variant.getValue(KEY_BINDING);
                FileVariantAccessor result = this.getValueAccessor(KEY_BINDING, value);
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return (T)result;
            }
            catch (AdaptException e) {
                throw new ReferenceException(e);
            }
        }
        if (reference instanceof KeyReference) {
            try {
                KeyReference ref = (KeyReference)reference;
                String keyStr = (String)this.params.adapterScheme.adapt(ref.key.getValue(), ref.key.getBinding(), KEY_BINDING);
                File f = this.keyToFile(keyStr);
                if (!this.dir.files().contains(f)) {
                    throw new AccessorConstructionException("Invalid reference " + String.valueOf(ref.key));
                }
                FileVariantAccessor result = this.getValueAccessor(KEY_BINDING, keyStr);
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return (T)result;
            }
            catch (AdaptException e) {
                throw new ReferenceException(e);
            }
        }
        throw new ReferenceException(reference.getClass().getName() + " is not a reference of a map");
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        this.detachListener(listener);
    }

    protected ListenerEntry detachListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.listeners;
        ListenerEntry p = null;
        while (e != null) {
            if (e.listener == listener) {
                if (p == null) {
                    this.listeners = e.next;
                    return e;
                }
                p.next = e.next;
                return e;
            }
            p = e;
            e = e.next;
        }
        return null;
    }

    protected void emitEvent(ListenerEntry le, Event e) {
        e.reference = ChildReference.concatenate(le.path, e.reference);
        le.emitEvent(e);
    }

    protected void emitEvents(ListenerEntry le, Collection<Event> events) {
        for (Event e : events) {
            e.reference = ChildReference.concatenate(le.path, e.reference);
        }
        le.emitEvents(events);
    }
}

