package org.simantics.charts.ui;

import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeMap;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;
import org.simantics.db.common.NamedResource;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.TrendItem.Renderer;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.utils.strings.AlphanumComparator;

public class ChartData extends Bean {
	
	public @Optional String name;
	public @Optional Double timeIncrement;  
	public @Optional Double timeStart;  
	public @Optional Double timeLength;
	
	public boolean showMilestones;
	public boolean showGrid;
	public boolean trackExperimentTime;
	public YAxisMode axisMode;

	public boolean backgroundGradient;
	public @Optional float[] backgroundColor1;
	public @Optional float[] backgroundColor2;
	public @Optional float[] gridColor;
	
	public static class ItemKey {
		public final Renderer renderer;
		public final int index;
		public final NamedResource resource;
		public ItemKey(Renderer renderer, int index, NamedResource resource) {
			this.renderer = renderer;
			this.index = index;
			this.resource = resource;
		}
	}

	// Don't allow databoard to handle these since it just screws them up.
	public transient TreeMap<ItemKey, TrendItem> allItems = new TreeMap<>(ITEM_SORTER);
	public transient HashSet<ItemKey> hiddenItems = new HashSet<>();

	private static Comparator<ItemKey> ITEM_SORTER = new Comparator<ItemKey>() {
		@Override
		public int compare(ItemKey o1, ItemKey o2) {
			int c = Integer.compare(o1.renderer.ordinal(), o2.renderer.ordinal());
			if (c != 0)
				return c;
			c = Integer.compare(o1.index, o2.index);
			if (c != 0)
				return c;
			return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(o1.resource.getName(), o2.resource.getName());
		}
	};

	public void readFrom(ChartData other) {
		super.readFrom(other);
		this.allItems = new TreeMap<>(ITEM_SORTER);
		this.allItems.putAll(other.allItems);
		this.hiddenItems = new HashSet<>(other.hiddenItems);
	}

	@Override
	public boolean equals(Object obj) {
		boolean s = super.equals(obj);
		if (!s)
			return false;
		ChartData other = (ChartData) obj;
		return allItems.equals(other.allItems)
				&& hiddenItems.equals(other.hiddenItems);
	}
	
}
