/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.query;

import org.simantics.charts.ui.ChartAndSubscriptionItemDialog;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem.DrawMode;

/**
 * This class wraps Chart Item and referenced Subscription Item data. 
 * 
 * @author toni.kalajainen
 */
public class ChartAndSubscriptionItemData extends Bean {

	public static final Binding BINDING = Bindings.getBindingUnchecked(ChartAndSubscriptionItemData.class);

	public ChartAndSubscriptionItemData() {
		super(BINDING);
	}

	// Input
	public int index;
	@Optional public String chartName;
	@Optional public String variableReference;
	@Optional public String label;
	@Optional public String[] subscriptions;
	
	public boolean binaryMode;
	public boolean hasSubscriptionItem;
	
	/**
	 * Workaround: there's currently no proper support for modifying the following attributes
	 * <ul>
	 * <li>sampling interval</li>
	 * <li>deadband</li>
	 * </ul>
	 * on the fly so by default we simply do not allow it. Set this to
	 * <code>true</code> before opening {@link ChartAndSubscriptionItemDialog}
	 * to allow the user to edit the listed values.
	 */
	public boolean mutableCollectionSettings = false;
	
	// Output
	@Optional public String subscription = "Default";
	@Optional public String unit;
	@Optional public Double min, max, deadband, interval, gain, bias;
	@Optional public DrawMode drawmode;
	@Optional public Scale scale;

	@Optional public Float strokeWidth;
	@Optional public float[] color;

}
