/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.labeldecorators;

import org.simantics.browsing.ui.content.LabelDecorator;

public abstract class AbstractLabelDecorator implements LabelDecorator {

    @Override
    public String decorateLabel(String label, String column, int itemIndex) {
        return label;
    }

    @Override
    public <Color> Color decorateForeground(Color color, String column,
            int itemIndex) {
        return color;
    }

    @Override
    public <Color> Color decorateBackground(Color color, String column,
            int itemIndex) {
        return color;
    }

    @Override
    public <Font> Font decorateFont(Font font, String column, int itemIndex) {
        return font;
    }

}
