/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.views;

import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.browsing.ui.common.views.IFilterStrategy;

public class DefaultFilterStrategy
implements IFilterStrategy {
    private static final boolean DEBUG = false;
    boolean implicitPreAsterisk = true;
    static String[] TEST = new String[]{"foo bar baz biz boz", "biz bar baz foo boz", "foo", "bar", "  foo    bar  ", "quux", "  quux    ", "  quux    foo"};

    public DefaultFilterStrategy() {
        this(true);
    }

    public DefaultFilterStrategy(boolean implicitPreAsterisk) {
        this.implicitPreAsterisk = implicitPreAsterisk;
    }

    private static StringBuilder addSearchWord(StringBuilder sb, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.append('|');
        }
        sb.append('(');
        sb.append(pattern);
        sb.append(')');
        return sb;
    }

    private static String toString(CharBuffer cb) {
        cb.limit(cb.position());
        cb.reset();
        String result = cb.toString();
        cb.limit(cb.capacity());
        return result;
    }

    public static String toSinglePatternString(String filter, boolean implicitPreAsterisk) {
        if (!filter.isEmpty()) {
            filter = filter.toLowerCase();
            Object regExFilter = filter.replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*").replace("?", ".").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("^", "\\^").replace("$", "\\$").replace("|", ".*|").replace("&&", "\\&&");
            if (implicitPreAsterisk && !((String)regExFilter).startsWith(".*")) {
                regExFilter = ".*" + (String)regExFilter;
            }
            if (!((String)regExFilter).endsWith(".*")) {
                regExFilter = (String)regExFilter + ".*";
            }
            return regExFilter;
        }
        return null;
    }

    public static String defaultToPatternString(String filter, boolean implicitPreAsterisk) {
        if (filter.isEmpty()) {
            return null;
        }
        CharBuffer buf = CharBuffer.allocate(filter.length() * 2);
        buf.mark();
        StringBuilder sb = new StringBuilder(filter.length() * 2);
        boolean inQuote = false;
        int len = filter.length();
        int i = 0;
        while (i < len) {
            char ch = filter.charAt(i);
            if (ch == '\"') {
                if (!inQuote) {
                    inQuote = true;
                } else {
                    inQuote = false;
                    DefaultFilterStrategy.addSearchWord(sb, DefaultFilterStrategy.toSinglePatternString(DefaultFilterStrategy.toString(buf), implicitPreAsterisk));
                }
                ++i;
                continue;
            }
            if (ch == '\\') {
                if (++i >= len) break;
                ch = filter.charAt(i);
                buf.append(ch);
                ++i;
                break;
            }
            if (ch == ' ') {
                if (inQuote) {
                    buf.append(ch);
                    ++i;
                    continue;
                }
                if (buf.position() > 0) {
                    DefaultFilterStrategy.addSearchWord(sb, DefaultFilterStrategy.toSinglePatternString(DefaultFilterStrategy.toString(buf), implicitPreAsterisk));
                }
                ++i;
                continue;
            }
            buf.append(ch);
            ++i;
        }
        if (buf.position() > 0) {
            DefaultFilterStrategy.addSearchWord(sb, DefaultFilterStrategy.toSinglePatternString(DefaultFilterStrategy.toString(buf), implicitPreAsterisk));
        }
        return sb.toString();
    }

    @Override
    public String toPatternString(String filter) {
        return DefaultFilterStrategy.defaultToPatternString(filter, this.implicitPreAsterisk);
    }

    public static Pattern compilePattern(String s) {
        DefaultFilterStrategy st = new DefaultFilterStrategy(true);
        System.out.println("compilePattern(" + s + ")");
        String regex = st.toPatternString(s);
        System.out.println(s + " -> " + regex);
        Pattern p = Pattern.compile(regex);
        return p;
    }

    public static void test(String pattern, String ... testStrings) {
        Pattern p = DefaultFilterStrategy.compilePattern(pattern);
        String[] stringArray = testStrings;
        int n = testStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String test = stringArray[n2];
            System.out.print("\ttesting '" + test + "'");
            Matcher m = p.matcher(test);
            if (m.matches()) {
                System.out.println(" - MATCHES");
            } else {
                System.out.println(" - NO MATCH");
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        DefaultFilterStrategy.test("foo$", new String[0]);
        DefaultFilterStrategy.test(".", new String[0]);
        DefaultFilterStrategy.test("*", new String[0]);
        DefaultFilterStrategy.test("?", new String[0]);
        DefaultFilterStrategy.test("+", new String[0]);
        DefaultFilterStrategy.test("^", new String[0]);
        DefaultFilterStrategy.test("&", new String[0]);
        DefaultFilterStrategy.test("&&", new String[0]);
        DefaultFilterStrategy.test("&&&", new String[0]);
        DefaultFilterStrategy.test("|", new String[0]);
        DefaultFilterStrategy.test("(", new String[0]);
        DefaultFilterStrategy.test(")", new String[0]);
        DefaultFilterStrategy.test("[", new String[0]);
        DefaultFilterStrategy.test("]", new String[0]);
        DefaultFilterStrategy.test("{", new String[0]);
        DefaultFilterStrategy.test("}", new String[0]);
        DefaultFilterStrategy.test("()", new String[0]);
        DefaultFilterStrategy.test("[]", new String[0]);
        DefaultFilterStrategy.test("{}", new String[0]);
        DefaultFilterStrategy.test("\\\\", new String[0]);
        DefaultFilterStrategy.test("\\", new String[0]);
        DefaultFilterStrategy.test("foo bar", TEST);
        DefaultFilterStrategy.test("\"foo bar\"", TEST);
        DefaultFilterStrategy.test("\"foo bar\" quux", TEST);
        DefaultFilterStrategy.test("*\"foo bar\" *quux", TEST);
        DefaultFilterStrategy.test("\"*foo bar\" *quux", TEST);
    }
}

