/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.comparators;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.comparators.ImmutableLexicalComparable;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.utils.strings.AlphanumComparator;

public class AlphanumericComparatorFactory
implements ComparableContextFactory {
    private final String column;
    private final String label;
    private final boolean reverse;

    public AlphanumericComparatorFactory(String column) {
        this(column, null, false);
    }

    public AlphanumericComparatorFactory(String column, boolean reverse) {
        this(column, null, reverse);
    }

    public AlphanumericComparatorFactory(String column, String label, boolean reverse) {
        this.column = column;
        this.label = label;
        this.reverse = reverse;
    }

    protected String adjustLabel(String label) {
        return label;
    }

    public ComparableContext[] create(NodeQueryManager manager, NodeContext parent, NodeContext[] children) {
        ComparableContext[] result = new ComparableContext[children.length];
        int i = 0;
        while (i < children.length) {
            String label;
            NodeContext child = children[i];
            Labeler labeler = (Labeler)manager.query(child, BuiltinKeys.SELECTED_LABELER);
            int category = labeler != null ? labeler.getCategory() : 0;
            String string = label = labeler != null ? (String)labeler.getLabels().get(this.column) : "";
            if (label == null) {
                label = "";
            }
            result[i] = new ImmutableLexicalComparable(category, this.adjustLabel(label), child){

                public int compareTo(ComparableContext arg0) {
                    ImmutableLexicalComparable other = (ImmutableLexicalComparable)arg0;
                    int catDelta = this.getCategory() - other.getCategory();
                    if (AlphanumericComparatorFactory.this.reverse) {
                        catDelta = -catDelta;
                    }
                    if (catDelta != 0) {
                        return catDelta;
                    }
                    String label1 = this.getLabel();
                    String label2 = other.getLabel();
                    return AlphanumericComparatorFactory.this.reverse ? AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)label2, (Object)label1) : AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)label1, (Object)label2);
                }
            };
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.label != null ? this.label : (this.reverse ? "Reversed Natural" : "Natural");
    }
}

