/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.db.Database;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.service.ClusterUID;

public class ClusterSupport2
implements ClusterSupport,
IClusterTable {
    private static final boolean DEBUG = false;
    public ClusterManager impl;
    public TIntObjectHashMap<ClusterUID> uidCache = new TIntObjectHashMap();
    ReentrantReadWriteLock uidLock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.ReadLock uidRead = this.uidLock.readLock();
    ReentrantReadWriteLock.WriteLock uidWrite = this.uidLock.writeLock();

    public ClusterSupport2(ClusterManager impl) {
        this.impl = impl;
    }

    public int createClusterKeyByClusterUID(ClusterUID clusterUID, long clusterId) {
        throw new UnsupportedOperationException();
    }

    public ClusterBase getClusterByClusterUIDOrMake(ClusterUID clusterUID) {
        try {
            return this.impl.getClusterByClusterUIDOrMake(clusterUID);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ClusterBase getClusterByClusterId(long clusterId) {
        throw new UnsupportedOperationException();
    }

    public ClusterBase getClusterByClusterIdOrThrow(long clusterId) {
        throw new UnsupportedOperationException();
    }

    public ClusterBase getClusterByClusterKey(int clusterKey) {
        throw new UnsupportedOperationException();
    }

    public ClusterUID getClusterUIDByResourceKey(int resourceKey) throws DatabaseException {
        this.uidRead.lock();
        ClusterUID cuid = (ClusterUID)this.uidCache.get(resourceKey >> 12);
        this.uidRead.unlock();
        if (cuid != null) {
            return cuid;
        }
        this.uidWrite.lock();
        cuid = (ClusterUID)this.uidCache.get(resourceKey >> 12);
        if (cuid == null) {
            cuid = this.impl.getClusterUIDByResourceKeyWithoutMutex(resourceKey);
            this.uidCache.put(resourceKey >> 12, (Object)cuid);
        }
        this.uidWrite.unlock();
        return cuid;
    }

    public int getClusterKeyByClusterUIDOrMake(ClusterUID clusterUID) {
        try {
            return this.impl.getClusterKeyByClusterUIDOrMakeWithoutMutex(clusterUID);
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new RuntimeException(e);
        }
    }

    public int getClusterKeyByClusterUIDOrMake(long id1, long id2) {
        throw new UnsupportedOperationException();
    }

    public ClusterBase getClusterByResourceKey(int resourceKey) {
        throw new UnsupportedOperationException();
    }

    public long getClusterIdOrCreate(ClusterUID clusterUID) {
        return this.impl.getClusterIdOrCreate(clusterUID);
    }

    public void addStatement(Object cluster) {
    }

    public void cancelStatement(Object cluster) {
    }

    public void removeStatement(Object cluster) {
    }

    public void removeValue(Object cluster) {
    }

    public void setImmutable(Object cluster, boolean immutable) {
    }

    public void setDeleted(Object cluster, boolean deleted) {
    }

    public void cancelValue(Object cluster) {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object cluster, long clusterId, byte[] bytes, int length) {
    }

    public void modiValue(Object _cluster, long clusterId, long voffset, int length, byte[] bytes, int offset) {
    }

    public void createResource(Object cluster, short resourceIndex, long clusterId) {
    }

    public void addStatementIndex(Object cluster, int resourceKey, ClusterUID clusterUID, byte op) {
    }

    public void setStreamOff(boolean setOff) {
        throw new UnsupportedOperationException();
    }

    public boolean getStreamOff() {
        return true;
    }

    public ResourceSegment getResourceSegment(int resourceIndex, ClusterUID clusterUID, long offset, short size) throws DatabaseException {
        try {
            Database.Session.ResourceSegment t = this.impl.getResourceSegment(clusterUID.asBytes(), resourceIndex, offset, size);
            return new ResourceSegment(t.getValueSize(), t.getSegment());
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected byte[] getValueBig(ClusterBase cluster, int resourceIndex, int offset, int length) throws DatabaseException {
        assert (offset == 0);
        assert (length == 0);
        ClusterUID clusterUID = cluster.clusterUID;
        try {
            return this.impl.getResourceFile(clusterUID.asBytes(), resourceIndex);
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected InputStream getValueStreamBig(ClusterBase cluster, final int resourceIndex, int offset, int length) throws DatabaseException {
        long rSize;
        final ClusterUID clusterUID = cluster.clusterUID;
        short slen = (short)Math.min(length != 0 ? length : 65535, 65535);
        ResourceSegment s = this.getResourceSegment(resourceIndex, clusterUID, offset, slen);
        if (s.valueSize < 0L) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + " (1).");
        }
        int ilen = slen & 0xFFFF;
        assert (s.bytes.length <= ilen);
        if (length == 0) {
            if (s.valueSize > Integer.MAX_VALUE) {
                throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (2).");
            }
            length = (int)s.valueSize;
        }
        if ((rSize = s.valueSize - (long)offset) < (long)length) {
            throw new DatabaseException("Failed to get value for resource index=" + resourceIndex + " cluster=" + String.valueOf(clusterUID) + " off=" + offset + " len=" + length + ". Value size=" + s.valueSize + " (3).");
        }
        if (length <= 65535) {
            return new ByteArrayInputStream(s.bytes);
        }
        int finalLength = length;
        return new InputStream(finalLength, s){
            int left;
            long valueOffset;
            int offset;
            ResourceSegment _s;
            {
                this.left = n;
                this.valueOffset = 0L;
                this.offset = 0;
                this._s = resourceSegment;
            }

            @Override
            public int read() throws IOException {
                int result;
                if (this.left <= 0) {
                    return -1;
                }
                if (this.offset == this._s.bytes.length) {
                    short slen = (short)Math.min(this.left, 65535);
                    this.valueOffset += (long)this._s.bytes.length;
                    try {
                        this._s = ClusterSupport2.this.getResourceSegment(resourceIndex, clusterUID, this.valueOffset, slen);
                    }
                    catch (DatabaseException e) {
                        throw new IOException(e);
                    }
                    this.offset = 0;
                }
                --this.left;
                if ((result = this._s.bytes[this.offset++]) < 0) {
                    result += 256;
                }
                return result;
            }
        };
    }

    public InputStream getValueStreamEx(int resourceIndex, long clusterId) throws DatabaseException {
        ClusterImpl cluster = this.impl.getClusterByClusterUIDOrMakeProxy(ClusterUID.make((long)0L, (long)clusterId));
        return this.getValueStreamBig(cluster, resourceIndex, 0, 0);
    }

    public byte[] getValueEx(int resourceIndex, long clusterId) throws DatabaseException {
        ClusterImpl cluster = this.impl.getClusterByClusterUIDOrMakeProxy(ClusterUID.make((long)0L, (long)clusterId));
        return this.getValueBig(cluster, resourceIndex, 0, 0);
    }

    public byte[] getValueEx(int resourceIndex, long clusterId, long voffset, int length) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public long getValueSizeEx(int resourceIndex, long clusterId) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public int wait4RequestsLess(int limit) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public Session getSession() {
        return null;
    }

    public IClusterTable getClusterTable() {
        return this;
    }

    public <T extends ClusterI> T getClusterByClusterUIDOrMakeProxy(ClusterUID clusterUID) {
        try {
            return (T)((Object)this.impl.getClusterByClusterUIDOrMakeProxy(clusterUID));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends ClusterI> T getClusterProxyByResourceKey(int resourceKey) {
        try {
            return this.impl.getClusterProxyByResourceKey(resourceKey);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getClusterKeyByUID(long id1, long id2) throws DatabaseException {
        return this.impl.getClusterKeyByUID(id1, id2);
    }

    private static class ResourceSegment {
        public long valueSize;
        public byte[] bytes;

        ResourceSegment(long valueSize, byte[] bytes) {
            this.valueSize = valueSize;
            this.bytes = bytes;
        }
    }
}

