/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.simantics.utils.datastructures.MapList;
import org.simantics.xml.data.XmlDataConverter;
import org.simantics.xml.sax.ExporterGenerator;
import org.simantics.xml.sax.ImporterGenerator;
import org.simantics.xml.sax.ManualSchemaFileImport;
import org.simantics.xml.sax.OntologyGenerator;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.configuration.Configuration;
import org.simantics.xml.sax.configuration.ObjectFactory;
import org.w3._2001.xmlschema.Annotation;
import org.w3._2001.xmlschema.Import;
import org.w3._2001.xmlschema.Include;
import org.w3._2001.xmlschema.OpenAttrs;
import org.w3._2001.xmlschema.Schema;

public class SchemaConverter {
    protected File outputPlugin;
    protected File schemaFile;
    protected File conversionFile;
    protected File ontologyFile;
    protected File parserDir;
    protected Schema schema;
    protected Configuration configuration;
    protected String pluginName;
    private String[] header;
    boolean createPGraph = true;
    boolean createImporter = true;
    boolean createExporter = true;
    private List<SchemaConverter> parent = new ArrayList<SchemaConverter>();
    private List<SchemaConverter> subConverters = new ArrayList<SchemaConverter>();
    private Map<String, SchemaConverter> fileMap;
    private MapList<String, SchemaConverter> schemaNSMap;
    private MapList<String, SchemaConverter> shortNameMap;
    protected String schemaNs;
    protected String ontologyUri;
    protected String className;
    protected String name;
    protected String shortName;
    protected SchemaConversionBase base;
    private ManualSchemaFileImport fileImport;
    boolean init = false;
    private boolean converting = false;

    public SchemaConverter(File schemaFile, File conversionFile, File outputPlugin) throws IOException {
        this(null, schemaFile, conversionFile, outputPlugin);
    }

    public SchemaConverter(SchemaConverter parent, File schemaFile, File conversionFile, File outputPlugin) throws IOException {
        if (schemaFile == null || outputPlugin == null) {
            throw new IllegalArgumentException();
        }
        this.outputPlugin = outputPlugin;
        this.schemaFile = schemaFile;
        this.conversionFile = conversionFile;
        this.pluginName = outputPlugin.getName();
        String[] packageParts = this.pluginName.split("\\.");
        Object outputLoc = outputPlugin.getAbsolutePath();
        outputLoc = (String)outputLoc + "/src";
        String[] stringArray = packageParts;
        int n = packageParts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            outputLoc = (String)outputLoc + "/" + s;
            ++n2;
        }
        Object outputGraph = outputPlugin.getAbsolutePath();
        outputGraph = (String)outputGraph + "/graph";
        outputGraph = (String)outputGraph + "/" + schemaFile.getName().substring(0, schemaFile.getName().length() - 4) + ".pgraph";
        this.ontologyFile = new File((String)outputGraph);
        this.parserDir = new File((String)outputLoc);
        if (parent != null) {
            this.parent.add(parent);
            parent.subConverters.add(this);
        } else {
            this.fileMap = new LinkedHashMap<String, SchemaConverter>();
            this.schemaNSMap = new MapList();
            this.shortNameMap = new MapList();
        }
        this.getRoot().fileMap.put(schemaFile.getAbsolutePath(), this);
    }

    public List<SchemaConverter> getConverter(String schemaNS) {
        return this.getRoot().schemaNSMap.getValues((Object)schemaNS);
    }

    public void setFileImport(ManualSchemaFileImport fileImport) {
        this.fileImport = fileImport;
    }

    public void setCreateExporter(boolean createExporter) {
        this.createExporter = createExporter;
    }

    public void setCreateImporter(boolean createImporter) {
        this.createImporter = createImporter;
    }

    public void setCreatePGraph(boolean createPGraph) {
        this.createPGraph = createPGraph;
    }

    protected SchemaConverter createSubConverter(String location, String ns) throws JAXBException, IOException {
        SchemaConverter subConverter;
        File directory = this.schemaFile.getParentFile();
        File schemaFile = new File(directory.getAbsolutePath() + File.separator + location);
        if (!schemaFile.exists()) {
            if (this.getRoot().fileImport != null) {
                schemaFile = this.getRoot().fileImport.getFileForLocation(location);
            }
            if (!schemaFile.exists()) {
                throw new FileNotFoundException(schemaFile.getAbsolutePath());
            }
        }
        if ((subConverter = this.getRoot().fileMap.get(schemaFile.getAbsolutePath())) == null) {
            subConverter = this.constructSubConverter(this, schemaFile, this.conversionFile, this.outputPlugin, ns);
            subConverter.createPGraph = this.createPGraph;
            subConverter.createImporter = this.createImporter;
            subConverter.createExporter = this.createExporter;
        } else {
            subConverter.parent.add(this);
            this.subConverters.add(subConverter);
        }
        return subConverter;
    }

    protected SchemaConverter constructSubConverter(SchemaConverter parent, File schemaFile, File conversionFile, File outputPlugin, String ns) throws IOException {
        return new SchemaConverter(parent, schemaFile, conversionFile, outputPlugin);
    }

    protected SchemaConverter getRoot() {
        if (this.fileMap != null) {
            return this;
        }
        HashSet<SchemaConverter> processed = new HashSet<SchemaConverter>();
        return this._getRoot(processed);
    }

    protected SchemaConverter _getRoot(Set<SchemaConverter> processed) {
        if (processed.contains(this)) {
            return null;
        }
        if (this.fileMap != null) {
            return this;
        }
        processed.add(this);
        for (SchemaConverter sc : this.parent) {
            if (sc.fileMap == null) continue;
            return sc;
        }
        for (SchemaConverter sc : this.parent) {
            SchemaConverter root = sc._getRoot(processed);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    public void convert() throws JAXBException, IOException {
        this.init();
        for (SchemaConverter sc : this.getRoot().fileMap.values()) {
            sc.doConvert();
        }
    }

    protected void assignShortName() {
        this.shortName = this.name.substring(0, 3).toUpperCase();
        SchemaConverter root = this.getRoot();
        if (!root.shortNameMap.containsKey((Object)this.shortName)) {
            root.shortNameMap.add((Object)this.shortName, (Object)this);
            return;
        }
        SchemaConverter sc = (SchemaConverter)root.shortNameMap.getValues((Object)this.shortName).get(0);
        if (sc.schemaNs.equals(this.schemaNs)) {
            root.shortNameMap.add((Object)this.shortName, (Object)this);
            return;
        }
        int i = 1;
        while (true) {
            String n;
            if (!root.shortNameMap.containsKey((Object)(n = this.shortName + i))) {
                this.shortName = n;
                root.shortNameMap.add((Object)this.shortName, (Object)this);
                return;
            }
            SchemaConverter sc2 = (SchemaConverter)root.shortNameMap.getValues((Object)n).get(0);
            if (sc2.schemaNs.equals(this.schemaNs)) {
                this.shortName = n;
                root.shortNameMap.add((Object)this.shortName, (Object)this);
                return;
            }
            ++i;
        }
    }

    protected Schema createSchema() throws JAXBException, FileNotFoundException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(XmlDataConverter.class.getClassLoader());
            JAXBContext jc = JAXBContext.newInstance((String)"org.w3._2001.xmlschema");
            Unmarshaller u = jc.createUnmarshaller();
            FileInputStream fileStream = new FileInputStream(this.schemaFile);
            Schema schema = (Schema)u.unmarshal((InputStream)fileStream);
            return schema;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected void init() throws IOException, JAXBException {
        if (this.init) {
            return;
        }
        this.init = true;
        this.schema = this.createSchema();
        if (this.conversionFile != null) {
            JAXBContext jc = JAXBContext.newInstance((String)"org.simantics.xml.sax.configuration", (ClassLoader)ObjectFactory.class.getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            FileInputStream fileStream = new FileInputStream(this.conversionFile);
            this.configuration = (Configuration)((JAXBElement)u.unmarshal((InputStream)fileStream)).getValue();
        } else {
            this.configuration = new Configuration();
        }
        this.header = new String[4];
        this.header[0] = "Generated with org.simantics.xml.sax XML schema converter";
        this.header[1] = "";
        this.header[2] = "File " + this.schemaFile.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), "/");
        this.header[3] = "Date " + new Date().toString();
        this.ontologyUri = this.schemaNs = this.schema.getTargetNamespace();
        if (this.ontologyUri == null) {
            this.ontologyUri = this.getSchemaFile().getName();
            int index = this.ontologyUri.lastIndexOf(".");
            if (index > 0) {
                this.ontologyUri = this.ontologyUri.substring(0, index);
            }
            this.schemaNs = "";
        } else if (this.ontologyUri.startsWith("clr-namespace:")) {
            this.ontologyUri = this.ontologyUri.substring("clr-namespace:".length());
            int i = this.ontologyUri.indexOf(";assembly");
            if (i > 0) {
                this.ontologyUri = this.ontologyUri.substring(0, i);
            }
        }
        this.ontologyUri = this.ontologyUri.replaceAll(" ", "_");
        this.ontologyUri = this.ontologyUri.replaceAll(":", "_");
        this.ontologyUri = this.ontologyUri.replaceAll(";", "_");
        String[] parts = this.ontologyUri.split("/");
        int i = parts.length - 1;
        while (i >= 0) {
            this.name = parts[i];
            if (!Character.isDigit(this.name.charAt(0))) break;
            --i;
        }
        if (this.name == null) {
            throw new JAXBException("Could not resolve proper name for schema " + this.ontologyUri);
        }
        this.name = this.name.replaceAll("\\.", "_");
        this.ontologyUri = !this.ontologyUri.startsWith("http://") ? "http://" + this.ontologyUri.replaceAll("/", "_") : "http://" + this.ontologyUri.substring("http://".length()).replaceAll("/", "_");
        String version = this.schema.getVersion();
        if (version == null) {
            version = "1.0";
        }
        this.ontologyUri = String.valueOf(this.ontologyUri) + "-" + version;
        this.className = this.getPluginName() + "." + this.name + "Ontology";
        this.assignShortName();
        if (this.schemaNs != null) {
            this.getRoot().schemaNSMap.add((Object)this.schemaNs, (Object)this);
        }
        this.base = new SchemaConversionBase(this, this.ontologyUri, this.className);
        this.base.init(this.schema);
        for (OpenAttrs attrs : this.schema.getIncludeOrImportOrRedefine()) {
            SchemaConverter sc;
            String location;
            if (attrs instanceof Import) {
                Import imp = (Import)attrs;
                location = imp.getSchemaLocation();
                sc = this.createSubConverter(location, imp.getNamespace());
                sc.init();
                continue;
            }
            if (attrs instanceof Include) {
                Include inc = (Include)attrs;
                location = inc.getSchemaLocation();
                sc = this.createSubConverter(location, null);
                sc.init();
                continue;
            }
            if (attrs instanceof Annotation) continue;
            throw new IOException("Cannot handle schema file " + this.schemaFile.getName() + ", the schema uses redefine elements.");
        }
    }

    protected void doConvert() throws IOException, JAXBException {
        if (this.converting) {
            return;
        }
        this.converting = true;
        if (!this.ontologyFile.exists()) {
            this.ontologyFile.getParentFile().mkdirs();
            this.ontologyFile.createNewFile();
        }
        if (!this.parserDir.exists()) {
            this.parserDir.mkdirs();
        }
        if (this.createPGraph) {
            OntologyGenerator ontologyGenerator = new OntologyGenerator(this, this.base);
            ontologyGenerator.createOntology();
        }
        if (this.createImporter) {
            ImporterGenerator importerGenerator = new ImporterGenerator(this, this.base);
            importerGenerator.createParser();
        }
        if (this.createExporter) {
            ExporterGenerator exporterGenerator = new ExporterGenerator(this, this.base);
            exporterGenerator.createParser();
        }
        this.base.component = null;
    }

    public File getOntologyFile() {
        return this.ontologyFile;
    }

    public File getParserDir() {
        return this.parserDir;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String[] getHeader() {
        return this.header;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<SchemaConverter> getParent() {
        return this.parent;
    }

    public List<SchemaConverter> getSubConverters() {
        return this.subConverters;
    }

    public boolean isPrimary() {
        return true;
    }

    public String getShortName(String namespaceURI) {
        List<SchemaConverter> converters = this.getRoot().getConverter(namespaceURI);
        for (SchemaConverter conv : converters) {
            if (conv.shortName == null) continue;
            return conv.shortName;
        }
        return null;
    }

    public String getOntologyClassName(String namespaceURI) {
        List<SchemaConverter> converters = this.getRoot().getConverter(namespaceURI);
        for (SchemaConverter conv : converters) {
            if (conv.className == null) continue;
            return conv.className;
        }
        return null;
    }
}

