/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.Resource;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ResourceSetIdentifiable;
import org.simantics.interop.mapping.data.ResourceSplitIdentifiable2;

public class ResourceSetSplitIdentifiable2
extends ResourceSetIdentifiable {
    private String identifier;

    public ResourceSetSplitIdentifiable2(Resource resource, String identifier) {
        super(resource);
        this.identifier = identifier;
    }

    public ResourceSetSplitIdentifiable2(String identifier, Resource primary, Resource ... resource) {
        super(primary, resource);
        this.identifier = identifier;
    }

    public ResourceSetSplitIdentifiable2(Resource primary, Collection<Resource> resources, String identifier) {
        super(primary, resources);
        this.identifier = identifier;
    }

    public static Identifiable createIdentifiable(ResourceSetIdentifiable identifiable, String identifier) {
        return new ResourceSetSplitIdentifiable2(identifiable.getPrimary(), identifiable.getResources(), identifier);
    }

    public static Identifiable createIdentifiable(Identifiable identifiable, String identifier) {
        Resource res = identifiable.getAdapter(Resource.class);
        if (res == null) {
            return null;
        }
        Resource[] resources = identifiable.getAdapter(Resource[].class);
        if (resources.length > 1) {
            return new ResourceSetSplitIdentifiable2(identifier, res, resources);
        }
        return ResourceSplitIdentifiable2.createIdentifiable(identifiable, identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ResourceSetSplitIdentifiable2 other = (ResourceSetSplitIdentifiable2)arg0;
        if (!this.identifier.equals(other.identifier)) {
            return false;
        }
        return super.equals(arg0);
    }

    @Override
    public Identifiable merge(Identifiable other) {
        if (other instanceof ResourceSplitIdentifiable2) {
            ResourceSplitIdentifiable2 o = (ResourceSplitIdentifiable2)other;
            if (!o.getIdentifier().equals(this.identifier)) {
                throw new RuntimeException("Cannot be merged, Identifiers do not match " + this.identifier + " " + o.getIdentifier());
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.addAll(this.getResources());
            resources.add(o.getResource());
            ResourceSetSplitIdentifiable2 id = new ResourceSetSplitIdentifiable2(this.getPrimary(), resources, this.identifier);
            return id;
        }
        if (other instanceof ResourceSetSplitIdentifiable2) {
            ResourceSetSplitIdentifiable2 o = (ResourceSetSplitIdentifiable2)other;
            if (!o.getIdentifier().equals(this.identifier)) {
                throw new RuntimeException("Cannot be merged, Identifiers do not match " + this.identifier + " " + o.getIdentifier());
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.addAll(this.getResources());
            resources.addAll(o.getResources());
            ResourceSetSplitIdentifiable2 id = new ResourceSetSplitIdentifiable2(this.getPrimary(), resources, this.identifier);
            return id;
        }
        throw new RuntimeException("Cannot be merged");
    }
}

