/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import vtk.vtkCamera;
import vtk.vtkCanvas;
import vtk.vtkLight;
import vtk.vtkRenderWindow;

public class vtkRenderWindowPanel
extends vtkCanvas {
    private static final long serialVersionUID = 1L;

    public vtkRenderWindowPanel() {
        this.cam = new vtkCamera();
        this.lgt = new vtkLight();
    }

    public vtkRenderWindowPanel(vtkRenderWindow win) {
        super(win);
        this.cam = new vtkCamera();
        this.lgt = new vtkLight();
    }

    @Override
    public synchronized void Render() {
        if (!this.rendering) {
            this.rendering = true;
            if (this.rw != null) {
                if (this.windowset == 0) {
                    this.RenderCreate(this.rw);
                    this.Lock();
                    this.rw.SetSize(this.getWidth(), this.getHeight());
                    this.UnLock();
                    this.windowset = 1;
                }
                this.Lock();
                this.rw.Render();
                this.UnLock();
            }
            this.rendering = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.Lock();
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.iren.LeftButtonPressEvent();
        } else if ((e.getModifiersEx() & 0x800) == 2048) {
            this.iren.MiddleButtonPressEvent();
        } else if ((e.getModifiersEx() & 0x1000) == 4096) {
            this.iren.RightButtonPressEvent();
        }
        this.UnLock();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
        this.Lock();
        this.iren.MouseMoveEvent();
        this.UnLock();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.Lock();
        if (e.getWheelRotation() > 0) {
            this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.iren.MouseWheelBackwardEvent();
        } else if (e.getWheelRotation() < 0) {
            this.iren.SetEventInformationFlipY(e.getX(), e.getY(), this.ctrlPressed, this.shiftPressed, '0', 0, "0");
            this.iren.MouseWheelForwardEvent();
        }
        this.UnLock();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char keyChar = e.getKeyChar();
        this.ctrlPressed = (e.getModifiersEx() & 0x80) == 128 ? 1 : 0;
        this.shiftPressed = (e.getModifiersEx() & 0x40) == 64 ? 1 : 0;
        this.iren.SetEventInformationFlipY(this.lastX, this.lastY, this.ctrlPressed, this.shiftPressed, keyChar, 0, String.valueOf(keyChar));
        this.Lock();
        this.iren.KeyPressEvent();
        this.iren.CharEvent();
        this.UnLock();
    }
}

