/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Vector3d;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.plant3d.geometry.BuiltinGeometryProvider;
import org.simantics.plant3d.geometry.FixedNozzleProvider;
import org.simantics.plant3d.scenegraph.Nozzle;

public class PumpGeometryProvider
extends BuiltinGeometryProvider
implements FixedNozzleProvider {
    private double length = 0.5;
    private double width = 0.25;

    public PumpGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.width < MathTools.NEAR_ZERO || this.length < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        double h = this.width * 0.5;
        double h2 = this.width * 0.1;
        double ld2 = this.length * 0.5;
        double wd2 = this.width * 0.5;
        double r1 = this.width * 0.5;
        double r2 = r1 * 0.2;
        double r3 = r1 * 0.5;
        double l1 = this.length * 0.2;
        double l2 = this.length * 0.2;
        double l2b = l2 + this.length * 0.1;
        double l3 = this.length * 0.6;
        double[] dir = new double[]{1.0, 0.0, 0.0};
        TopoDS_Shape foundation = OccTriangulator.makeBox((double)(-ld2), (double)0.0, (double)(-wd2), (double)ld2, (double)h2, (double)wd2);
        TopoDS_Shape rotator = OccTriangulator.makeCylinder((double[])new double[]{-ld2, h + h2, 0.0}, (double[])dir, (double)r1, (double)l1);
        TopoDS_Shape axis = OccTriangulator.makeCylinder((double[])new double[]{-ld2 + l1, h + h2, 0.0}, (double[])dir, (double)r2, (double)l2b);
        TopoDS_Shape motor = OccTriangulator.makeCylinder((double[])new double[]{-ld2 + l1 + l2, h + h2, 0.0}, (double[])dir, (double)r3, (double)l3);
        TopoDS_Shape motorBox = OccTriangulator.makeBox((double)(-ld2 + l1 + l2), (double)h2, (double)(-r3), (double)ld2, (double)(h2 + h - r3), (double)r3);
        TopoDS_Shape shape = OccTriangulator.makeCompound((TopoDS_Shape[])new TopoDS_Shape[]{foundation, rotator, axis, motor, motorBox});
        foundation.delete();
        rotator.delete();
        axis.delete();
        motor.delete();
        motorBox.delete();
        return Collections.singletonList(shape);
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("length")) {
            this.length = (Double)props.get("length");
        }
        if (props.containsKey("width")) {
            this.width = (Double)props.get("width");
        }
    }

    @Override
    public int numberOfNozzles() {
        return 2;
    }

    @Override
    public void updateNozzlePosition(int index, Nozzle nozzle) {
        Double fl = (Double)nozzle.getParameterMap().get("length");
        if (fl == null) {
            fl = 0.0;
        }
        if (index == 0) {
            nozzle.setPosition(new Vector3d(-this.length * 0.5 - fl, this.width * 0.6, 0.0));
            nozzle.setOrientation(MathTools.getQuat((AxisAngle4d)new AxisAngle4d(0.0, 1.0, 0.0, Math.PI)));
        } else if (index == 1) {
            nozzle.setPosition(new Vector3d(-this.length * 0.4, this.width * 1.1 + fl, 0.0));
            nozzle.setOrientation(MathTools.getQuat((AxisAngle4d)new AxisAngle4d(0.0, 0.0, 1.0, 1.5707963267948966)));
        }
    }

    @Override
    public String getNozzleName(int index) {
        switch (index) {
            case 0: {
                return "Input";
            }
            case 1: {
                return "Output";
            }
        }
        return null;
    }
}

