/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.plant3d.geometry.BuiltinGeometryProvider;

public class FlatNozzleGeometryProvider
extends BuiltinGeometryProvider {
    private double radius = 0.01;

    public FlatNozzleGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.radius < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        double length = 0.001;
        TopoDS_Shape shape = OccTriangulator.makeCylinder((double[])new double[]{0.0, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)this.radius, (double)length);
        return Collections.singletonList(shape);
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
    }
}

