/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.editor;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.simantics.db.Resource;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.ui.ScenegraphOutlinePage;
import org.simantics.g3d.vtk.common.NodeSelectionProvider2;
import org.simantics.g3d.vtk.common.VTKContentOutlinePage;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;

public class P3DContentOutlinePage
extends VTKContentOutlinePage<Resource, INode> {
    private static final boolean DEBUG = false;
    protected Menu contextMenu;
    private LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());
    private Image nozzleImage;
    private Image pipeImage;
    private Image tankImage;
    private Image elbowImage;
    private Image componentImage;
    private Image nozzleErrorImage;
    private Image pipeErrorImage;
    private Image tankErrorImage;
    private Image elbowErrorImage;
    private Image componentErrorImage;

    public P3DContentOutlinePage(ParentNode<? extends INode> rootNode, NodeSelectionProvider2<Resource, INode> provider) {
        super(rootNode, provider);
        ImageDescriptor nozzleDesc = Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/Nozzle.png");
        ImageDescriptor straightDesc = Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/Straight.png");
        ImageDescriptor tankDesc = Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/tank.png");
        ImageDescriptor elbowDesc = Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/Elbow.png");
        ImageDescriptor componentDesc = Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/Component.png");
        this.nozzleImage = this.manager.createImage(nozzleDesc);
        this.pipeImage = this.manager.createImage(straightDesc);
        this.tankImage = this.manager.createImage(tankDesc);
        this.elbowImage = this.manager.createImage(elbowDesc);
        this.componentImage = this.manager.createImage(componentDesc);
        ImageDescriptor error = Activator.imageDescriptorFromPlugin((String)"org.simantics.issues.ui", (String)"icons/warning_decoration.png");
        this.nozzleErrorImage = this.manager.createImage((ImageDescriptor)new DecorationOverlayIcon(nozzleDesc, error, 3));
        this.pipeErrorImage = this.manager.createImage((ImageDescriptor)new DecorationOverlayIcon(straightDesc, error, 3));
        this.tankErrorImage = this.manager.createImage((ImageDescriptor)new DecorationOverlayIcon(tankDesc, error, 3));
        this.elbowErrorImage = this.manager.createImage((ImageDescriptor)new DecorationOverlayIcon(elbowDesc, error, 3));
        this.componentErrorImage = this.manager.createImage((ImageDescriptor)new DecorationOverlayIcon(componentDesc, error, 3));
    }

    protected void createProviders(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ScenegraphOutlinePage.ScenegraphContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof P3DRootNode) {
                    return ((P3DRootNode)((Object)parentElement)).getChild().toArray();
                }
                if (parentElement instanceof PipeRun) {
                    return ((PipeRun)parentElement).getSortedChild().toArray();
                }
                return super.getChildren(parentElement);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof P3DRootNode) {
                    return ((P3DRootNode)((Object)element)).getChild().size() > 0;
                }
                if (element instanceof PipeRun) {
                    return ((PipeRun)element).getChild().size() > 0;
                }
                return super.hasChildren(element);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new P3DLabelProvider());
        this.hookContextMenu(viewer);
        viewer.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                P3DContentOutlinePage.this.contextMenu.setLocation(e.x, e.y);
                P3DContentOutlinePage.this.contextMenu.setVisible(true);
            }
        });
    }

    public void propertyChanged(INode node, String id) {
        if (node instanceof PipelineComponent && ("http://www.simantics.org/Plant3D-0.1/HasNext".equals(id) || "http://www.simantics.org/Plant3D-0.1/HasPrevious".equals(id))) {
            this.refershViewer((INode)node.getParent());
            return;
        }
        super.propertyChanged(node, id);
    }

    public void dispose() {
        this.manager.dispose();
        super.dispose();
    }

    protected void hookContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                P3DContentOutlinePage.this.createContextMenu(manager);
            }
        });
        this.contextMenu = menuMgr.createContextMenu((Control)viewer.getTree());
    }

    protected void createContextMenu(IMenuManager manager) {
    }

    private class P3DLabelProvider
    extends ScenegraphOutlinePage.ScenegraphLabelProvider {
        private P3DLabelProvider() {
            super((ScenegraphOutlinePage)P3DContentOutlinePage.this);
        }

        public Image getImage(Object element) {
            if (element instanceof PipelineComponent) {
                PipelineComponent comp = (PipelineComponent)element;
                if (comp instanceof TurnComponent) {
                    if (comp.getError() == null) {
                        return P3DContentOutlinePage.this.elbowImage;
                    }
                    return P3DContentOutlinePage.this.elbowErrorImage;
                }
                if (comp instanceof EndComponent) {
                    if (comp.getError() == null) {
                        return P3DContentOutlinePage.this.componentImage;
                    }
                    return P3DContentOutlinePage.this.componentErrorImage;
                }
                if (comp instanceof Nozzle) {
                    if (comp.getError() == null) {
                        return P3DContentOutlinePage.this.nozzleImage;
                    }
                    return P3DContentOutlinePage.this.nozzleErrorImage;
                }
                if (comp.getControlPoint().isFixed()) {
                    if (comp.getError() == null) {
                        return P3DContentOutlinePage.this.componentImage;
                    }
                    return P3DContentOutlinePage.this.componentErrorImage;
                }
                if (comp.getError() == null) {
                    return P3DContentOutlinePage.this.pipeImage;
                }
                return P3DContentOutlinePage.this.pipeErrorImage;
            }
            if (element instanceof Equipment) {
                return P3DContentOutlinePage.this.tankImage;
            }
            if (element instanceof PipeRun) {
                return P3DContentOutlinePage.this.pipeImage;
            }
            return null;
        }
    }
}

