/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.impl;

import gnu.trove.map.hash.THashMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.IMappingListener;
import org.simantics.objmap.graph.impl.Link;
import org.simantics.objmap.graph.impl.RangeUpdateRequest;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapping<Domain, Range>
implements IMapping<Domain, Range> {
    static final Logger LOGGER = LoggerFactory.getLogger(Mapping.class);
    IMappingSchema<Domain, Range> schema;
    THashMap<Domain, Link<Domain, Range>> domain = new THashMap();
    THashMap<Range, Link<Domain, Range>> range = new THashMap();
    ArrayList<IMappingListener> listeners = new ArrayList();
    ArrayList<Link<Domain, Range>> modifiedDomainLinks = new ArrayList();
    ArrayList<Link<Domain, Range>> modifiedRangeLinks = new ArrayList();
    boolean disposed = false;
    boolean listensDomain;
    Set<Domain> domainSet = new AbstractSet<Domain>(){

        @Override
        public boolean add(Domain e) {
            if (Mapping.this.domain.containsKey(e)) {
                return false;
            }
            Link link = new Link(null, e, null);
            Mapping.this.domain.put(e, link);
            Mapping.this.modifiedDomainLinks.add(link);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return Mapping.this.domain.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            Link link = (Link)Mapping.this.domain.remove(o);
            if (link == null) {
                return false;
            }
            Mapping.this.removeLink(link);
            if (link.rangeElement != null) {
                Mapping.this.range.remove(link.rangeElement);
            }
            return true;
        }

        @Override
        public Iterator<Domain> iterator() {
            return Mapping.this.domain.keySet().iterator();
        }

        @Override
        public int size() {
            return Mapping.this.domain.size();
        }
    };
    Set<Range> rangeSet = new AbstractSet<Range>(){

        @Override
        public boolean add(Range e) {
            if (Mapping.this.range.containsKey(e)) {
                return false;
            }
            Link link = new Link(null, null, e);
            Mapping.this.range.put(e, link);
            Mapping.this.modifiedRangeLinks.add(link);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return Mapping.this.range.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            Link link = (Link)Mapping.this.range.remove(o);
            if (link == null) {
                return false;
            }
            Mapping.this.removeLink(link);
            if (link.domainElement != null) {
                Mapping.this.domain.remove(link.domainElement);
            }
            return true;
        }

        @Override
        public Iterator<Range> iterator() {
            return Mapping.this.range.keySet().iterator();
        }

        @Override
        public int size() {
            return Mapping.this.range.size();
        }
    };

    public Mapping(IMappingSchema<Domain, Range> schema, boolean listensDomain) {
        this.schema = schema;
        this.listensDomain = listensDomain;
    }

    private void removeLink(Link<Domain, Range> link) {
        if (link.domainModified) {
            this.modifiedDomainLinks.remove(link);
        }
        if (link.rangeModified) {
            this.modifiedRangeLinks.remove(link);
        }
        link.removed = true;
    }

    private void createDomain(WriteGraph g, Link<Domain, Range> link) throws MappingException {
        LOGGER.trace("        createDomain for " + String.valueOf(link.rangeElement));
        ILinkType type = this.schema.linkTypeOfRangeElement(link.rangeElement);
        Object domainElement = type.createDomainElement(g, link.rangeElement);
        link.type = type;
        link.domainElement = domainElement;
        this.domain.put(domainElement, link);
        type.createDomain(g, new RangeToDomain(), domainElement, link.rangeElement);
        this.domainModified((Domain)link);
    }

    private void createRange(ReadGraph g, Link<Domain, Range> link) throws MappingException {
        ILinkType type = this.schema.linkTypeOfDomainElement(g, link.domainElement);
        Object rangeElement = type.createRangeElement(g, link.domainElement);
        link.type = type;
        link.rangeElement = rangeElement;
        this.range.put(rangeElement, link);
        type.createRange(g, new DomainToRange(), link.domainElement, rangeElement);
    }

    @Override
    public Set<Domain> getDomain() {
        return this.domainSet;
    }

    @Override
    public Set<Range> getRange() {
        return this.rangeSet;
    }

    @Override
    public synchronized Collection<Domain> updateDomain(WriteGraph g) throws MappingException {
        LOGGER.trace("Mapping.updateDomain");
        RangeToDomain map = new RangeToDomain();
        ArrayList updated = new ArrayList();
        while (!this.modifiedRangeLinks.isEmpty()) {
            LOGGER.trace("    modifiedRangeLinks.size() = " + this.modifiedRangeLinks.size());
            Link<Domain, Range> link = this.modifiedRangeLinks.remove(this.modifiedRangeLinks.size() - 1);
            link.rangeModified = false;
            if (link.type == null) {
                this.createDomain(g, link);
                continue;
            }
            if (!link.type.updateDomain(g, map, link.domainElement, link.rangeElement)) continue;
            updated.add(link.domainElement);
        }
        if (this.listensDomain) {
            this.updateRange((ReadGraph)g);
        }
        return updated;
    }

    @Override
    public synchronized Collection<Range> updateRange(ReadGraph g) throws MappingException {
        LOGGER.trace("Mapping.updateRange");
        DomainToRange map = new DomainToRange();
        ArrayList updated = new ArrayList();
        while (!this.modifiedDomainLinks.isEmpty()) {
            LOGGER.trace("    modifiedDomainLinks.size() = " + this.modifiedDomainLinks.size());
            Link<Domain, Range> link = this.modifiedDomainLinks.remove(this.modifiedDomainLinks.size() - 1);
            link.domainModified = false;
            if (link.type == null) {
                this.createRange(g, link);
            }
            if (this.listensDomain) {
                boolean changes;
                RangeUpdateRequest<Domain, Range> request = new RangeUpdateRequest<Domain, Range>(link, map, this);
                try {
                    changes = (Integer)g.syncRequest(request, request) > 0;
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
                if (!changes) continue;
                updated.add(link.rangeElement);
                continue;
            }
            if (!link.type.updateRange(g, map, link.domainElement, link.rangeElement)) continue;
            updated.add(link.rangeElement);
        }
        return updated;
    }

    @Override
    public Range get(Domain domainElement) {
        Link link = (Link)this.domain.get(domainElement);
        if (link == null) {
            return null;
        }
        return link.rangeElement;
    }

    @Override
    public Domain inverseGet(Range rangeElement) {
        Link link = (Link)this.range.get(rangeElement);
        if (link == null) {
            return null;
        }
        return link.domainElement;
    }

    @Override
    public Domain inverseMap(WriteGraph g, Range rangeElement) throws MappingException {
        this.getRange().add(rangeElement);
        this.updateDomain(g);
        return this.inverseGet(rangeElement);
    }

    @Override
    public Range map(ReadGraph g, Domain domainElement) throws MappingException {
        this.getDomain().add(domainElement);
        this.updateRange(g);
        return this.get(domainElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void domainModified(Link<Domain, Range> link) {
        if (!link.domainModified) {
            ArrayList<Link<Domain, Range>> arrayList = this.modifiedDomainLinks;
            synchronized (arrayList) {
                LOGGER.trace("        domainModified for " + String.valueOf(link.rangeElement));
                link.domainModified = true;
                this.modifiedDomainLinks.add(link);
                if (this.modifiedDomainLinks.size() == 1) {
                    for (IMappingListener listener : this.listeners) {
                        listener.domainModified();
                    }
                }
            }
        }
    }

    @Override
    public void domainModified(Domain domainElement) {
        Link link = (Link)this.domain.get(domainElement);
        if (link != null) {
            this.domainModified((Domain)link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void rangeModified(Link<Domain, Range> link) {
        if (!link.rangeModified) {
            ArrayList<Link<Domain, Range>> arrayList = this.modifiedRangeLinks;
            synchronized (arrayList) {
                link.rangeModified = true;
                this.modifiedRangeLinks.add(link);
                if (this.modifiedRangeLinks.size() == 1) {
                    for (IMappingListener listener : this.listeners) {
                        listener.rangeModified();
                    }
                }
            }
        }
    }

    @Override
    public void rangeModified(Range rangeElement) {
        Link link = (Link)this.range.get(rangeElement);
        if (link != null) {
            this.rangeModified((Range)link);
        }
    }

    @Override
    public boolean isDomainModified() {
        return !this.modifiedDomainLinks.isEmpty();
    }

    @Override
    public boolean isRangeModified() {
        return !this.modifiedRangeLinks.isEmpty();
    }

    @Override
    public Collection<Domain> getDomainModified() {
        ArrayList list = new ArrayList(this.modifiedDomainLinks.size());
        for (Link<Domain, Range> link : this.modifiedDomainLinks) {
            list.add(link.domainElement);
        }
        return list;
    }

    @Override
    public Collection<Range> getRangeModified() {
        ArrayList list = new ArrayList(this.modifiedRangeLinks.size());
        for (Link<Domain, Range> link : this.modifiedRangeLinks) {
            list.add(link.rangeElement);
        }
        return list;
    }

    @Override
    public void addMappingListener(IMappingListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMappingListener(IMappingListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<Domain> getConflictingDomainElements() {
        ArrayList result = new ArrayList();
        if (this.modifiedDomainLinks.size() < this.modifiedRangeLinks.size()) {
            for (Link<Domain, Range> link : this.modifiedDomainLinks) {
                if (!link.rangeModified) continue;
                result.add(link.domainElement);
            }
        } else {
            for (Link<Domain, Range> link : this.modifiedRangeLinks) {
                if (!link.domainModified) continue;
                result.add(link.domainElement);
            }
        }
        return result;
    }

    @Override
    public Collection<Range> getConflictingRangeElements() {
        ArrayList result = new ArrayList();
        if (this.modifiedDomainLinks.size() < this.modifiedRangeLinks.size()) {
            for (Link<Domain, Range> link : this.modifiedDomainLinks) {
                if (!link.rangeModified) continue;
                result.add(link.rangeElement);
            }
        } else {
            for (Link<Domain, Range> link : this.modifiedRangeLinks) {
                if (!link.domainModified) continue;
                result.add(link.rangeElement);
            }
        }
        return result;
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    class DomainToRange
    implements IForwardMapping<Domain, Range> {
        @Override
        public Range get(Domain element) {
            Link link = (Link)Mapping.this.domain.get(element);
            if (link != null) {
                return link.rangeElement;
            }
            return null;
        }

        @Override
        public Range map(ReadGraph graph, Domain element) throws MappingException {
            Link link = (Link)Mapping.this.domain.get(element);
            if (link == null) {
                link = new Link(null, element, null);
                link.domainModified = true;
                Mapping.this.modifiedDomainLinks.add(link);
                Mapping.this.domain.put(element, link);
                Mapping.this.createRange(graph, link);
            } else if (link.type == null) {
                Mapping.this.createRange(graph, link);
            }
            return link.rangeElement;
        }

        @Override
        public Set<Domain> getDomain() {
            return Mapping.this.domain.keySet();
        }
    }

    class RangeToDomain
    extends DomainToRange
    implements IBackwardMapping<Domain, Range> {
        @Override
        public Domain inverseGet(Range element) {
            Link link = (Link)Mapping.this.range.get(element);
            if (link != null) {
                return link.domainElement;
            }
            return null;
        }

        @Override
        public Domain inverseMap(WriteGraph graph, Range element) throws MappingException {
            Link link = (Link)Mapping.this.range.get(element);
            if (link == null) {
                link = new Link(null, null, element);
                link.rangeModified = true;
                Mapping.this.modifiedRangeLinks.add(link);
                Mapping.this.range.put(element, link);
                Mapping.this.createDomain(graph, link);
            } else if (link.type == null) {
                Mapping.this.createDomain(graph, link);
            }
            return link.domainElement;
        }

        @Override
        public Set<Range> getRange() {
            return Mapping.this.range.keySet();
        }
    }
}

