/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.annotations.factories;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.StringType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTypeUtils.class);

    public static Resource dataTypeOfClass(ReadGraph g, Class<?> clazz) {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return b.Double;
        }
        if (clazz.equals(String.class)) {
            return b.String;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return b.Integer;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return b.Float;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return b.Boolean;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return b.Long;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return b.Byte;
        }
        if (clazz.equals(double[].class)) {
            return b.DoubleArray;
        }
        if (clazz.equals(int[].class)) {
            return b.IntegerArray;
        }
        if (clazz.equals(byte[].class)) {
            return b.ByteArray;
        }
        if (clazz.equals(float[].class)) {
            return b.FloatArray;
        }
        if (clazz.equals(boolean[].class)) {
            return b.BooleanArray;
        }
        if (clazz.equals(String[].class)) {
            return b.StringArray;
        }
        if (clazz.equals(long[].class)) {
            return b.LongArray;
        }
        try {
            Datatype type = Datatypes.getDatatype(clazz);
            Resource result = DataTypeUtils.dataTypeOfDatatype(g, type);
            if (result != null) {
                return result;
            }
        }
        catch (DatatypeConstructionException datatypeConstructionException) {}
        LOGGER.error("No literal type found for class {}", clazz);
        return null;
    }

    public static Resource dataTypeOfDatatype(ReadGraph g, Datatype type) {
        if (type instanceof OptionalType) {
            return DataTypeUtils.dataTypeOfDatatype(g, ((OptionalType)type).getComponentType());
        }
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        if (type instanceof DoubleType) {
            return b.Double;
        }
        if (type instanceof StringType) {
            return b.String;
        }
        if (type instanceof IntegerType) {
            return b.Integer;
        }
        if (type instanceof FloatType) {
            return b.Float;
        }
        if (type instanceof BooleanType) {
            return b.Boolean;
        }
        if (type instanceof LongType) {
            return b.Long;
        }
        if (type instanceof ByteType) {
            return b.Byte;
        }
        if (type instanceof ArrayType) {
            if ((type = ((ArrayType)type).componentType()) instanceof DoubleType) {
                return b.DoubleArray;
            }
            if (type instanceof IntegerType) {
                return b.IntegerArray;
            }
            if (type instanceof ByteType) {
                return b.ByteArray;
            }
            if (type instanceof FloatType) {
                return b.FloatArray;
            }
            if (type instanceof BooleanType) {
                return b.BooleanArray;
            }
            if (type instanceof StringType) {
                return b.StringArray;
            }
            if (type instanceof LongType) {
                return b.LongArray;
            }
        }
        LOGGER.error("No literal type found for data type {}", (Object)type);
        return null;
    }
}

