/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.configuration;

import java.util.Collections;
import java.util.List;

import org.simantics.databoard.util.Bean;

/**
 * 
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class TrendSpec extends Bean {

	public static final TrendSpec EMPTY;
	
	public String name = "Title Here";

	public YAxisMode axisMode;
	
	public int singleAxisShowLegendsMaxLegends = 10;
	
	public ViewProfile viewProfile;

	/**
	 * Set externally to indicate that currently an experiment is running which
	 * means {@link ViewProfile#trackExperimentTime} setting should be enforced.
	 */
	public transient boolean experimentIsRunning;

	/** Trend items */
	public List<TrendItem> items;

	static {
		 EMPTY = new TrendSpec();
		 EMPTY.init();
	}
	
	/**
	 * Sort items by index, label1, label2
	 */
	public void sortItems()
	{
		Collections.sort(items);
	}
	
}
