/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scl.osgi.issues;

import java.util.Collections;
import java.util.List;

import org.simantics.scl.osgi.issues.SCLIssueProviderFactory.SCLIssueProvider;

/**
 * A dummy {@link SCLIssueProvider} implementation that returns no issues.
 * 
 * @author Tuukka Lehtonen
 * @since 1.51.0
 */
public class NoSCLIssueProvider implements SCLIssueProvider {

	public static final NoSCLIssueProvider INSTANCE = new NoSCLIssueProvider();

	@Override
	public void listenIssues(Runnable callback) {
	}

	@Override
	public List<SCLIssuesTableEntry> getIssues() {
		return Collections.emptyList();
	}

	@Override
	public void dispose() {
	}

}