/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.interpreted;

import org.simantics.scl.compiler.internal.interpreted.IExpression;

public class ILet
implements IExpression {
    private final int variableId;
    private final IExpression value;
    private final IExpression in;

    public ILet(int variableId, IExpression value, IExpression in) {
        this.variableId = variableId;
        this.value = value;
        this.in = in;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        variableBindings[this.variableId] = this.value.execute(variableBindings);
        try {
            Object object = this.in.execute(variableBindings);
            return object;
        }
        finally {
            variableBindings[this.variableId] = null;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(let v");
        b.append(this.variableId);
        b.append(" = ");
        b.append(this.value);
        b.append(" in ");
        b.append(this.in);
        b.append(')');
        return b.toString();
    }
}

