/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints2;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.elaboration.constraints2.ConstraintHandle;
import org.simantics.scl.compiler.internal.elaboration.constraints2.ConstraintStore;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class ConstraintSolver {
    final Environment environment;
    private final THashMap<TCon, ConstraintStore> constraintStores = new THashMap();

    public ConstraintSolver(Environment environment) {
        this.environment = environment;
    }

    private ConstraintStore getConstraintStore(TCon typeClass) {
        ConstraintStore store = (ConstraintStore)this.constraintStores.get((Object)typeClass);
        if (store == null) {
            store = new ConstraintStore(this, typeClass);
            this.constraintStores.put((Object)typeClass, (Object)store);
        }
        return store;
    }

    public ConstraintHandle addDemand(TPred pred, long location) {
        return this.getConstraintStore(pred.typeClass).addConstraint(pred, location);
    }

    public void print() {
        final TypeUnparsingContext tuc = new TypeUnparsingContext();
        this.constraintStores.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<TCon, ConstraintStore>(){

            public boolean execute(TCon pred, ConstraintStore store) {
                store.print(tuc);
                return true;
            }
        });
    }
}

