/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.visitors;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.relations.SpecialCHRRelation;
import org.simantics.scl.compiler.elaboration.expressions.Assignment;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.ECHRSelect;
import org.simantics.scl.compiler.elaboration.expressions.ELet;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.ESelect;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EViewPattern;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.list.ListAssignment;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGenerator;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionVisitor;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.types.util.Typed;

public class CollectFreeVariablesVisitor
extends StandardExpressionVisitor {
    private THashSet<Variable> freeVariables = new THashSet();
    private StandardExpressionVisitor collectBoundVariablesVisitor = new StandardExpressionVisitor(){

        @Override
        public void visit(EVariable expression) {
            if (expression.variable != null) {
                CollectFreeVariablesVisitor.this.freeVariables.remove((Object)expression.variable);
            }
        }

        @Override
        public void visit(EAsPattern expression) {
            CollectFreeVariablesVisitor.this.freeVariables.remove((Object)expression.var);
            expression.pattern.accept(this);
        }

        @Override
        public void visit(EViewPattern expression) {
            expression.expression.accept(CollectFreeVariablesVisitor.this);
            expression.pattern.accept(this);
        }
    };

    @Override
    public void visit(EVariable expression) {
        if (expression.variable != null) {
            this.freeVariables.add((Object)expression.variable);
        }
    }

    @Override
    public void visit(EBind expression) {
        if (expression.monadEvidence != null) {
            this.visit(expression.monadEvidence);
        }
        expression.in.accept(this);
        expression.value.accept(this);
        expression.pattern.accept(this.collectBoundVariablesVisitor);
    }

    @Override
    public void visit(Assignment assignment) {
        assignment.value.accept(this);
        assignment.pattern.accept(this.collectBoundVariablesVisitor);
    }

    @Override
    public void visit(ELet expression) {
        expression.in.accept(this);
        int i = expression.assignments.length - 1;
        while (i >= 0) {
            this.visit(expression.assignments[i]);
            --i;
        }
    }

    @Override
    public void visit(Case case_) {
        case_.value.accept(this);
        Expression[] expressionArray = case_.patterns;
        int n = case_.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Expression pattern = expressionArray[n2];
            pattern.accept(this.collectBoundVariablesVisitor);
            ++n2;
        }
    }

    @Override
    public void visit(ESimpleLambda expression) {
        expression.value.accept(this);
        this.freeVariables.remove((Object)expression.parameter);
    }

    @Override
    public void visit(ESimpleLet expression) {
        expression.in.accept(this);
        expression.value.accept(this);
        this.freeVariables.remove((Object)expression.variable);
    }

    @Override
    public void visit(ECHRSelect expression) {
        expression.expression.accept(this);
        this.visit(expression.query);
        Variable[] variableArray = expression.existentialVariables;
        int n = expression.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.freeVariables.remove((Object)variable);
            ++n2;
        }
    }

    @Override
    public void visit(ESelect expression) {
        expression.expression.accept(this);
        expression.query.accept(this);
        Variable[] variableArray = expression.variables;
        int n = expression.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.freeVariables.remove((Object)variable);
            ++n2;
        }
    }

    @Override
    public void visit(EWhen expression) {
        expression.action.accept(this);
        expression.query.accept(this);
        Variable[] variableArray = expression.variables;
        int n = expression.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.freeVariables.remove((Object)variable);
            ++n2;
        }
    }

    @Override
    public void visit(ERuleset.DatalogRule rule) {
        Typed[] typedArray = rule.headParameters;
        int n = rule.headParameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = typedArray[n2];
            parameter.accept(this);
            ++n2;
        }
        rule.body.accept(this);
        typedArray = rule.variables;
        n = rule.variables.length;
        n2 = 0;
        while (n2 < n) {
            Typed variable = typedArray[n2];
            this.freeVariables.remove((Object)variable);
            ++n2;
        }
    }

    @Override
    public void visit(ListGenerator qualifier) {
        qualifier.pattern.accept(this.collectBoundVariablesVisitor);
        qualifier.value.accept(this);
    }

    @Override
    public void visit(ListAssignment qualifier) {
        qualifier.pattern.accept(this.collectBoundVariablesVisitor);
        qualifier.value.accept(this);
    }

    @Override
    public void visit(CHRLiteral literal) {
        if (literal.relation == SpecialCHRRelation.ASSIGN) {
            literal.parameters[0].accept(this.collectBoundVariablesVisitor);
            literal.parameters[1].accept(this);
        } else {
            Expression parameter;
            Expression[] expressionArray = literal.parameters;
            int n = literal.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                parameter = expressionArray[n2];
                parameter.accept(this);
                ++n2;
            }
            if (literal.typeConstraintEvidenceParameters != null) {
                expressionArray = literal.typeConstraintEvidenceParameters;
                n = literal.typeConstraintEvidenceParameters.length;
                n2 = 0;
                while (n2 < n) {
                    parameter = expressionArray[n2];
                    parameter.accept(this);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void visit(CHRQuery query) {
        int i = query.literals.length - 1;
        while (i >= 0) {
            this.visit(query.literals[i]);
            --i;
        }
    }

    @Override
    public void visit(CHRRule rule) {
        super.visit(rule);
        Variable[] variableArray = rule.existentialVariables;
        int n = rule.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.freeVariables.remove((Object)variable);
            ++n2;
        }
    }

    @Override
    public void visit(QExists query) {
        query.query.accept(this);
        Variable[] variableArray = query.variables;
        int n = query.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.freeVariables.remove((Object)variable);
            ++n2;
        }
    }

    @Override
    public void visit(EAsPattern expression) {
        if (expression.var != null) {
            this.freeVariables.add((Object)expression.var);
        }
        expression.pattern.accept(this);
    }

    public THashSet<Variable> getFreeVariables() {
        return this.freeVariables;
    }
}

