/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui.internal;

import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.debug.ui.GraphDebugger;
import org.simantics.debug.ui.ResourceSearch;
import org.simantics.debug.ui.SearchResourceDialog;
import org.simantics.debug.ui.internal.Messages;
import org.simantics.layer0.Layer0;
import org.simantics.utils.Container;
import org.simantics.utils.DataContainer;

public class DebugUtils {
    public static String getSafeLabel(ReadGraph graph, Resource r) throws DatabaseException {
        String label;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Object name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
        Statement stm = graph.getPossibleStatement(r, l0.HasLabel);
        if (stm != null && !(label = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)r)).isEmpty() && !stm.isAsserted(r)) {
            name = (String)name + " (" + label + ")";
        }
        return name;
    }

    public static String getSafeURI(ReadGraph graph, Resource r) throws DatabaseException {
        String uri = graph.getPossibleURI(r);
        if (uri != null) {
            return uri;
        }
        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true);
        return name;
    }

    public static String getPossibleRootRelativePath(ReadGraph graph, Resource r) throws DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
        String uri = graph.getPossibleURI(r);
        if (indexRoot != null && uri != null) {
            String rootParentUri;
            Resource indexRootParent;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Set types = graph.getTypes(indexRoot);
            if (!types.contains(L0.Ontology) && (indexRootParent = graph.getPossibleObject(indexRoot, L0.PartOf)) != null && (rootParentUri = graph.getPossibleURI(indexRootParent)) != null) {
                return URIStringUtils.unescape((String)uri.substring(rootParentUri.length() + 1));
            }
        }
        return uri;
    }

    public static void addResource(Session s, GraphDebugger debugger) throws DatabaseException {
        Shell shell = debugger.getShell();
        SearchResourceDialog rld = new SearchResourceDialog(s, false, shell, Messages.DebugUtils_CreateNewResource);
        rld.setBlockOnOpen(true);
        rld.setResourceFilter(ResourceSearch.FILTER_TYPES);
        Resource subject_ = debugger.getDebuggerLocation();
        if (subject_ == null) {
            rld.setBlockOnOpen(true);
            rld.setMessage(Messages.DebugUtils_SelectSubject);
            rld.setInitialSelections(new Object[0]);
            if (rld.open() != 0) {
                return;
            }
            if (rld.getResult() == null) {
                return;
            }
            subject_ = (Resource)((Container)rld.getResult()[0]).get();
        }
        final Resource subject = subject_;
        rld.setBlockOnOpen(true);
        rld.setResourceFilter(ResourceSearch.FILTER_RELATIONS);
        rld.setMessage(Messages.DebugUtils_SelectPredicate);
        rld.setInitialSelections(new Object[0]);
        if (rld.open() != 0) {
            return;
        }
        if (rld.getResult() == null) {
            return;
        }
        final Resource predicate = (Resource)((Container)rld.getResult()[0]).get();
        rld.setMessage(Messages.DebugUtils_SelectTypeOfNewObjectInstance);
        rld.setResourceFilter(ResourceSearch.FILTER_TYPES);
        rld.setInitialSelections(new Object[0]);
        if (rld.open() != 0) {
            return;
        }
        if (rld.getResult() == null) {
            return;
        }
        final Resource type = (Resource)((Container)rld.getResult()[0]).get();
        final DataContainer result = new DataContainer();
        s.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                Resource r = g.newResource();
                g.claim(r, Layer0.getInstance((ReadGraph)g).InstanceOf, type);
                g.claim(subject, predicate, r);
                result.set((Object)r);
            }
        });
        if (result.get() != null) {
            debugger.changeLocation((Resource)result.get());
        }
    }

    public static void addStatement(Session s, GraphDebugger debugger) throws DatabaseException {
        Shell shell = debugger.getShell();
        SearchResourceDialog rld = new SearchResourceDialog(s, false, shell, Messages.DebugUtils_CreateNewStatement);
        Resource subject_ = debugger.getDebuggerLocation();
        if (subject_ == null) {
            rld.setBlockOnOpen(true);
            rld.setMessage(Messages.DebugUtils_SelectSubject);
            rld.setInitialSelections(new Object[0]);
            if (rld.open() != 0) {
                return;
            }
            if (rld.getResult() == null) {
                return;
            }
            subject_ = (Resource)((Container)rld.getResult()[0]).get();
        }
        final Resource subject = subject_;
        rld.setBlockOnOpen(true);
        rld.setResourceFilter(ResourceSearch.FILTER_RELATIONS);
        rld.setMessage(Messages.DebugUtils_SelectPredicate);
        rld.setInitialSelections(new Object[0]);
        if (rld.open() != 0) {
            return;
        }
        if (rld.getResult() == null) {
            return;
        }
        final Resource predicate = (Resource)((Container)rld.getResult()[0]).get();
        rld.setResourceFilter(ResourceSearch.FILTER_ALL);
        rld.setMessage(Messages.DebugUtils_SelectObject);
        rld.setInitialSelections(new Object[0]);
        if (rld.open() != 0) {
            return;
        }
        if (rld.getResult() == null) {
            return;
        }
        final Resource object = (Resource)((Container)rld.getResult()[0]).get();
        s.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                g.claim(subject, predicate, object);
            }
        });
    }

    public static void find(Session s, GraphDebugger debugger) {
        Shell shell = debugger.getShell();
        SearchResourceDialog rld = new SearchResourceDialog(s, false, shell, Messages.DebugUtils_SelectResourceToView);
        rld.setBlockOnOpen(true);
        if (rld.open() != 0) {
            return;
        }
        if (rld.getResult() == null) {
            return;
        }
        Object[] objectArray = rld.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Container rc = (Container)o;
            debugger.changeLocation((Resource)rc.get());
            ++n2;
        }
    }
}

