/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.simantics.db.Session;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.processor.MergingGraphRequestProcessor;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.GraphChangeListenerSupport;


public class SessionDebugger extends Composite {
    
    /**
     * The Session used to access the graph. Received from outside of this
     * class and therefore it is not disposed here, just used.
     */
    private Session                        session;
    
    private MergingGraphRequestProcessor              updater;
    
    private TreeViewer                      clusters;
    
    private ChangeListener changeListener = new ChangeListener() {
        public void graphChanged(ChangeEvent e) {
            // This makes sure that the transaction for updating this
            // GraphDebugger get executed in a serialized fashion.
            updater.asyncRequest(new ReadRequest() {
                @Override
                public void run(ReadGraph g) throws DatabaseException {
                    updateContent();
                }
            });
        }
    };

    /**
     * @param parent
     * @param style
     * @param session
     * @param resource the initial resource to debug or <code>null</code> for
     *        initially blank UI.
     */
    public SessionDebugger(Composite parent, int style, final Session session) {
        super(parent, style);
        Assert.isNotNull(session, "session is null"); //$NON-NLS-1$
        this.session = session;
        updater = new MergingGraphRequestProcessor(session, 100);
        
        addDisposeListener(new DisposeListener() {
			@Override
			public void widgetDisposed(DisposeEvent e) {
		        GraphChangeListenerSupport support = session.getService(GraphChangeListenerSupport.class);
		        support.removeListener(changeListener);
			}
        });
        
    }
    
    public void initializeUI() {
        
        setLayout(new GridLayout(1, false));
        setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

        createViewer(this);
        
    }

    public TreeViewer createViewer(Composite parent) {

        clusters = new TreeViewer(parent, SWT.NONE);
        clusters.getTree().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

        clusters.setContentProvider(new ITreeContentProvider() {

            @Override
            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            @Override
            public Object getParent(Object element) {
                return null;
            }

            @Override
            public boolean hasChildren(Object element) {
                return false;
            }

            @Override
            public Object[] getElements(Object inputElement) {
//                return session.getDebug().getActiveClusters();
                return new Object[0];
            }

            @Override
            public void dispose() {
            }

            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
            
        });
        
        // Schedule a request that updates the browser content.
        refreshClusters();
        GraphChangeListenerSupport support = session.getService(GraphChangeListenerSupport.class);
        support.addListener(changeListener);

        return clusters;
        
    }

    public void refreshClusters() {
        
        // Schedule a request that updates the browser content.
        updater.asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph g) throws DatabaseException {
                updateContent();
            }
        });
        
    }
    
    public void updateContent() {

        clusters.getTree().getDisplay().asyncExec(new Runnable() {

            @Override
            public void run() {
                
                if(clusters.getTree().isDisposed()) return;
                clusters.setInput(new Object());
                
            }
            
        });
        
    }

}
