/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.DomainProcessor3;
import org.simantics.db.layer0.util.TGConfigurer;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.request.ReadInterface;
import org.simantics.scl.runtime.function.Function1;

public class TransferableGraphConfiguration2 {
    public final TreeMap<String, Variant> baseExtensions = new TreeMap();
    public final Resource indexRoot;
    public final Collection<SeedSpec> seeds;
    public final Map<Resource, SubgraphExtent.ExtentStatus> preStatus;
    public final boolean ignoreVirtualResources;
    public final boolean includePendingWeakReferences;
    public final boolean validate;
    public boolean values = true;
    public Collection<TGValueModifier> valueModifiers;
    public Function1<Statement, DomainProcessor3.ExclusionDecision> exclusionFunction;

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<SeedSpec> seeds, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources, boolean validate, boolean includePendingWeakReferences) {
        this.indexRoot = indexRoot;
        this.seeds = seeds;
        this.preStatus = preStatus;
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.validate = validate;
        this.valueModifiers = null;
        this.includePendingWeakReferences = includePendingWeakReferences;
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<SeedSpec> seeds, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources, boolean validate) {
        this(indexRoot, seeds, preStatus, ignoreVirtualResources, validate, false);
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<SeedSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources) {
        this(indexRoot, roots, preStatus, ignoreVirtualResources, true);
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<SeedSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus) {
        this(indexRoot, roots, preStatus, true);
    }

    public TransferableGraphConfiguration2(TransferableGraphConfiguration2 conf) throws DatabaseException {
        this(conf.indexRoot, conf.seeds, conf.preStatus, conf.ignoreVirtualResources, conf.validate, conf.includePendingWeakReferences);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(Collections.singletonList(model)).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<Resource> roots, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(roots).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources) throws DatabaseException {
        this(graph, model, ignoreVirtualResources, true);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model) throws DatabaseException {
        this(graph, model, true);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<SeedSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions) throws DatabaseException {
        this(new TGConfigurer(graph, true).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<SeedSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions, boolean ignoreVirtualResource, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResource, validate).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
    }

    public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, final Collection<NamedResource> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, TransferableGraphConfiguration2.translate(roots), Collections.emptyList(), exclusions, ignoreVirtualResource, validate);
            }
        });
    }

    public static TransferableGraphConfiguration2 createWithNames2(RequestProcessor processor, final Collection<SeedSpec> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, (Collection<SeedSpec>)roots, Collections.emptyList(), exclusions, ignoreVirtualResource, validate);
            }
        });
    }

    public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, Collection<NamedResource> roots, Collection<Resource> exclusions) throws DatabaseException {
        return TransferableGraphConfiguration2.createWithNames(processor, roots, exclusions, true, true);
    }

    public static TransferableGraphConfiguration2 createWithResources(RequestProcessor processor, final Collection<Resource> roots, final Collection<Resource> exclusions) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, Collections.emptyList(), roots, exclusions);
            }
        });
    }

    public static TransferableGraphConfiguration2 createForModel(RequestProcessor processor, Resource model) throws DatabaseException {
        return TransferableGraphConfiguration2.createWithResources(processor, Collections.singletonList(model), Collections.emptyList());
    }

    private static Collection<SeedSpec> translate(Collection<NamedResource> roots) {
        ArrayList<SeedSpec> result = new ArrayList<SeedSpec>();
        for (NamedResource nr : roots) {
            result.add(new SeedSpec(nr.getResource(), nr.getName(), SeedSpec.SeedSpecType.ROOT));
        }
        return result;
    }

    public static class SeedSpec {
        public final Resource resource;
        public final String name;
        public final SeedSpecType specType;
        public final String type;

        public SeedSpec(Resource resource, String name, SeedSpecType specType) {
            this(resource, name, specType, null);
        }

        public SeedSpec(Resource resource, String name, SeedSpecType specType, String type) {
            if (resource == null) {
                throw new NullPointerException("null resource");
            }
            if (name == null) {
                throw new NullPointerException("null name");
            }
            this.resource = resource;
            this.name = name;
            this.specType = specType;
            this.type = type;
        }

        public static SeedSpec internal(Resource resource) {
            return new SeedSpec(resource, "", SeedSpecType.ROOT);
        }

        public String toString() {
            return "SeedSpec[" + this.name + ", " + String.valueOf(this.resource) + ", " + String.valueOf((Object)this.specType) + ", " + this.type + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.specType.hashCode();
            result = 31 * result + this.resource.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SeedSpec other = (SeedSpec)obj;
            return this.specType.equals((Object)other.specType) && this.resource.equals(other.resource) && this.name.equals(other.name) && this.objectEquals(this.type, other.type);
        }

        private boolean objectEquals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        public static enum SeedSpecType {
            INTERNAL,
            ROOT,
            SPECIAL_ROOT;

        }
    }
}

