/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.bindings;

import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.LongType;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.service.SerialisationSupport;

public class ResourceBinding
extends LongBinding {
    public static final LongType RESOURCE_TYPE = new LongType();

    static {
        ResourceBinding.RESOURCE_TYPE.metadata.put("unit", "resource");
    }

    public ResourceBinding() {
        super(RESOURCE_TYPE);
    }

    private SerialisationSupport getCurrentSupport() throws BindingException {
        Session s = SimanticsInternal.peekSession();
        if (s == null) {
            throw new BindingException("Cannot instantiate Resource without an alive database Session.");
        }
        SerialisationSupport support = (SerialisationSupport)s.peekService(SerialisationSupport.class);
        if (support == null) {
            throw new BindingException("Cannot instantiate Resource without an alive database Session.");
        }
        return support;
    }

    public Object create(long value) throws BindingException {
        if (value == 0L) {
            return null;
        }
        SerialisationSupport support = this.getCurrentSupport();
        try {
            return support.getResource(value);
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public Object create(Long value) throws BindingException {
        SerialisationSupport support = this.getCurrentSupport();
        try {
            return support.getResource(value.longValue());
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public Object create(Number value) throws BindingException {
        SerialisationSupport support = this.getCurrentSupport();
        try {
            return support.getResource(value.longValue());
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public Object create(String value) throws BindingException {
        SerialisationSupport support = this.getCurrentSupport();
        try {
            return support.getResource(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new BindingException((Throwable)e);
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public Long getValue(Object o) throws BindingException {
        SerialisationSupport support = this.getCurrentSupport();
        try {
            return support.getRandomAccessId((Resource)o);
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public long getValue_(Object o) throws BindingException {
        SerialisationSupport support = this.getCurrentSupport();
        try {
            return support.getRandomAccessId((Resource)o);
        }
        catch (DatabaseException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public void setValue(Object obj, Number value) throws BindingException {
        throw new BindingException("Resource is immutable");
    }

    public void setValue(Object obj, long value) throws BindingException {
        throw new BindingException("Resource is immutable");
    }

    public boolean isImmutable() {
        return true;
    }

    public boolean isInstance(Object obj) {
        return obj instanceof Resource;
    }
}

