package org.simantics.browsing.ui.nattable;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

public class GETreeData implements ITreeData<TreeNode> {
	List<TreeNode> list;
	
	public GETreeData(List<TreeNode> list) {
		this.list = list;
	}
	
	@Override
	public List<TreeNode> getChildren(TreeNode object) {
		return (List<TreeNode>)object.getChildren();
	}
	
	@Override
	public TreeNode getDataAtIndex(int index) {
		if (index < 0 || index >= list.size() )
			return null;
		return list.get(index);
	}
	
	@Override
	public int getDepthOfData(TreeNode object) {
		int count = object.getDepth()-1; // -1 removes invisible root.
		return count;
	}
	
	@Override
	public boolean hasChildren(TreeNode object) {
		return object.getChildren().size() > 0;
	}
	
	@Override
	public int indexOf(TreeNode child) {
		return child.getListIndex();
	}
	
	@Override
	public boolean hasChildren(int index) {
		return hasChildren(list.get(index));
	}
	
	@Override
	public List<TreeNode> getChildren(int index) {
		return getChildren(list.get(index));
	}
	
	@Override
	public List<TreeNode> getChildren(TreeNode object, boolean fullDepth) {
		if (!fullDepth) {
			return getChildren(object);
		} else {
			List<TreeNode> list = new ArrayList<TreeNode>();
			_convertToList(list, object);
			return list;
		}
		
	}
	private void _convertToList(List<TreeNode> list, TreeNode task) {
		list.add(task);
		for (TreeNode t : task.getChildren()) {
			_convertToList(list, t);
		}
	}
	@Override
	public int getDepthOfData(int index) {
		return getDepthOfData(list.get(index));
	}
	
	@Override
	public boolean isValidIndex(int index) {
		if (index < 0)
			return false;
		if (index >= list.size())
			return false;
		return true;
	}
	
	@Override
	public int getElementCount() {
		return list.size();
	}
	
	public boolean isRoot(TreeNode object) {
		TreeNode parent = object.getParent();
		parent = parent.getParent();
		return (parent == null);
	}

	
}