/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.util.Arrays;

public class HierarchicalWrapper {
    private final Object[] levelObjects;

    public HierarchicalWrapper(int level) {
        this.levelObjects = new Object[level];
    }

    public HierarchicalWrapper(HierarchicalWrapper toCopy) {
        this.levelObjects = Arrays.copyOf(toCopy.levelObjects, toCopy.levelObjects.length);
    }

    public Object getObject(int level) {
        if (level >= this.levelObjects.length) {
            throw new IllegalArgumentException("Requested a deeper level than available");
        }
        return this.levelObjects[level];
    }

    public void setObject(int level, Object object) {
        if (level >= this.levelObjects.length) {
            throw new IllegalArgumentException("Level " + level + " is not supported by this instance");
        }
        this.levelObjects[level] = object;
    }

    public int getLevels() {
        return this.levelObjects.length;
    }
}

