/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.simantics.databoard.Files;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.representation.old.OldTransferableGraph1;
import org.simantics.graph.store.IdentityStore;

public class PrintReferencesTool {
    public static void main(String[] args) throws Exception {
        PrintReferencesTool.print(new File(args[0]));
    }

    public static void print(File input) throws IOException {
        OldTransferableGraph1 tg = (OldTransferableGraph1)Files.readFile(input, OldTransferableGraph1.BINDING);
        GraphRefactoringUtils.fixIncorrectRoot(tg.identities);
        IdentityStore idStore = TransferableGraphConversion.extractIdentities(tg);
        PrintReferencesTool.printExternals(idStore, idStore.getRoot(""), 0);
    }

    private static void printExternals(IdentityStore idStore, int cur, int indentation) {
        THashMap<String, IdentityStore.ConsistsOf> map = idStore.getChildMap(cur);
        if (map == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(map.keySet());
        Collections.sort(names);
        for (String name : names) {
            IdentityStore.ConsistsOf co = map.get(name);
            if (idStore.isNewResource(co.child)) continue;
            int i = 0;
            while (i < indentation) {
                System.out.print("    ");
                ++i;
            }
            System.out.println(name);
            PrintReferencesTool.printExternals(idStore, co.child, indentation + 1);
        }
    }
}

