/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.matching;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.simantics.graph.matching.GraphMatching;
import org.simantics.graph.matching.GraphMatchingStrategy;
import org.simantics.graph.matching.Stat;

public enum ComponentMatchingStrategy implements GraphMatchingStrategy
{
    INSTANCE;


    public static int[][] findComponents(int[] map, Stat[][] statements, TIntIntHashMap inverses) {
        int resourceCount = map.length;
        UnionFind uf = new UnionFind(resourceCount);
        int s = 0;
        while (s < resourceCount) {
            if (map[s] < 0) {
                Stat[] statArray = statements[s];
                int n = statArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Stat stat = statArray[n2];
                    int o = stat.o;
                    if (s < o && map[o] < 0) {
                        uf.merge(s, o);
                    }
                    ++n2;
                }
            }
            ++s;
        }
        TIntObjectHashMap<TIntArrayList> components = new TIntObjectHashMap<TIntArrayList>();
        int i = 0;
        while (i < resourceCount) {
            if (map[i] < 0) {
                int c = uf.canonical(i);
                TIntArrayList els = (TIntArrayList)components.get(c);
                if (els == null) {
                    els = new TIntArrayList(2);
                    components.put(c, els);
                }
                els.add(i);
            }
            ++i;
        }
        final int[][] result = new int[components.size()][];
        components.forEachValue(new TObjectProcedure<TIntArrayList>(){
            int i = 0;

            @Override
            public boolean execute(TIntArrayList els) {
                result[this.i++] = els.toArray();
                return true;
            }
        });
        return result;
    }

    public static Stat[][] neighbors(int[] map, Stat[][] statements) {
        int resourceCount = map.length;
        Stat[][] neighbors = new Stat[resourceCount][];
        ArrayList<Stat> stats = new ArrayList<Stat>();
        int s = 0;
        while (s < resourceCount) {
            if (map[s] >= 0) {
                neighbors[s] = Stat.NO_STATS;
            } else {
                Stat[] statArray = statements[s];
                int n = statArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Stat stat = statArray[n2];
                    int pp = map[stat.p] >= 0 ? stat.p : -1;
                    int oo = map[stat.o] >= 0 ? stat.o : -1;
                    stats.add(new Stat(pp, oo));
                    ++n2;
                }
                if (stats.isEmpty()) {
                    neighbors[s] = Stat.NO_STATS;
                } else {
                    neighbors[s] = stats.toArray(new Stat[stats.size()]);
                    stats.clear();
                }
            }
            ++s;
        }
        return neighbors;
    }

    @Override
    public void applyTo(GraphMatching matching) {
        Object component;
        System.out.println("ComponentMatchingStrategy");
        TNeighbourObjectHashMap aComponents = new TNeighbourObjectHashMap();
        Stat[][] neighbors = ComponentMatchingStrategy.neighbors(matching.aToB, matching.aGraph.statements);
        int[][] nArray = ComponentMatchingStrategy.findComponents(matching.aToB, matching.aGraph.statements, matching.aGraph.inverses);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int[] els = nArray[n2];
            component = new Component(els, neighbors);
            if (!((Component)component).isIsolated()) {
                ((Component)component).map(matching.aToB);
                ((Component)component).canonicalize(matching.aGraph.names, matching.bGraph.names);
                ArrayList<int[]> values = (ArrayList<int[]>)aComponents.get(((Component)component).neighbors);
                if (values == null) {
                    values = new ArrayList<int[]>(1);
                    aComponents.put(((Component)component).neighbors, values);
                }
                values.add(((Component)component).elements);
            }
            ++n2;
        }
        ArrayList<Component> bComponents = new ArrayList<Component>();
        Stat[][] neighbors2 = ComponentMatchingStrategy.neighbors(matching.bToA, matching.bGraph.statements);
        int[][] nArray2 = ComponentMatchingStrategy.findComponents(matching.bToA, matching.bGraph.statements, matching.bGraph.inverses);
        component = nArray2;
        int n3 = nArray2.length;
        n = 0;
        while (n < n3) {
            Object els = component[n];
            Component component2 = new Component((int[])els, neighbors2);
            if (!component2.isIsolated()) {
                component2.canonicalize(matching.bGraph.names, matching.bGraph.names);
                bComponents.add(component2);
            }
            ++n;
        }
        block2: for (Component c : bComponents) {
            ArrayList candidates = (ArrayList)aComponents.get(c.neighbors);
            if (candidates == null) continue;
            int i = 0;
            while (i < candidates.size()) {
                int[] els = (int[])candidates.get(i);
                if (els != null) {
                    matching.map(els, c.elements);
                    if (matching.checkMatch(els, c.elements)) {
                        if (candidates.size() == 1) {
                            aComponents.remove(c.neighbors);
                            continue block2;
                        }
                        int last = candidates.size() - 1;
                        int[] temp = (int[])candidates.remove(last);
                        if (i >= last) continue block2;
                        candidates.set(i, temp);
                        continue block2;
                    }
                    matching.unmap(els, c.elements);
                }
                ++i;
            }
        }
    }

    static class Component {
        int[] elements;
        Stat[][] neighbors;
        static final Comparator<PP> PP_COMPARATOR = new Comparator<PP>(){

            @Override
            public int compare(PP o1, PP o2) {
                Stat[] stats1 = o1.stats;
                int l1 = stats1.length;
                Stat[] stats2 = o2.stats;
                int l2 = stats2.length;
                if (l1 < l2) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                int i = 0;
                while (i < l1) {
                    Stat s1 = stats1[i];
                    Stat s2 = stats2[i];
                    if (s1.p < s2.p) {
                        return -1;
                    }
                    if (s1.p > s2.p) {
                        return 1;
                    }
                    if (s1.o < s2.o) {
                        return -1;
                    }
                    if (s1.o > s2.o) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
        };

        public Component(int[] elements, Stat[][] neighbors) {
            this.elements = elements;
            this.neighbors = new Stat[elements.length][];
            int i = 0;
            while (i < elements.length) {
                this.neighbors[i] = neighbors[elements[i]];
                ++i;
            }
        }

        public void map(int[] map) {
            Stat[][] statArray = this.neighbors;
            int n = this.neighbors.length;
            int n2 = 0;
            while (n2 < n) {
                Stat[] stats;
                Stat[] statArray2 = stats = statArray[n2];
                int n3 = stats.length;
                int n4 = 0;
                while (n4 < n3) {
                    Stat stat = statArray2[n4];
                    stat.map(map);
                    ++n4;
                }
                ++n2;
            }
        }

        public void canonicalize(String[] elNames, String[] statNames) {
            PP[] pps = new PP[this.elements.length];
            int i = 0;
            while (i < this.elements.length) {
                pps[i] = new PP(this.elements[i], this.neighbors[i]);
                ++i;
            }
            Arrays.sort(pps, PP_COMPARATOR);
            i = 0;
            while (i < pps.length - 1) {
                if (PP_COMPARATOR.compare(pps[i], pps[i + 1]) == 0) {
                    System.out.println("AMB " + pps.length + " " + (elNames == statNames));
                    i = 0;
                    while (i < pps.length - 1) {
                        if (PP_COMPARATOR.compare(pps[i], pps[i + 1]) == 0) {
                            System.out.print(">   ");
                        } else {
                            System.out.print("    ");
                        }
                        System.out.println(elNames[pps[i].element]);
                        Stat[] statArray = pps[i].stats;
                        int n = pps[i].stats.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Stat stat = statArray[n2];
                            System.out.println("        " + stat.toString(statNames));
                            ++n2;
                        }
                        ++i;
                    }
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.elements.length) {
                PP pp = pps[i];
                this.elements[i] = pp.element;
                this.neighbors[i] = pp.stats;
                ++i;
            }
        }

        public boolean isIsolated() {
            Stat[][] statArray = this.neighbors;
            int n = this.neighbors.length;
            int n2 = 0;
            while (n2 < n) {
                Stat[] stats = statArray[n2];
                if (stats.length > 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        static class PP {
            int element;
            Stat[] stats;

            public PP(int element, Stat[] stats) {
                this.element = element;
                Arrays.sort(stats, Stat.STAT_COMPARATOR);
                this.stats = stats;
            }
        }
    }

    static class TNeighbourObjectHashMap<T>
    extends THashMap<Stat[][], T> {
        TNeighbourObjectHashMap() {
        }

        @Override
        protected boolean equals(Object one, Object two) {
            Stat[][] o1 = (Stat[][])one;
            Stat[][] o2 = (Stat[][])two;
            if (o1.length != o2.length) {
                return false;
            }
            int i = 0;
            while (i < o1.length) {
                Stat[] ss1 = o1[i];
                Stat[] ss2 = o2[i];
                if (ss1.length != ss2.length) {
                    return false;
                }
                int j = 0;
                while (j < ss1.length) {
                    Stat s1 = ss1[j];
                    Stat s2 = ss2[j];
                    if (s1.p != s2.p || s1.o != s2.o) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }

        @Override
        protected int hash(Object obj) {
            int result = 152433;
            Stat[][] statArray = (Stat[][])obj;
            int n = statArray.length;
            int n2 = 0;
            while (n2 < n) {
                Stat[] stats;
                Stat[] statArray2 = stats = statArray[n2];
                int n3 = stats.length;
                int n4 = 0;
                while (n4 < n3) {
                    Stat stat = statArray2[n4];
                    result = (result * 31 + stat.p) * 31 + stat.o;
                    ++n4;
                }
                ++n2;
            }
            return result;
        }
    }

    static class UnionFind {
        int[] canonical;

        public UnionFind(int size) {
            this.canonical = new int[size];
            int i = 0;
            while (i < size) {
                this.canonical[i] = i;
                ++i;
            }
        }

        public int canonical(int a) {
            int c;
            int b = this.canonical[a];
            if (b != a && b != (c = this.canonical[b])) {
                this.canonical[b] = c = this.canonical(c);
                this.canonical[a] = c;
                return c;
            }
            return b;
        }

        public void merge(int a, int b) {
            a = this.canonical(a);
            this.canonical[a] = b = this.canonical(b);
        }
    }
}

