/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.binary.BinaryReadable;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.databoard.util.binary.UTF8;

public class BinaryFile
implements RandomAccessBinary,
BinaryReadable,
BinaryWriteable {
    RandomAccessFile raf;
    File file;
    byte[] buf;
    int readable_bytes_count;
    int write_buf_count;
    long buf_pos;
    long pointer;
    long virtualLength;
    long diskLength;
    private static final int bufferSize = 32768;

    public BinaryFile(RandomAccessFile file) throws IOException {
        this.raf = file;
        this.virtualLength = this.diskLength = this.raf.length();
        this.pointer = 0L;
        this.buf = new byte[4096];
    }

    public BinaryFile(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.virtualLength = this.diskLength = this.raf.length();
        this.file = file;
        this.pointer = 0L;
        this.buf = new byte[4096];
    }

    public BinaryFile(File file, String mode) throws IOException {
        this.raf = new RandomAccessFile(file, mode);
        this.virtualLength = this.diskLength = this.raf.length();
        this.file = file;
        this.pointer = 0L;
        this.buf = new byte[4096];
    }

    public BinaryFile(RandomAccessFile file, int bufSize) throws IOException {
        this.raf = file;
        this.virtualLength = this.diskLength = this.raf.length();
        this.pointer = 0L;
        this.buf = new byte[bufSize];
    }

    public BinaryFile(File file, int bufSize) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.virtualLength = this.diskLength = this.raf.length();
        this.file = file;
        this.pointer = 0L;
        this.buf = new byte[bufSize];
    }

    public static BinaryFile tempFile(long size) throws IOException {
        File tmpFile = File.createTempFile("Temp", ".file");
        tmpFile.deleteOnExit();
        BinaryFile file = new BinaryFile(tmpFile);
        file.setLength(size);
        return file;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.raf == null) {
            return;
        }
        this.flush();
        this.pointer = -1L;
        this.raf.close();
        this.raf = null;
        this.buf = null;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.buf != null;
    }

    public File file() {
        return this.file;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    private long readableBytesInBuffer() {
        long posInBuf = this.pointer - this.buf_pos;
        if (posInBuf < 0L) {
            return 0L;
        }
        long bytesLeft = (long)this.readable_bytes_count - posInBuf;
        return bytesLeft < 0L ? 0L : bytesLeft;
    }

    private long positionInReadBuffer() {
        long posInBuf = this.pointer - this.buf_pos;
        if (posInBuf < 0L || posInBuf > (long)this.readable_bytes_count) {
            return -1L;
        }
        return posInBuf;
    }

    int _get() throws IOException {
        this.assertReadable(1);
        int posInBuf = (int)(this.pointer - this.buf_pos);
        int result = this.buf[posInBuf] & 0xFF;
        ++this.pointer;
        return result;
    }

    int _getInt() throws IOException {
        this.assertReadable(4);
        int posInBuf = (int)(this.pointer - this.buf_pos);
        int result = this.buf[posInBuf + 3] & 0xFF | (this.buf[posInBuf + 2] & 0xFF) << 8 | (this.buf[posInBuf + 1] & 0xFF) << 16 | (this.buf[posInBuf + 0] & 0xFF) << 24;
        this.pointer += 4L;
        return result;
    }

    long _getLong() throws IOException {
        this.assertReadable(8);
        int posInBuf = (int)(this.pointer - this.buf_pos);
        long result = (long)this.buf[posInBuf + 7] & 0xFFL | ((long)this.buf[posInBuf + 6] & 0xFFL) << 8 | ((long)this.buf[posInBuf + 5] & 0xFFL) << 16 | ((long)this.buf[posInBuf + 4] & 0xFFL) << 24 | ((long)this.buf[posInBuf + 3] & 0xFFL) << 32 | ((long)this.buf[posInBuf + 2] & 0xFFL) << 40 | ((long)this.buf[posInBuf + 1] & 0xFFL) << 48 | ((long)this.buf[posInBuf + 0] & 0xFFL) << 56;
        this.pointer += 8L;
        return result;
    }

    int _read() throws IOException {
        if (this.readableBytesInBuffer() < 1L) {
            this.fill();
            if (this.readableBytesInBuffer() == 0L) {
                return -1;
            }
        }
        int posInBuf = (int)(this.pointer - this.buf_pos);
        int result = this.buf[posInBuf] & 0xFF;
        ++this.pointer;
        return result;
    }

    void _get(byte[] dst, int offset, int length) throws IOException {
        while (length > 0) {
            long n = Math.min(this.readableBytesInBuffer(), (long)length);
            int posInBuf = (int)(this.pointer - this.buf_pos);
            if (n > 0L) {
                System.arraycopy(this.buf, posInBuf, dst, offset, (int)n);
                offset = (int)((long)offset + n);
                length = (int)((long)length - n);
                this.pointer += n;
            }
            if (length <= 0) continue;
            this.fill();
            if (this.readableBytesInBuffer() != 0L) continue;
            throw new EOFException();
        }
    }

    private void writeFlush() throws IOException {
        if (this.write_buf_count > 0 && this.buf_pos >= 0L) {
            this.raf.seek(this.buf_pos);
            this.raf.write(this.buf, 0, this.write_buf_count);
            if (this.buf_pos + (long)this.write_buf_count > this.diskLength) {
                this.diskLength = this.buf_pos + (long)this.write_buf_count;
            }
            this.write_buf_count = 0;
        }
        if (this.diskLength != this.virtualLength) {
            this.raf.setLength(this.virtualLength);
            this.diskLength = this.virtualLength;
        }
    }

    private int prepareForWrite(int bytes) throws IOException {
        int bytesToKeep;
        int posInBuf = (int)(this.pointer - this.buf_pos);
        if (posInBuf < 0) {
            this.writeFlush();
            this.readable_bytes_count = 0;
            this.buf_pos = this.pointer;
            posInBuf = 0;
        } else if (posInBuf > this.readable_bytes_count) {
            this.writeFlush();
            bytesToKeep = this.readable_bytes_count - posInBuf;
            if (bytesToKeep < 0) {
                bytesToKeep = 0;
            }
            if (bytesToKeep > 0) {
                System.arraycopy(this.buf, posInBuf, this.buf, 0, bytesToKeep);
                this.readable_bytes_count = bytesToKeep;
            } else {
                this.readable_bytes_count = 0;
            }
            this.buf_pos = this.pointer;
            posInBuf = 0;
        }
        if (this.buf.length - posInBuf < bytes) {
            this.writeFlush();
            bytesToKeep = this.readable_bytes_count - posInBuf;
            if (bytesToKeep < 0) {
                bytesToKeep = 0;
            }
            if (bytesToKeep > 0) {
                System.arraycopy(this.buf, posInBuf, this.buf, 0, bytesToKeep);
                this.readable_bytes_count = bytesToKeep;
            } else {
                this.readable_bytes_count = 0;
            }
            this.buf_pos = this.pointer;
            posInBuf = 0;
            return this.buf.length;
        }
        return this.buf.length - posInBuf;
    }

    private void assertReadable(int bytes) throws IOException {
        if (this.readableBytesInBuffer() < (long)bytes) {
            this.fill();
            if (this.readableBytesInBuffer() < (long)bytes) {
                throw new EOFException();
            }
        }
    }

    private void fill() throws IOException {
        boolean old_buf_end_in_new_buf;
        this.writeFlush();
        long old_buf_start = this.buf_pos;
        long old_buf_end = this.buf_pos + (long)this.readable_bytes_count;
        int old_buf_length = this.readable_bytes_count;
        long new_buf_start = this.pointer;
        long new_buf_end = Math.min(this.pointer + (long)this.buf.length, this.virtualLength);
        int new_buf_length = (int)(new_buf_end - new_buf_start);
        boolean old_buf_start_in_new_buf = old_buf_start >= new_buf_start && old_buf_start < new_buf_end;
        boolean bl = old_buf_end_in_new_buf = old_buf_end >= new_buf_start && old_buf_end < new_buf_end;
        if (old_buf_end_in_new_buf && !old_buf_start_in_new_buf) {
            int bytesToPreserve = (int)(old_buf_end - new_buf_start);
            int bytesToRead = (int)(new_buf_end - old_buf_end);
            System.arraycopy(this.buf, old_buf_length - bytesToPreserve, this.buf, 0, bytesToPreserve);
            this.raf.seek(new_buf_start + (long)bytesToPreserve);
            this.raf.readFully(this.buf, bytesToPreserve, bytesToRead);
            this.buf_pos = this.pointer;
            this.readable_bytes_count = new_buf_length;
            return;
        }
        if (old_buf_start_in_new_buf && !old_buf_end_in_new_buf) {
            int bytesToPreserve = (int)(new_buf_end - old_buf_start);
            int bytesToRead = (int)(old_buf_start - new_buf_start);
            System.arraycopy(this.buf, 0, this.buf, bytesToRead, bytesToPreserve);
            this.raf.seek(new_buf_start);
            this.raf.readFully(this.buf, 0, bytesToRead);
            this.buf_pos = this.pointer;
            this.readable_bytes_count = new_buf_length;
            return;
        }
        int bytesToRead = new_buf_length;
        this.raf.seek(new_buf_start);
        this.raf.readFully(this.buf, 0, bytesToRead);
        this.buf_pos = this.pointer;
        this.readable_bytes_count = new_buf_length;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this._get();
    }

    @Override
    public char readChar() throws IOException {
        return (char)(this._get() << 8 | this._get());
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this._get() & 0xFF;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this._get() != 0;
    }

    @Override
    public void readFully(byte[] dst, int offset, int length) throws IOException {
        this._get(dst, offset, length);
    }

    @Override
    public void readFully(byte[] dst) throws IOException {
        this._get(dst, 0, dst.length);
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        this.readFully(buf, buf.remaining());
    }

    @Override
    public void readFully(ByteBuffer buf, int length) throws IOException {
        while (length > 0) {
            this.assertReadable(Math.min(this.buf.length, length));
            long n = Math.min(this.readableBytesInBuffer(), (long)length);
            if (n == 0L) {
                throw new EOFException();
            }
            long posInBuf = this.positionInReadBuffer();
            if (n <= 0L || posInBuf < 0L) continue;
            buf.get(this.buf, (int)posInBuf, (int)n);
            length = (int)((long)length - n);
            this.pointer += n;
        }
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readInt() throws IOException {
        return this._get() << 24 | this._get() << 16 | this._get() << 8 | this._get();
    }

    @Override
    public long readLong() throws IOException {
        return this._getLong();
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this._get() << 8 | this._get());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this._get() << 8 | this._get();
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this._read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.position();
                    if (this._read() == 10) continue block4;
                    this.position(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public long position() {
        return this.pointer;
    }

    @Override
    public void position(long newPosition) {
        this.pointer = newPosition;
    }

    @Override
    public void flush() throws IOException {
        this.writeFlush();
    }

    @Override
    public void reset() throws IOException {
        this.writeFlush();
        this.readable_bytes_count = 0;
        this.virtualLength = this.diskLength = this.raf.length();
    }

    @Override
    public long skipBytes(long bytes) throws IOException {
        this.pointer += bytes;
        return bytes;
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        this.pointer += (long)bytes;
        return bytes;
    }

    void _put(int value) throws IOException {
        this.prepareForWrite(1);
        int posInBuf = (int)(this.pointer - this.buf_pos);
        this.buf[posInBuf] = (byte)value;
        ++this.pointer;
        if (this.write_buf_count < ++posInBuf) {
            this.write_buf_count = posInBuf;
        }
        if (this.readable_bytes_count < this.write_buf_count) {
            this.readable_bytes_count = this.write_buf_count;
        }
        if (this.virtualLength < this.pointer) {
            this.virtualLength = this.pointer;
        }
    }

    void _put(byte[] src, int offset, int length) throws IOException {
        while (length > 0) {
            int n = Math.min(this.prepareForWrite(length), length);
            int posInBuf = (int)(this.pointer - this.buf_pos);
            System.arraycopy(src, offset, this.buf, posInBuf, n);
            this.pointer += (long)n;
            offset += n;
            length -= n;
            if (this.write_buf_count < (posInBuf += n)) {
                this.write_buf_count = posInBuf;
            }
            if (this.readable_bytes_count < this.write_buf_count) {
                this.readable_bytes_count = this.write_buf_count;
            }
            if (this.virtualLength >= this.pointer) continue;
            this.virtualLength = this.pointer;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this._put(b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this._put(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this._put(v ? 1 : 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeFully(ByteBuffer src) throws IOException {
        block1: {
            if (!src.hasArray()) ** GOTO lbl8
            array = src.array();
            this._put(array, src.position(), src.remaining());
            src.position(src.limit());
            break block1;
lbl-1000:
            // 1 sources

            {
                this._put(src.get());
lbl8:
                // 2 sources

                ** while (src.hasRemaining())
            }
        }
    }

    @Override
    public void writeFully(ByteBuffer src, int length) throws IOException {
        if (src.hasArray()) {
            byte[] array = src.array();
            this._put(array, src.position(), length);
            src.position(length);
        } else {
            int i = 0;
            while (i < length) {
                this._put(src.get());
                ++i;
            }
        }
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this._put(src, offset, length);
    }

    @Override
    public void write(byte[] src) throws IOException {
        this._put(src, 0, src.length);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeInt(int value) throws IOException {
        this._put(value >> 24);
        this._put(value >> 16);
        this._put(value >> 8);
        this._put(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this._put((int)(value >> 56));
        this._put((int)(value >> 48));
        this._put((int)(value >> 40));
        this._put((int)(value >> 32));
        this._put((int)(value >> 24));
        this._put((int)(value >> 16));
        this._put((int)(value >> 8));
        this._put((int)value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        this._put(value >> 8);
        this._put(value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        this._put(value >> 8);
        this._put(value);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this._put((byte)s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this._put(v >>> 8 & 0xFF);
            this._put(v >>> 0 & 0xFF);
            ++i;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = UTF8.getModifiedUTF8EncodingByteLength(s);
        this.writeShort(len);
        UTF8.writeModifiedUTF(this, s);
    }

    @Override
    public void insertBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        if (this.pointer >= this.virtualLength) {
            this.setLength(this.pointer + bytes);
            return;
        }
        if (this.pointer >= this.buf_pos && this.pointer <= this.buf_pos + (long)this.readable_bytes_count) {
            if (this.buf_pos + (long)this.readable_bytes_count >= this.virtualLength && (long)this.readable_bytes_count + bytes < (long)this.buf.length) {
                int posInBuf = (int)(this.pointer - this.buf_pos);
                System.arraycopy(this.buf, posInBuf, this.buf, (int)((long)posInBuf + bytes), this.readable_bytes_count - posInBuf);
                this.write_buf_count = this.readable_bytes_count = (int)((long)this.readable_bytes_count + bytes);
                this.virtualLength += bytes;
                return;
            }
            this.writeFlush();
            this.reset();
        }
        this.writeFlush();
        this.reset();
        BinaryFile.insertBytes(this.raf, this.pointer, bytes);
        this.virtualLength += bytes;
        this.diskLength += bytes;
        if (this.buf_pos > this.pointer) {
            this.buf_pos += bytes;
        }
    }

    @Override
    public void removeBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        if (this.pointer + bytes > this.virtualLength || this.pointer < 0L) {
            throw new IOException("Pointer outside file");
        }
        if (this.pointer + bytes == this.virtualLength) {
            this.setLength(this.virtualLength - bytes);
            return;
        }
        if (this.pointer + bytes >= this.buf_pos && this.pointer <= this.buf_pos + (long)this.readable_bytes_count) {
            if (this.buf_pos + (long)this.readable_bytes_count >= this.virtualLength) {
                if (this.pointer < this.buf_pos) {
                    int cut_end_InBuf = (int)(this.pointer + bytes - this.buf_pos);
                    System.arraycopy(this.buf, cut_end_InBuf, this.buf, 0, this.readable_bytes_count - cut_end_InBuf);
                    this.readable_bytes_count -= cut_end_InBuf;
                    this.write_buf_count = this.readable_bytes_count;
                    this.virtualLength -= bytes;
                    this.buf_pos = this.pointer;
                    return;
                }
                if (this.pointer >= this.buf_pos) {
                    int posInBuf = (int)(this.pointer - this.buf_pos);
                    System.arraycopy(this.buf, (int)((long)posInBuf + bytes), this.buf, posInBuf, (int)((long)(this.readable_bytes_count - posInBuf) - bytes));
                    this.write_buf_count = this.readable_bytes_count = (int)((long)this.readable_bytes_count - bytes);
                    this.virtualLength -= bytes;
                    return;
                }
            }
            this.writeFlush();
            this.reset();
        }
        this.writeFlush();
        this.reset();
        BinaryFile.removeBytes(this.raf, this.pointer, bytes);
        this.virtualLength -= bytes;
        this.diskLength -= bytes;
        if (this.buf_pos > this.pointer) {
            this.buf_pos -= bytes;
        }
    }

    @Override
    public long length() throws IOException {
        return this.virtualLength;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.virtualLength = newLength;
        if (this.buf_pos + (long)this.readable_bytes_count > this.virtualLength) {
            this.readable_bytes_count = (int)Math.max(this.virtualLength - this.buf_pos, 0L);
        }
        if (this.buf_pos + (long)this.write_buf_count > this.virtualLength) {
            this.write_buf_count = (int)Math.max(this.virtualLength - this.buf_pos, 0L);
        }
    }

    public static void insertBytes(RandomAccessFile file, long position, long bytes) throws IOException {
        if (position < 0L) {
            throw new IndexOutOfBoundsException("position cannot be below 0");
        }
        if (bytes < 0L) {
            throw new IndexOutOfBoundsException("bytes cannot be below 0");
        }
        if (bytes == 0L) {
            return;
        }
        long length = file.length();
        if (position >= length) {
            file.setLength(position + bytes);
            return;
        }
        long bytesOnRight = length - position;
        int bufLength = (int)Math.min(bytesOnRight, 32768L);
        byte[] buf = new byte[bufLength];
        long n = 0L;
        while (n < bytesOnRight) {
            int count = (int)Math.min((long)bufLength, bytesOnRight - n);
            file.seek(length - (long)count - n);
            file.readFully(buf, 0, count);
            file.seek(length - (long)count - n + bytes);
            file.write(buf, 0, count);
            n += (long)count;
        }
    }

    public static void removeBytes(RandomAccessFile file, long position, long bytes) throws IOException {
        if (position < 0L) {
            throw new IndexOutOfBoundsException("position cannot be below 0");
        }
        if (bytes < 0L) {
            throw new IndexOutOfBoundsException("bytes cannot be below 0");
        }
        if (bytes == 0L) {
            return;
        }
        long length = file.length();
        if (position >= length) {
            return;
        }
        if (position + bytes >= length) {
            file.setLength(position);
            return;
        }
        long bytesOnRight = length - position - bytes;
        int bufLength = (int)Math.min(bytesOnRight, 32768L);
        byte[] buf = new byte[bufLength];
        long n = 0L;
        while (n < bytesOnRight) {
            int count = (int)Math.min((long)bufLength, bytesOnRight - n);
            file.seek(position + bytes + n);
            file.readFully(buf, 0, count);
            file.seek(position + n);
            file.write(buf, 0, count);
            n += (long)count;
        }
        file.setLength(position + bytesOnRight);
    }

    public String toString() {
        try {
            return "File(file=" + this.file.getName() + ", size=" + this.length() + ")";
        }
        catch (IOException e) {
            return "File()";
        }
    }
}

