/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;

public class ArrayType
extends Datatype {
    public static final String KEY_LENGTH = "length";
    private transient Range _length;
    private transient String _lengthIsForStr;
    public Datatype componentType;

    public ArrayType() {
    }

    public ArrayType(Datatype componentType) {
        this.componentType = componentType;
    }

    public ArrayType(Datatype componentType, String length) {
        this.componentType = componentType;
        this.setLength(length);
    }

    public ArrayType(Datatype componentType, Range length) {
        this.componentType = componentType;
        this.setLength(length);
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public Datatype getComponentType(int index) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        return this.componentType;
    }

    @Override
    public Datatype getComponentType(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof KeyReference) {
            throw new IllegalArgumentException("KeyReference is not supported in ArrayType");
        }
        if (path instanceof NameReference) {
            throw new IllegalArgumentException("NameReference is not supported in ArrayType");
        }
        if (path instanceof IndexReference && ((IndexReference)path).index != 0) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (path instanceof LabelReference && !((LabelReference)path).label.equals("v")) {
            throw new IllegalArgumentException("Unknown label");
        }
        return this.componentType.getComponentType(path.childReference);
    }

    @Override
    protected void collectSubtypes(Set<Datatype> subtypes, Set<Datatype> recursiveSubtypes) {
        this.componentType.collectSubtypes(subtypes, recursiveSubtypes);
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        return this.componentType.deepEquals(other.componentType, compareHistory);
    }

    @Override
    public int hashCode() {
        if (this.componentType == this) {
            return 0;
        }
        return 144558 + this.metadataHashCode() + 13 * ObjectUtils.hashCode(this.componentType);
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    public Datatype componentType() {
        return this.componentType;
    }

    @Deprecated
    public Datatype getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Datatype componentType) {
        this.componentType = componentType;
    }

    public int minLength() {
        Range length = this.getLength();
        if (length == null) {
            return 0;
        }
        Limit l = length.getLower();
        int value = l.getValue().intValue();
        if (l.isExclusive()) {
            ++value;
        }
        return value;
    }

    public int maxLength() {
        Range length = this.getLength();
        if (length == null) {
            return Integer.MAX_VALUE;
        }
        Limit l = length.getUpper();
        int value = l.getValue().intValue();
        if (l.isExclusive()) {
            --value;
        }
        return value;
    }

    public Range getLength() {
        String lengthStr = (String)this.metadata.get(KEY_LENGTH);
        if (lengthStr == null) {
            return null;
        }
        if (this._length != null && lengthStr != null && lengthStr == this._lengthIsForStr) {
            return this._length;
        }
        try {
            this._lengthIsForStr = lengthStr;
            this._length = Range.valueOf(lengthStr);
        }
        catch (RangeException e) {
            this._length = null;
        }
        return this._length;
    }

    public String getLengthStr() {
        return (String)this.metadata.get(KEY_LENGTH);
    }

    public void setLength(String length) {
        this._length = null;
        this._lengthIsForStr = null;
        if (length == null) {
            this.metadata.remove(KEY_LENGTH);
        } else {
            this.metadata.put(KEY_LENGTH, length);
        }
    }

    public void setLength(Range range) {
        if (range == null) {
            this.metadata.remove(KEY_LENGTH);
            this._length = null;
            this._lengthIsForStr = null;
        } else {
            this._length = range;
            this._lengthIsForStr = range.toString();
            this.metadata.put(KEY_LENGTH, this._lengthIsForStr);
        }
    }
}

