/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.HashMapBinding;
import org.simantics.databoard.binding.impl.OptionalBindingDefault;
import org.simantics.databoard.parser.repository.DataValueRepository;

public class ValueParserSuccessTests
extends TestCase {
    public Object parse(Binding binding, String text) throws Exception {
        return new DataValueRepository().translate(text, binding);
    }

    @Test
    public void testPrimitives() throws Exception {
        ValueParserSuccessTests.assertEquals(Boolean.TRUE, this.parse(Bindings.BOOLEAN, "true"));
        ValueParserSuccessTests.assertEquals(Boolean.FALSE, this.parse(Bindings.BOOLEAN, "false"));
        ValueParserSuccessTests.assertEquals((Object)123, this.parse(Bindings.INTEGER, "123"));
        ValueParserSuccessTests.assertEquals((Object)-234234, this.parse(Bindings.INTEGER, "-234234"));
        ValueParserSuccessTests.assertEquals((Object)12345678912345L, this.parse(Bindings.LONG, "12345678912345"));
        ValueParserSuccessTests.assertEquals(1.2345, this.parse(Bindings.DOUBLE, "1.2345"));
        ValueParserSuccessTests.assertEquals(-3.0, this.parse(Bindings.DOUBLE, "-3"));
        ValueParserSuccessTests.assertEquals(1.0E-10, this.parse(Bindings.DOUBLE, "1e-10"));
        ValueParserSuccessTests.assertEquals(Float.valueOf(2.3f), this.parse(Bindings.FLOAT, "2.3"));
        ValueParserSuccessTests.assertEquals((Object)"Hello World!", this.parse(Bindings.STRING, "\"Hello World!\""));
        ValueParserSuccessTests.assertEquals((Object)"\n\t\r\\\"", this.parse(Bindings.STRING, "\"\\n\\t\\r\\\\\\\"\""));
        ValueParserSuccessTests.assertEquals((Object)"This\ntext\nspans\nmultiple\nlines.", this.parse(Bindings.STRING, "\"\"\"This\ntext\nspans\nmultiple\nlines.\"\"\""));
        ValueParserSuccessTests.assertEquals((Object)"\b", this.parse(Bindings.STRING, "\"\b\""));
    }

    public void assertArraysEqual(int[] expected, int[] actual) {
        if (!Arrays.equals(expected, actual)) {
            ValueParserSuccessTests.failNotEquals(null, expected, actual);
        }
    }

    public void testArray() throws Exception {
        this.assertArraysEqual(new int[]{1, 2, 3}, (int[])this.parse(Bindings.INTEGER, "[1,2,3]"));
    }

    public void testOptional() throws Exception {
        ValueParserSuccessTests.assertEquals(null, (Integer)this.parse(new OptionalBindingDefault(Bindings.INTEGER), "null"));
        ValueParserSuccessTests.assertEquals((Object)1, (Integer)this.parse(new OptionalBindingDefault(Bindings.INTEGER), "1"));
    }

    public void testRecord() throws Exception {
        MyRecord record = (MyRecord)this.parse((Binding)Bindings.getBinding(MyRecord.class), "{ y = \"asd\", x = 5 }");
        ValueParserSuccessTests.assertEquals(5, record.x);
        ValueParserSuccessTests.assertEquals("asd", record.y);
    }

    public void testRecord2() throws Exception {
        MyRecord2 record = (MyRecord2)this.parse((Binding)Bindings.getBinding(MyRecord2.class), "{ y = \"asd\", x = 5 }");
        ValueParserSuccessTests.assertEquals(5, record.x);
        ValueParserSuccessTests.assertEquals("asd", record.y);
    }

    public void testTuple() throws Exception {
        MyRecord record = (MyRecord)this.parse((Binding)Bindings.getBinding(MyRecord.class), "( 5, \"asd\")");
        ValueParserSuccessTests.assertEquals(5, record.x);
        ValueParserSuccessTests.assertEquals("asd", record.y);
    }

    public void testUnion() throws Exception {
        Union1 union = (Union1)this.parse((Binding)Bindings.getBinding(Union1.class), "C (1.2, 3)");
        ValueParserSuccessTests.assertTrue(union instanceof C);
        ValueParserSuccessTests.assertEquals(Float.valueOf(1.2f), Float.valueOf(((C)union).x));
        ValueParserSuccessTests.assertEquals(3, ((C)union).y);
    }

    public void testMap() throws Exception {
        HashMap map = (HashMap)this.parse(new HashMapBinding((Binding)Bindings.getBinding(String.class), (Binding)Bindings.getBinding(Integer.class)), "map { \"1\" = 1, \"2\" = 2 }");
        ValueParserSuccessTests.assertEquals(2, map.size());
        ValueParserSuccessTests.assertEquals((Object)1, map.get("1"));
        ValueParserSuccessTests.assertEquals((Object)2, map.get("2"));
    }

    public static class A
    implements Union1 {
    }

    public static class C
    implements Union1 {
        public float x;
        public int y;

        public C(float x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class MyRecord {
        public int x;
        public String y;

        public MyRecord(int x, String y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class MyRecord2 {
        public int x;
        public String y;
    }

    @Union(value={A.class, C.class})
    static interface Union1 {
    }
}

