/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.file.FileList;
import org.simantics.databoard.file.IFileList;

public class TestFileList1
extends TestCase {
    int length = 10240;
    String[] data1array;
    List<String> data1list;
    IFileList<String> data1file;
    Binding data1binding = Bindings.getBindingUnchecked(String.class);

    @Override
    public void setUp() throws Exception {
        this.data1array = new String[this.length];
        this.data1list = new ArrayList<String>(this.length);
        int i = 0;
        while (i < this.length) {
            String s;
            this.data1array[i] = s = "Line " + (i + 1);
            this.data1list.add(s);
            ++i;
        }
        this.data1file = new FileList<String>(File.createTempFile("Tmp", ".tmp"), String.class);
        this.data1file.getFile().deleteOnExit();
    }

    @Override
    public void tearDown() throws Exception {
        this.data1file.close();
    }

    public void testAppend() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList1.assertEquals(this.length, this.data1file.size());
        int i = 0;
        for (String line : this.data1file) {
            TestFileList1.assertEquals(this.data1array[i++], line);
        }
    }

    public void testClear() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList1.assertFalse(this.data1file.isEmpty());
        TestFileList1.assertEquals(this.length, this.data1file.size());
        this.data1file.clear();
        TestFileList1.assertTrue(this.data1file.isEmpty());
        TestFileList1.assertEquals(0, this.data1file.size());
        TestFileList1.assertTrue(this.data1file.getFile().length() < 1024L);
    }

    public void testRemove() throws Exception {
        this.data1file.addAll(this.data1list);
        int i = 0;
        while (i < this.length) {
            TestFileList1.assertEquals(this.data1array[i], (String)this.data1file.get(i));
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.data1file.remove(10);
            TestFileList1.assertEquals(this.length - i - 1, this.data1file.size());
            ++i;
        }
        i = 0;
        while (i < 10) {
            TestFileList1.assertEquals(this.data1array[i], (String)this.data1file.get(i));
            ++i;
        }
        i = 20;
        while (i < this.length) {
            if (i == 923) {
                System.out.println("x");
            }
            Object x = this.data1file.get(i - 10);
            Object expected = this.data1file.get(i - 10);
            TestFileList1.assertEquals(expected, x);
            ++i;
        }
    }

    public void testInsertAll() throws Exception {
        this.data1file.addAll(this.data1list);
        this.data1file.addAll(0, this.data1list);
        int i = 0;
        while (i < this.length) {
            TestFileList1.assertEquals(this.data1array[i], (String)this.data1file.get(i));
            ++i;
        }
        i = 0;
        while (i < this.length) {
            TestFileList1.assertEquals(this.data1array[i], (String)this.data1file.get(i + this.length));
            ++i;
        }
    }

    public void testSetAll() throws Exception {
        ArrayList<String> data2 = new ArrayList<String>();
        int i = 0;
        while (i < 500) {
            data2.add("XYZabc-??-#" + (i + 1000000));
            ++i;
        }
        this.data1file.clear();
        ((FileList)this.data1file).setAll(data2);
        TestFileList1.assertEquals(this.data1file.size(), data2.size());
        i = 0;
        while (i < data2.size()) {
            TestFileList1.assertEquals((String)data2.get(i), (String)this.data1file.get(i));
            ++i;
        }
        ((FileList)this.data1file).setAll(this.data1list);
        TestFileList1.assertEquals(this.data1file.size(), this.data1list.size());
        i = 0;
        while (i < this.data1list.size()) {
            TestFileList1.assertEquals(this.data1list.get(i), (String)this.data1file.get(i));
            ++i;
        }
    }

    public void testInsert() throws Exception {
        this.data1file.addAll(this.data1list);
        int i = 0;
        while (i < 10) {
            this.data1file.add(10 + i, "XXX" + i);
            TestFileList1.assertEquals(this.length + i + 1, this.data1file.size());
            ++i;
        }
        i = 0;
        while (i < 10) {
            TestFileList1.assertEquals(this.data1array[i], (String)this.data1file.get(i));
            ++i;
        }
        i = 0;
        while (i < 10) {
            TestFileList1.assertEquals("XXX" + i, (String)this.data1file.get(i + 10));
            ++i;
        }
        i = 20;
        while (i < this.length - 10) {
            TestFileList1.assertEquals(this.data1array[i + 10], (String)this.data1file.get(i + 20));
            ++i;
        }
    }

    public void testIterator() throws Exception {
        String value;
        this.data1file.addAll(this.data1list);
        Iterator iter = this.data1file.iterator();
        int i = 0;
        while (iter.hasNext()) {
            TestFileList1.assertEquals(this.data1array[i++], (String)iter.next());
        }
        i = 100;
        ListIterator<String> li = this.data1file.listIterator(100);
        while (li.hasNext()) {
            TestFileList1.assertEquals(li.nextIndex(), i);
            TestFileList1.assertEquals(this.data1array[i++], (String)li.next());
        }
        TestFileList1.assertTrue(i == this.length);
        i = this.data1file.size();
        li = this.data1file.listIterator(i);
        while (li.hasPrevious()) {
            TestFileList1.assertEquals(li.previousIndex(), --i);
            TestFileList1.assertEquals(this.data1array[i], (String)li.previous());
        }
        li = this.data1file.listIterator();
        while (li.hasNext()) {
            li.next();
            li.set("XXX" + li.nextIndex());
        }
        li = this.data1file.listIterator(0);
        while (li.hasNext()) {
            value = (String)li.next();
            TestFileList1.assertEquals("XXX" + li.nextIndex(), value);
        }
        li = this.data1file.listIterator();
        while (li.hasNext()) {
            li.next();
            li.set("ABCDEFG " + li.nextIndex());
        }
        li = this.data1file.listIterator(0);
        while (li.hasNext()) {
            value = (String)li.next();
            TestFileList1.assertEquals("ABCDEFG " + li.nextIndex(), value);
        }
    }

    public void testIndexOf() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList1.assertEquals(2, this.data1file.indexOf("Line 3"));
        TestFileList1.assertEquals(99, this.data1file.lastIndexOf("Line 100"));
        TestFileList1.assertEquals(-1, this.data1file.indexOf("xyz"));
        TestFileList1.assertEquals(-1, this.data1file.lastIndexOf("xyz"));
    }

    public void testContains() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList1.assertTrue(this.data1file.contains("Line 5"));
        TestFileList1.assertTrue(this.data1file.contains("Line 50"));
        TestFileList1.assertFalse(this.data1file.contains("line 5"));
    }

    public void testSubList() throws Exception {
        this.data1file.addAll(this.data1list);
        List subList = this.data1file.subList(10, 110);
        TestFileList1.assertEquals(100, subList.size());
        int i = 0;
        while (i < 100) {
            TestFileList1.assertEquals(this.data1array[i + 10], (String)subList.get(i));
            ++i;
        }
    }

    public void testToArray() throws Exception {
        this.data1file.addAll(this.data1list);
        Object[] array = this.data1file.toArray((String[])new String[0]);
        TestFileList1.assertTrue(Arrays.equals(array, this.data1array));
    }

    public void testOpen() throws Exception {
        File file = this.data1file.getFile();
        this.data1file.addAll(this.data1list);
        this.data1file.close();
        this.data1file = new FileList<String>(file, String.class);
        int i = 0;
        while (i < this.length) {
            TestFileList1.assertEquals(this.data1array[i], (String)this.data1file.get(i));
            ++i;
        }
    }
}

