/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.util.RandomValue;
import org.simantics.databoard.type.Datatype;

public class TestClone {
    @Test
    public void testGenericBinding() throws Exception {
        RandomValue rv = new RandomValue();
        rv.refereableRecords = true;
        int i = 0;
        while (i < 10000) {
            rv.random = new Random(i);
            rv.random.nextLong();
            Datatype type = rv.randomType(0, 3);
            Object binding = Bindings.getMutableBinding(type);
            Object o1 = ((Binding)binding).accept(rv);
            Object o2 = ((Binding)binding).clone(o1);
            System.out.println(String.valueOf(i) + ": " + type);
            if (!((Binding)binding).equals(o1, o2)) {
                this.assertNotSameInstance((Binding)binding, o1, o2);
                Object o3 = Bindings.adapt(o1, binding, binding);
                Assert.assertTrue(o3 == o1);
            }
            ++i;
        }
    }

    public void assertNotSameInstance(Binding b, Object o1, Object o2) throws Exception {
        Assert.assertTrue(b.isImmutable() || o1 != o2);
        if (b instanceof RecordBinding) {
            this.assertNotSameRecord((RecordBinding)b, o1, o2);
        }
        if (b instanceof UnionBinding) {
            this.assertNotSameUnion((UnionBinding)b, o1, o2);
        }
        if (b instanceof ArrayBinding) {
            this.assertNotSameArray((ArrayBinding)b, o1, o2);
        }
        if (b instanceof MapBinding) {
            this.assertNotSameMap((MapBinding)b, o1, o2);
        }
        if (b instanceof OptionalBinding) {
            this.assertNotSameOptional((OptionalBinding)b, o1, o2);
        }
        if (b instanceof VariantBinding) {
            this.assertNotSameVariant((VariantBinding)b, o1, o2);
        }
    }

    public void assertNotSameArray(ArrayBinding b, Object o1, Object o2) throws Exception {
        int count = b.size(o1);
        Binding cb = b.getComponentBinding();
        int i = 0;
        while (i < count) {
            Object v1 = b.get(o1, i);
            Object v2 = b.get(o2, i);
            this.assertNotSameInstance(cb, v1, v2);
            ++i;
        }
    }

    public void assertNotSameMap(MapBinding b, Object o1, Object o2) throws Exception {
        int count = b.size(o1);
        Binding vb = b.getValueBinding();
        Object[] values1 = b.getValues(o1);
        Object[] values2 = b.getValues(o2);
        int i = 0;
        while (i < count) {
            Object v1 = values1[i];
            Object v2 = values2[i];
            this.assertNotSameInstance(vb, v1, v2);
            ++i;
        }
    }

    public void assertNotSameOptional(OptionalBinding b, Object o1, Object o2) throws Exception {
        Binding cb = b.getComponentBinding();
        Object v1 = b.getValue(o1);
        Object v2 = b.getValue(o2);
        this.assertNotSameInstance(cb, v1, v2);
    }

    public void assertNotSameVariant(VariantBinding b, Object o1, Object o2) throws Exception {
        Binding cb = b.getContentBinding(o1);
        Object v1 = b.getContent(o1);
        Object v2 = b.getContent(o2);
        this.assertNotSameInstance(cb, v1, v2);
    }

    public void assertNotSameRecord(RecordBinding b, Object o1, Object o2) throws Exception {
        int count = b.getComponentCount();
        int i = 0;
        while (i < count) {
            Binding cb = b.getComponentBinding(i);
            Object v1 = b.getComponent(o1, i);
            Object v2 = b.getComponent(o2, i);
            this.assertNotSameInstance(cb, v1, v2);
            ++i;
        }
    }

    public void assertNotSameUnion(UnionBinding b, Object o1, Object o2) throws Exception {
        int tag = b.getTag(o1);
        Assert.assertEquals(tag, b.getTag(o2));
        Binding cb = b.getComponentBinding(tag);
        Object v1 = b.getValue(o1);
        Object v2 = b.getValue(o2);
        this.assertNotSameInstance(cb, v1, v2);
    }
}

