/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.BooleanAccessor;
import org.simantics.databoard.accessor.ByteAccessor;
import org.simantics.databoard.accessor.DoubleAccessor;
import org.simantics.databoard.accessor.FloatAccessor;
import org.simantics.databoard.accessor.IntegerAccessor;
import org.simantics.databoard.accessor.LongAccessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.OptionalAccessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.StringAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.VariantAccessor;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.InvalidatedEvent;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.accessor.impl.ChangeSet;
import org.simantics.databoard.accessor.impl.CompositeRecord;
import org.simantics.databoard.accessor.impl.DirectoryMap;
import org.simantics.databoard.accessor.impl.EventCollection;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.wire.WireClient;
import org.simantics.databoard.accessor.wire.WireServer;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.factory.BindingScheme;
import org.simantics.databoard.binding.factory.MutableBindingFactory;
import org.simantics.databoard.binding.impl.ObjectArrayBinding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.util.RandomValue;
import org.simantics.databoard.method.Client;
import org.simantics.databoard.method.Server;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.binary.BinaryMemory;

public class TestAccessor {
    RandomValue rv;
    Map<Datatype, Binding> repository;
    BindingScheme scheme;

    @Before
    public void init() {
        this.rv = new RandomValue();
        this.repository = new HashMap<Datatype, Binding>();
        this.scheme = new MutableBindingFactory(this.repository);
    }

    public static File createTmpDir() {
        String tmp = System.getenv("tmp");
        if (tmp == null) {
            tmp = "c:/temp";
        }
        Random r = new Random();
        String randomName = "tmp-" + (r.nextInt(10000) + 10000);
        File tmpDir = new File(String.valueOf(tmp) + "/" + randomName);
        Boolean ok = tmpDir.mkdirs();
        Assert.assertTrue(ok);
        return tmpDir;
    }

    public boolean isKeyShortEnough(Binding binding, Object value) throws AdaptException {
        String key = (String)Bindings.adapt(value, binding, Bindings.STR_VARIANT);
        return key.length() <= 200;
    }

    @Test
    public void testWireAccessor() throws Exception {
        System.out.println("Wire accessor test");
        int i = 0;
        while (i < 10000) {
            Bindings.defaultBindingRepository.clear();
            Bindings.bindingRepository.clear();
            Bindings.serializerRepository.clear();
            this.repository.clear();
            System.out.println(String.valueOf(i) + ": ");
            this.rv = new RandomValue(i);
            this.rv.refereableRecords = false;
            Datatype type = this.rv.randomType(0, 3);
            Binding binding = this.scheme.getBindingUnchecked(type);
            Object instance = binding.accept(this.rv);
            Object accessor = Accessors.getAccessor(binding, instance);
            WireServer wireServer = new WireServer((Accessor)accessor);
            Server server = new Server(0, wireServer.getMethodInterface());
            WireClient wireClient = new WireClient();
            Client client = new Client(InetAddress.getByName("localhost"), server.getPort(), wireClient.getClientMethodInterface());
            wireClient.setServerMethodInterface(client.getConnection().getRemoteMethodInterface());
            WireClient.WireAccessor remoteAccessor = wireClient.getAccessor(null);
            this.testAccessor(remoteAccessor);
            wireClient.close();
            client.close();
            server.close();
            ++i;
        }
    }

    @Test
    public void testBinaryAccessor() throws Exception {
        System.out.println("Test Binary Memory:");
        VariantType type = Datatypes.VARIANT;
        Binding binding = this.scheme.getBindingUnchecked(type);
        Serializer s = binding.serializer();
        TObjectIntHashMap<Object> identities = new TObjectIntHashMap<Object>();
        int i = 0;
        while (i < 10000) {
            Bindings.defaultBindingRepository.clear();
            Bindings.bindingRepository.clear();
            Bindings.serializerRepository.clear();
            this.repository.clear();
            this.rv = new RandomValue(i);
            this.rv.getRandom().nextLong();
            this.rv.refereableRecords = false;
            System.out.println(String.valueOf(i) + ": ");
            BinaryMemory ram = new BinaryMemory(0);
            Object instance = binding.accept(this.rv);
            binding.assertInstaceIsValid(instance);
            identities.clear();
            int size = s.getSize(instance, identities);
            ram.setLength(size);
            ram.position(0L);
            identities.clear();
            s.serialize(ram, identities, instance);
            identities.clear();
            ram.position(0L);
            Object instance2 = s.deserialize(ram);
            Assert.assertTrue(binding.equals(instance, instance2));
            binding.assertInstaceIsValid(instance2);
            VariantAccessor a = (VariantAccessor)Accessors.getAccessor(ram, (Datatype)type);
            this.testAccessor(a);
            ++i;
        }
    }

    @Test
    public void testJavaAccessor() throws Exception {
        System.out.println("Test Java Objects:");
        int i = 0;
        while (i < 10000) {
            Bindings.defaultBindingRepository.clear();
            Bindings.bindingRepository.clear();
            Bindings.serializerRepository.clear();
            this.repository.clear();
            System.out.println(String.valueOf(i) + ": ");
            this.rv = new RandomValue(i);
            this.rv.refereableRecords = false;
            Datatype type = this.rv.randomType(0, 3);
            Binding binding = this.scheme.getBindingUnchecked(type);
            Object instance = binding.accept(this.rv);
            Object accessor = Accessors.getAccessor(binding, instance);
            this.testAccessor((Accessor)accessor);
            ++i;
        }
    }

    @Test
    public void testCompositeRecord() throws Exception {
        System.out.println("Test composite accessor");
        int i = 0;
        while (i < 100) {
            CompositeRecord record = new CompositeRecord();
            int j = 1;
            while (j <= 10) {
                VariantBinding binding = Bindings.MUTABLE_VARIANT;
                this.rv = new RandomValue(i * 543 + j * 23);
                this.rv.getRandom().nextLong();
                this.rv.refereableRecords = false;
                MutableVariant instance = (MutableVariant)((Binding)binding).accept(this.rv);
                String fieldName = "Field" + j;
                Object fa = Accessors.getAccessor(instance.getBinding(), instance.getValue());
                record.addField(fieldName, (Accessor)fa);
                ++j;
            }
            System.out.println(i);
            this.testAccessor(record);
            ++i;
        }
    }

    @Test
    public void testFolderMap() throws Exception {
        int i = 0;
        while (i < 100) {
            Bindings.defaultBindingRepository.clear();
            Bindings.bindingRepository.clear();
            Bindings.serializerRepository.clear();
            this.repository.clear();
            System.out.println(String.valueOf(i) + ": ");
            File dir = TestAccessor.createTmpDir();
            DirectoryMap map = Accessors.openDirectory(dir);
            VariantBinding keyBinding = Bindings.STR_VARIANT;
            try {
                System.out.println("Test Folder Map: " + dir);
                int j = 0;
                while (j < 10) {
                    this.rv = new RandomValue(i * 231231243 + j * 213);
                    this.rv.refereableRecords = false;
                    String key = "";
                    while ((key = (String)((Binding)keyBinding).accept(this.rv)).length() > 240) {
                    }
                    Datatype valueType = this.rv.randomType(0, 2);
                    Binding valueBinding = this.scheme.getBindingUnchecked(valueType);
                    Object value = valueBinding.accept(this.rv);
                    System.out.println(key);
                    MutableVariant vv = new MutableVariant(valueBinding, value);
                    map.put(Bindings.STR_VARIANT, key, Bindings.MUTABLE_VARIANT, vv);
                    ++j;
                }
                this.testAccessor(map);
            }
            finally {
                map.clear();
                map.close();
                System.out.println(String.valueOf(dir.listFiles().length) + " files.");
                dir.delete();
            }
            ++i;
        }
    }

    @Test
    public void testBinaryFile() throws Exception {
        File tmpFile = File.createTempFile("TestAccessor", ".dat");
        System.out.println("Test Binary File: " + tmpFile);
        tmpFile.deleteOnExit();
        FileVariantAccessor fa = Accessors.createFile(tmpFile);
        VariantType type = Datatypes.VARIANT;
        Binding binding = this.scheme.getBindingUnchecked(type);
        int i = 0;
        while (i < 10000) {
            Bindings.bindingRepository.clear();
            Bindings.serializerRepository.clear();
            Bindings.defaultBindingRepository.clear();
            this.repository.clear();
            System.out.println(String.valueOf(i) + ": ");
            this.rv = new RandomValue(i);
            this.rv.getRandom().nextLong();
            this.rv.refereableRecords = false;
            Object instance = binding.accept(this.rv);
            System.out.print(String.valueOf(i) + ": " + binding.printValueDefinition(instance, true));
            fa.setValue(binding, instance);
            this.testAccessor(fa);
            ++i;
        }
        fa.close();
    }

    public void testAccessor(Accessor a) throws Exception {
        Datatype type = a.type();
        Binding binding = this.scheme.getBindingUnchecked(type);
        InterestSet is = InterestSet.newInterestSet(type, true, true, true);
        boolean mutable = !binding.isImmutable();
        Object origValue = a.getValue(binding);
        binding.assertInstaceIsValid(origValue);
        Object testValue = binding.accept(this.rv);
        Object mutableInstance = binding.createDefault();
        a.getValue(binding, mutableInstance);
        Assert.assertTrue(Bindings.equals(binding, origValue, binding, mutableInstance));
        boolean same = binding.equals(origValue, testValue);
        Object refValue = binding.clone(origValue);
        Object ra = Accessors.getAccessor(binding, refValue);
        if (mutable) {
            ra.setValue(binding, testValue);
            Object refClone = ra.getValue(binding);
            Assert.assertTrue(binding.equals(testValue, refClone));
            ra.setValue(binding, binding.clone(origValue));
            refClone = ra.getValue(binding);
            Assert.assertTrue(binding.equals(origValue, refClone));
            ChangeSet cs = new ChangeSet();
            a.addListener(cs, is, null, null);
            a.setValue(binding, testValue);
            if (!same) {
                Assert.assertFalse(cs.isEmpty());
            }
            Object x = a.getValue(binding);
            Assert.assertTrue(binding.equals(testValue, x));
            LinkedList<Event> rollback = new LinkedList<Event>();
            List<Event> events = cs.getAndClearEvents();
            ra.apply(events, rollback);
            x = ra.getValue(binding);
            Assert.assertTrue(binding.equals(x, testValue));
            a.removeListener(cs);
            a.apply(rollback, null);
            x = a.getValue(binding);
            if (!binding.equals(x, origValue)) {
                binding.equals(x, origValue);
            }
            Assert.assertTrue(binding.equals(x, origValue));
        }
        Object x = a.getValue(binding);
        Assert.assertTrue(binding.equals(x, origValue));
        if (a instanceof ArrayAccessor) {
            this.testArrayAccessor((ArrayAccessor)a);
        }
        if (a instanceof RecordAccessor) {
            this.testRecordAccessor((RecordAccessor)a);
        }
        if (a instanceof MapAccessor) {
            this.testMapAccessor((MapAccessor)a);
        }
        if (a instanceof BooleanAccessor) {
            this.testBooleanAccessor((BooleanAccessor)a);
        }
        if (a instanceof ByteAccessor) {
            this.testByteAccessor((ByteAccessor)a);
        }
        if (a instanceof DoubleAccessor) {
            this.testDoubleAccessor((DoubleAccessor)a);
        }
        if (a instanceof FloatAccessor) {
            this.testFloatAccessor((FloatAccessor)a);
        }
        if (a instanceof IntegerAccessor) {
            this.testIntegerAccessor((IntegerAccessor)a);
        }
        if (a instanceof LongAccessor) {
            this.testLongAccessor((LongAccessor)a);
        }
        if (a instanceof OptionalAccessor) {
            this.testOptionalAccessor((OptionalAccessor)a);
        }
        if (a instanceof StringAccessor) {
            this.testStringAccessor((StringAccessor)a);
        }
        if (a instanceof UnionAccessor) {
            this.testUnionAccessor((UnionAccessor)a);
        }
        if (a instanceof VariantAccessor) {
            this.testVariantAccessor((VariantAccessor)a);
        }
        a.setValue(binding, origValue);
        x = a.getValue(binding);
        Assert.assertTrue(binding.equals(x, origValue));
    }

    public void testMapAccessor(MapAccessor a) throws Exception {
        Object x;
        MapType type = a.type();
        MapBinding binding = (MapBinding)this.scheme.getBindingUnchecked(type);
        Binding kb = binding.getKeyBinding();
        Binding vb = binding.getValueBinding();
        InterestSet is = InterestSet.newInterestSet(type, true, true, false);
        boolean mutable = !binding.isImmutable();
        int len = a.size();
        Object[] oks = new Object[len];
        Object[] ovs = new Object[len];
        a.getAll(kb, vb, oks, ovs);
        TreeMap<Object, Object> om = new TreeMap<Object, Object>(kb);
        a.getAll(kb, vb, om);
        Object[] oks2 = a.getKeys(kb);
        Object[] ovs2 = a.getValues(vb);
        int i = 0;
        while (i < len) {
            Assert.assertTrue(om.containsKey(oks[i]));
            Assert.assertTrue(om.containsKey(oks2[i]));
            Object v = om.get(oks[i]);
            Assert.assertTrue(vb.equals(v, ovs[i]));
            Assert.assertTrue(vb.equals(v, ovs2[i]));
            v = om.get(oks2[i]);
            Assert.assertTrue(vb.equals(v, ovs[i]));
            Assert.assertTrue(vb.equals(v, ovs2[i]));
            ++i;
        }
        if (len > 2) {
            Object[] keys = new Object[len];
            Object[] values = new Object[len];
            int c = a.getEntries(kb, a.getFirstKey(kb), true, a.getLastKey(kb), true, new ObjectArrayBinding(kb), keys, new ObjectArrayBinding(vb), values, -1);
            Assert.assertEquals(len, c);
            int i2 = 0;
            while (i2 < len) {
                Assert.assertTrue(kb.equals(oks[i2], keys[i2]));
                Assert.assertTrue(vb.equals(ovs[i2], values[i2]));
                ++i2;
            }
            keys = new Object[len - 2];
            values = new Object[len - 2];
            c = a.getEntries(kb, a.getFirstKey(kb), false, a.getLastKey(kb), false, new ObjectArrayBinding(kb), keys, new ObjectArrayBinding(vb), values, -1);
            Assert.assertEquals(len - 2, c);
            i2 = 1;
            while (i2 < len - 1) {
                Assert.assertTrue(kb.equals(oks[i2], keys[i2 - 1]));
                Assert.assertTrue(vb.equals(ovs[i2], values[i2 - 1]));
                ++i2;
            }
            c = a.getEntries(kb, a.getFirstKey(kb), true, a.getLastKey(kb), false, new ObjectArrayBinding(kb), keys, new ObjectArrayBinding(vb), values, 1);
            Assert.assertEquals(1L, c);
            Assert.assertTrue(kb.equals(oks[0], keys[0]));
            Assert.assertTrue(vb.equals(ovs[0], values[0]));
        }
        TreeSet<Object> keys = new TreeSet<Object>(kb);
        int i3 = 0;
        while (i3 < 10) {
            Object key = null;
            if (kb.type().equals(Datatypes.VARIANT)) {
                do {
                    key = kb.accept(this.rv);
                } while (!kb.type().equals(Datatypes.VARIANT) || !this.isKeyShortEnough(kb, key));
            } else {
                key = kb.accept(this.rv);
            }
            keys.add(key);
            ++i3;
        }
        int testValueCount = keys.size();
        Object[] tks = keys.toArray(new Object[testValueCount]);
        Object[] tvs = new Object[testValueCount];
        int i4 = 0;
        while (i4 < testValueCount) {
            tvs[i4] = vb.accept(this.rv);
            ++i4;
        }
        if (len >= 3) {
            Object fk = a.getFirstKey(kb);
            Assert.assertTrue(kb.equals(fk, oks[0]));
            Object lk = a.getLastKey(kb);
            Assert.assertTrue(kb.equals(lk, oks[len - 1]));
            Object k = a.getLowerKey(kb, fk);
            Assert.assertNull(k);
            k = a.getLowerKey(kb, lk);
            Assert.assertTrue(kb.equals(k, oks[len - 2]));
            k = a.getFloorKey(kb, fk);
            Assert.assertTrue(kb.equals(k, oks[0]));
            k = a.getFloorKey(kb, lk);
            Assert.assertTrue(kb.equals(k, oks[len - 1]));
            k = a.getCeilingKey(kb, lk);
            Assert.assertTrue(kb.equals(k, oks[len - 1]));
            k = a.getCeilingKey(kb, fk);
            Assert.assertTrue(kb.equals(k, oks[0]));
            k = a.getHigherKey(kb, lk);
            Assert.assertNull(k);
            k = a.getHigherKey(kb, fk);
            Assert.assertTrue(kb.equals(k, oks[1]));
        }
        a.clear();
        int size = a.size();
        Assert.assertEquals(0L, size);
        a.putAll(kb, vb, oks, ovs);
        size = a.size();
        Assert.assertEquals(len, size);
        a.clear();
        Assert.assertEquals(0L, a.size());
        a.putAll(kb, vb, om);
        Assert.assertEquals(len, a.size());
        int i5 = 0;
        while (i5 < len) {
            Assert.assertTrue(a.containsKey(kb, oks[i5]));
            Assert.assertTrue(a.containsValue(vb, ovs[i5]));
            ++i5;
        }
        if (mutable) {
            int count = len;
            int i6 = 0;
            while (i6 < testValueCount) {
                if (!a.containsKey(kb, tks[i6])) {
                    ++count;
                }
                a.put(kb, tks[i6], vb, tvs[i6]);
                ++i6;
            }
            Assert.assertEquals(count, a.size());
            i6 = 0;
            while (i6 < testValueCount) {
                Object o = a.get(kb, tks[i6], vb);
                Assert.assertTrue(vb.equals(tvs[i6], o));
                ++i6;
            }
            i6 = 0;
            while (i6 < testValueCount) {
                a.remove(kb, tks[i6]);
                ++i6;
            }
            i6 = 0;
            while (i6 < len) {
                a.remove(kb, oks[i6]);
                ++i6;
            }
            a.putAll(kb, vb, oks, ovs);
        }
        int common = Math.min(len, testValueCount);
        int i7 = 0;
        while (i7 < common) {
            a.put(kb, oks[i7], vb, tvs[i7]);
            x = a.get(kb, oks[i7], vb);
            Assert.assertTrue(vb.equals(tvs[i7], x));
            ++i7;
        }
        i7 = 0;
        while (i7 < common) {
            a.put(kb, oks[i7], vb, ovs[i7]);
            x = a.get(kb, oks[i7], vb);
            Assert.assertTrue(vb.equals(ovs[i7], x));
            ++i7;
        }
        i7 = 0;
        while (i7 < len) {
            Object sa = a.getValueAccessor(kb, oks[i7]);
            this.testAccessor((Accessor)sa);
            ++i7;
        }
    }

    public void testArrayAccessor(ArrayAccessor a) throws Exception {
        ArrayType type = a.type();
        ArrayBinding binding = (ArrayBinding)this.scheme.getBindingUnchecked(type);
        Binding cb = binding.getComponentBinding();
        InterestSet is = InterestSet.newInterestSet(type, true, true, false);
        boolean mutable = !binding.isImmutable();
        int len = a.size();
        Object[] ovs = new Object[len];
        a.getAll(cb, ovs);
        int testValueCount = this.rv.getRandom().nextInt(10) + 10;
        Object[] tvs = new Object[testValueCount];
        Object[] tvs2 = new Object[testValueCount];
        int i = 0;
        while (i < testValueCount) {
            tvs[i] = cb.accept(this.rv);
            tvs2[i] = cb.accept(this.rv);
            ++i;
        }
        if (mutable) {
            Object o2;
            Object o1;
            Object o22;
            a.addAll(cb, tvs);
            i = 0;
            while (i < testValueCount) {
                Object o12 = a.get(i + len, cb);
                o22 = tvs[i];
                Assert.assertTrue(cb.equals(o12, o22));
                ++i;
            }
            Object o13 = cb.createDefault();
            int i2 = 0;
            while (i2 < testValueCount) {
                a.get(i2 + len, cb, o13);
                o22 = tvs[i2];
                Assert.assertTrue(cb.equals(o13, o22));
                ++i2;
            }
            Object[] all = new Object[testValueCount + len];
            a.getAll(cb, all);
            i2 = 0;
            while (i2 < testValueCount) {
                o1 = all[i2 + len];
                o2 = tvs[i2];
                Assert.assertTrue(cb.equals(o1, o2));
                ++i2;
            }
            a.remove(len, testValueCount);
            i2 = 0;
            while (i2 < len) {
                o1 = ovs[i2];
                o2 = a.get(i2, cb);
                Assert.assertTrue(cb.equals(o1, o2));
                ++i2;
            }
            Assert.assertEquals(len, a.size());
            a.addAll(0, cb, tvs);
            i2 = 0;
            while (i2 < testValueCount) {
                o1 = a.get(i2, cb);
                o2 = tvs[i2];
                Assert.assertTrue(cb.equals(o1, o2));
                ++i2;
            }
            a.getAll(cb, all);
            i2 = 0;
            while (i2 < testValueCount) {
                o1 = all[i2];
                o2 = tvs[i2];
                Assert.assertTrue(cb.equals(o1, o2));
                ++i2;
            }
            a.remove(0, testValueCount);
            Assert.assertEquals(len, a.size());
        }
        int oldSize = a.size();
        a.setSize(oldSize + 10);
        Assert.assertEquals(oldSize + 10, a.size());
        a.setSize(oldSize);
        Assert.assertEquals(oldSize, a.size());
        int common = Math.min(len, testValueCount);
        int i3 = 0;
        while (i3 < common) {
            a.set(i3, cb, tvs[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < common) {
            Assert.assertTrue(cb.equals(tvs[i3], a.get(i3, cb)));
            ++i3;
        }
        i3 = 0;
        while (i3 < common) {
            a.set(i3, cb, ovs[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < common) {
            Assert.assertTrue(cb.equals(ovs[i3], a.get(i3, cb)));
            ++i3;
        }
        i3 = 0;
        while (i3 < len) {
            Object sa = a.getAccessor(i3);
            this.testAccessor((Accessor)sa);
            ++i3;
        }
    }

    public void testRecordAccessor(RecordAccessor a) throws Exception {
        RecordType type = a.type();
        RecordBinding binding = (RecordBinding)this.scheme.getBindingUnchecked(type);
        Binding[] cbs = binding.getComponentBindings();
        InterestSet is = InterestSet.newInterestSet(type, true, true, false);
        int len = a.count();
        Object[] ovs = new Object[len];
        int i = 0;
        while (i < len) {
            ovs[i] = a.getFieldValue(i, cbs[i]);
            ++i;
        }
        Object[] tvs = new Object[len];
        Object[] tvs2 = new Object[len];
        int i2 = 0;
        while (i2 < len) {
            tvs[i2] = cbs[i2].accept(this.rv);
            tvs2[i2] = cbs[i2].accept(this.rv);
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            a.setFieldValue(i2, cbs[i2], tvs[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            Assert.assertTrue(cbs[i2].equals(tvs[i2], a.getFieldValue(i2, cbs[i2])));
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            a.setFieldValue(i2, cbs[i2], ovs[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            Assert.assertTrue(cbs[i2].equals(ovs[i2], a.getFieldValue(i2, cbs[i2])));
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            Object sa = a.getFieldAccessor(i2);
            this.testAccessor((Accessor)sa);
            ++i2;
        }
    }

    public void testOptionalAccessor(OptionalAccessor a) throws Exception {
        OptionalType type = a.type();
        OptionalBinding binding = (OptionalBinding)this.scheme.getBindingUnchecked(type);
        Binding cb = binding.getComponentBinding();
        InterestSet is = InterestSet.newInterestSet(type, true, true, true);
        boolean hadValue = a.hasValue();
        Object ov = hadValue ? a.getComponentValue(cb) : null;
        Object tv = cb.accept(this.rv);
        a.setComponentValue(cb, tv);
        Assert.assertTrue(cb.equals(a.getComponentValue(cb), tv));
        Assert.assertEquals(true, a.hasValue());
        a.setNoValue();
        Assert.assertEquals(false, a.hasValue());
        a.setNoValue();
        a.setComponentValue(cb, tv);
        Object sa = a.getComponentAccessor();
        EventCollection ec = new EventCollection();
        a.addListener(ec, is, null, null);
        a.setNoValue();
        a.removeListener(ec);
        boolean invalidatedEventOk = false;
        for (Event e : ec.getAndClearEvents()) {
            invalidatedEventOk |= e instanceof InvalidatedEvent && e.reference != null;
        }
        sa.getClass();
        Assert.assertTrue(invalidatedEventOk);
        if (hadValue) {
            a.setComponentValue(cb, ov);
        } else {
            a.setNoValue();
        }
    }

    public void testUnionAccessor(UnionAccessor a) throws Exception {
        UnionType type = a.type();
        UnionBinding binding = (UnionBinding)this.scheme.getBindingUnchecked(type);
        Binding[] cbs = binding.getComponentBindings();
        InterestSet is = InterestSet.newInterestSet(type, true, true, true);
        int len = a.count();
        int ot = a.getTag();
        Object ov = a.getComponentValue(cbs[ot]);
        Object[] tvs = new Object[len];
        Object[] tvs2 = new Object[len];
        int i = 0;
        while (i < len) {
            tvs[i] = cbs[i].accept(this.rv);
            tvs2[i] = cbs[i].accept(this.rv);
            ++i;
        }
        i = 0;
        while (i < len) {
            a.setComponentValue(i, cbs[i], tvs[i]);
            Assert.assertEquals(i, a.getTag());
            Assert.assertTrue(Bindings.equals(cbs[i], a.getComponentValue(cbs[i]), cbs[i], tvs[i]));
            ++i;
        }
        if (type.getComponentCount() > 1) {
            i = 0;
            a.setComponentValue(i, cbs[i], tvs[i]);
            Object sa = a.getComponentAccessor();
            EventCollection ec = new EventCollection();
            a.addListener(ec, is, null, null);
            i = 1;
            a.setComponentValue(i, cbs[i], tvs[i]);
            boolean invalidatedEventOk = false;
            List<Event> events = ec.getAndClearEvents();
            for (Event e : events) {
                invalidatedEventOk |= e instanceof InvalidatedEvent && e.reference != null;
            }
            a.removeListener(ec);
            sa.getClass();
            Assert.assertTrue(invalidatedEventOk);
        }
        a.setComponentValue(ot, cbs[ot], ov);
        Object sa = a.getComponentAccessor();
        this.testAccessor((Accessor)sa);
    }

    public void testVariantAccessor(VariantAccessor a) throws Exception {
        boolean mutable;
        VariantType type = a.type();
        VariantBinding binding = (VariantBinding)this.scheme.getBindingUnchecked(type);
        InterestSet is = InterestSet.newInterestSet(type, true, true, true);
        Binding ob = this.scheme.getBindingUnchecked(type);
        Object ov = a.getValue(ob);
        ob.assertInstaceIsValid(ov);
        boolean bl = mutable = !binding.isImmutable();
        if (mutable) {
            int testValueCount = 10;
            Binding[] tvb = new Binding[testValueCount];
            Object[] tvs = new Object[testValueCount];
            int i = 0;
            while (i < testValueCount) {
                tvb[i] = this.scheme.getBindingUnchecked(this.rv.randomType(0, 2));
                tvs[i] = tvb[i].accept(this.rv);
                ++i;
            }
            i = 0;
            while (i < testValueCount) {
                a.setContentValue(tvb[i], tvs[i]);
                Object o = a.getContentValue(tvb[i]);
                Assert.assertTrue(tvb[i].equals(o, tvs[i]));
                ++i;
            }
            Binding tb = tvb[1];
            Object tv = tvs[1];
            Datatype ct = tvb[0].type();
            a.setContentValue(tvb[0], tvs[0]);
            EventCollection ec = new EventCollection();
            a.addListener(ec, is, null, null);
            Object sa = a.getContentAccessor();
            a.setContentValue(tvb[1], tvs[1]);
            a.removeListener(ec);
            if (!ct.getClass().equals(tb.type().getClass())) {
                boolean invalidatedEventOk = false;
                List<Event> events = ec.getAndClearEvents();
                for (Event e : events) {
                    invalidatedEventOk |= e instanceof InvalidatedEvent && e.reference != null;
                }
                Assert.assertTrue(invalidatedEventOk);
            }
        }
        Object sa = a.getContentAccessor();
        this.testAccessor((Accessor)sa);
        a.setValue(ob, ov);
    }

    public void testByteAccessor(ByteAccessor a) throws Exception {
        byte ov = a.getValue();
        ByteBinding b = Bindings.BYTE;
        int i = 0;
        while (i < 10) {
            Byte r = (Byte)this.rv.visit(b);
            a.setValue(r);
            Assert.assertTrue(r.byteValue() == a.getValue());
            ++i;
        }
        a.setValue(ov);
    }

    public void testDoubleAccessor(DoubleAccessor a) throws Exception {
        double ov = a.getValue();
        DoubleBinding b = Bindings.DOUBLE;
        int i = 0;
        while (i < 10) {
            Double r = (Double)this.rv.visit(b);
            a.setValue(r);
            Assert.assertTrue(r.doubleValue() == a.getValue());
            ++i;
        }
        a.setValue(ov);
    }

    public void testFloatAccessor(FloatAccessor a) throws Exception {
        float ov = a.getValue();
        FloatBinding b = Bindings.FLOAT;
        int i = 0;
        while (i < 10) {
            Float r = (Float)this.rv.visit(b);
            a.setValue(r.floatValue());
            Assert.assertTrue(r.floatValue() == a.getValue());
            ++i;
        }
        a.setValue(ov);
    }

    public void testIntegerAccessor(IntegerAccessor a) throws Exception {
        int ov = a.getValue();
        IntegerBinding b = Bindings.INTEGER;
        int i = 0;
        while (i < 10) {
            Integer r = (Integer)this.rv.visit(b);
            a.setValue(r);
            Assert.assertTrue(r.intValue() == a.getValue());
            ++i;
        }
        a.setValue(ov);
    }

    public void testLongAccessor(LongAccessor a) throws Exception {
        long ov = a.getValue();
        LongBinding b = Bindings.LONG;
        int i = 0;
        while (i < 10) {
            Long r = (Long)this.rv.visit(b);
            a.setValue(r);
            Assert.assertTrue(r.longValue() == a.getValue());
            ++i;
        }
        a.setValue(ov);
    }

    public void testStringAccessor(StringAccessor a) throws Exception {
        String ov = a.getValue();
        StringBinding b = Bindings.STRING;
        int i = 0;
        while (i < 10) {
            String r = (String)this.rv.visit(b);
            a.setValue(r);
            Assert.assertEquals(r, a.getValue());
            ++i;
        }
        a.setValue(ov);
    }

    public void testBooleanAccessor(BooleanAccessor a) throws Exception {
        Boolean ov = a.getValue();
        BooleanBinding b = Bindings.BOOLEAN;
        int i = 0;
        while (i < 10) {
            Boolean r = (Boolean)this.rv.visit(b);
            a.setValue(r);
            Assert.assertEquals(r, a.getValue());
            ++i;
        }
        a.setValue(ov);
    }
}

